/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.catalog.languages;

import java.util.Iterator;
import java.util.StringTokenizer;
import org.gvsig.catalog.languages.AbstractGeneralLanguage;

public class CommonQueryLanguage
extends AbstractGeneralLanguage {
    public void addClauses(String parameter, String line, String concordancia, String operator) {
        this.currentClause = null;
        Iterator values = this.parseValues(line, concordancia);
        this.addClauses(parameter, values, concordancia, operator);
    }

    public void addClauses(String parameter, Iterator values, String concordancia, String operator) {
        while (values.hasNext()) {
            this.addTerm(parameter, (String)values.next(), concordancia);
        }
        this.addCurrentClauseQuery(operator);
    }

    private void addTerm(String parameter, String value, String concordancia) {
        StringBuffer term = new StringBuffer();
        term.append(parameter + "=" + this.cutWord(value, concordancia));
        this.currentClause = this.currentClause == null ? term.toString() : "(" + this.currentClause + " " + this.getOperator(concordancia) + " " + term.toString() + ")";
    }

    protected void addCurrentClauseQuery(String operator) {
        if (this.currentClause != null) {
            this.currentQuery = this.currentQuery == null ? this.currentClause : "(" + this.currentQuery + " " + operator + " " + this.currentClause + ")";
        }
    }

    @Override
    public String toString() {
        return this.currentQuery;
    }

    public String cutWord(String line, String titleKeys) {
        if (titleKeys.equals("E")) {
            StringTokenizer sti = new StringTokenizer(line, " ", true);
            boolean first = true;
            String token = "";
            while (sti.hasMoreTokens()) {
                String currentToken = sti.nextToken();
                if (first) {
                    token = currentToken;
                    first = !first;
                    continue;
                }
                if (currentToken.equals(" ")) continue;
                token = "(" + token + " and " + currentToken + ")";
            }
            return token;
        }
        return line;
    }
}

