/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.catalog.metadataxml;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.gvsig.catalog.metadataxml.XMLNode;
import org.gvsig.catalog.utils.Strings;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class XMLTree {
    public static final String SEPARATOR = "->";

    public static XMLNode xmlToTree(File file) {
        try {
            return new XMLNode(file);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static XMLNode xmlToTree(InputStream stream) {
        try {
            return new XMLNode(stream);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static XMLNode xmlToTree(InputSource source) {
        try {
            return new XMLNode(source);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static XMLNode xmlToTree(String string) {
        try {
            return new XMLNode(new ByteArrayInputStream(string.getBytes()));
        }
        catch (Exception e) {
            string = Strings.replace(string, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>", "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
            try {
                return new XMLNode(new ByteArrayInputStream(string.getBytes()));
            }
            catch (Exception e1) {
                e1.printStackTrace();
                return null;
            }
        }
    }

    public static File treeToXML(Document dom, String nombreFichero) {
        OutputFormat format = null;
        StringWriter stringOut = null;
        XMLSerializer serial = null;
        FileWriter file = null;
        File file_answer = new File(nombreFichero);
        format = new OutputFormat(dom);
        format.setEncoding("ISO-8859-1");
        format.setIndent(5);
        stringOut = new StringWriter();
        serial = new XMLSerializer((Writer)stringOut, format);
        try {
            serial.asDOMSerializer();
            serial.serialize(dom);
            file = new FileWriter(file_answer);
            file.write(stringOut.toString());
            file.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return file_answer;
    }

    public static XMLNode searchNode(XMLNode nodoRaiz, String etiqueta) {
        XMLNode[] nodes = XMLTree.searchMultipleNode(nodoRaiz, etiqueta);
        if (nodes != null && nodes.length > 0) {
            return nodes[0];
        }
        return null;
    }

    public static XMLNode searchParentNode(XMLNode rootNode, String label) {
        StringTokenizer sti = new StringTokenizer(label, SEPARATOR);
        if (rootNode == null) {
            return null;
        }
        XMLNode currentNode = rootNode.getSubNode(0);
        XMLNode parentNode = rootNode;
        int niveles = sti.countTokens();
        String nombreNodo = XMLTree.cutNamespace(sti.nextToken());
        int nivelActual = 1;
        int i = 0;
        while (i < parentNode.getNumSubNodes()) {
            if (nombreNodo.equals(XMLTree.cutNamespace(currentNode.getName()))) {
                if (niveles == nivelActual) {
                    return parentNode;
                }
                parentNode = currentNode;
                currentNode = currentNode.getSubNode(0);
                nombreNodo = sti.nextToken();
                ++nivelActual;
                i = 0;
                continue;
            }
            currentNode = currentNode.getSubNode(i);
            ++i;
        }
        return null;
    }

    public static String searchAtribute(XMLNode node, String attributeName) {
        return node.getAttribute(attributeName);
    }

    public static String searchNodeValue(XMLNode node, String etiqueta) {
        XMLNode nodoB = XMLTree.searchNode(node, etiqueta);
        if (nodoB == null) {
            return null;
        }
        return nodoB.getText();
    }

    public static String searchNodeAtribute(XMLNode node, String etiqueta, String atributo) {
        XMLNode nodoB = XMLTree.searchNode(node, etiqueta);
        if (nodoB == null) {
            return null;
        }
        return XMLTree.searchAtribute(nodoB, atributo);
    }

    public static String[] searchMultipleNodeValue(XMLNode rootNode, String label) {
        XMLNode[] nodes = XMLTree.searchMultipleNode(rootNode, label);
        if (nodes == null || nodes.length == 0) {
            return null;
        }
        String[] values = new String[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            values[i] = nodes[i].getText();
        }
        return values;
    }

    public static XMLNode[] searchMultipleNode(XMLNode nodoRaiz, String label) {
        ArrayList rootNodes = new ArrayList();
        ArrayList<XMLNode> leafNodes = new ArrayList<XMLNode>();
        String firstLabel = null;
        leafNodes.add(nodoRaiz);
        int level = XMLTree.getLevelNumber(label);
        for (int k = 1; k <= level; ++k) {
            firstLabel = XMLTree.cutNamespace(XMLTree.getParentLabel(label));
            label = XMLTree.getChildLabel(label);
            rootNodes = new ArrayList(leafNodes);
            leafNodes.clear();
            for (int i = 0; i < rootNodes.size(); ++i) {
                XMLNode root = (XMLNode)rootNodes.get(i);
                if (root == null) continue;
                XMLNode[] nodes = root.getSubnodes();
                for (int j = 0; j < nodes.length; ++j) {
                    if (!XMLTree.cutNamespace(nodes[j].getName()).equals(firstLabel)) continue;
                    leafNodes.add(nodes[j]);
                }
            }
        }
        XMLNode[] nodes = new XMLNode[leafNodes.size()];
        for (int i = 0; i < leafNodes.size(); ++i) {
            nodes[i] = (XMLNode)leafNodes.get(i);
        }
        return nodes;
    }

    private static String getParentLabel(String nodeLabel) {
        return XMLTree.separateParams(nodeLabel, SEPARATOR)[0];
    }

    private static String[] separateParams(String text, String separator) {
        return text.split(separator);
    }

    private static String getChildLabel(String nodeLabel) {
        String st = null;
        String[] labels = XMLTree.separateParams(nodeLabel, SEPARATOR);
        if (labels.length == 1) {
            return labels[0];
        }
        st = labels[1];
        for (int i = 2; i < labels.length; ++i) {
            st = st + SEPARATOR + labels[i];
        }
        return st;
    }

    private static int getLevelNumber(String nodeLabel) {
        String[] labels = XMLTree.separateParams(nodeLabel, SEPARATOR);
        return labels.length;
    }

    private static String cutNamespace(String label) {
        if (label == null) {
            return null;
        }
        int i = label.indexOf(":");
        if (i > 0) {
            return label.substring(i + 1, label.length());
        }
        return label;
    }
}

