/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.catalog.ui.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.gvsig.catalog.CatalogClient;
import org.gvsig.catalog.drivers.GetRecordsReply;
import org.gvsig.catalog.querys.CatalogQuery;
import org.gvsig.catalog.querys.MetadataSearch;
import org.gvsig.catalog.ui.search.SearchButtonPanel;
import org.gvsig.catalog.ui.search.SearchLowerPanel;
import org.gvsig.catalog.ui.search.SearchUpperPanel;
import org.gvsig.catalog.ui.showresults.ShowResultsDialog;
import org.gvsig.i18n.Messages;

public class SearchDialogPanel
extends JPanel
implements ActionListener {
    private JFrame parent;
    private final CatalogQuery query = null;
    protected Object serverConnectFrame;
    protected SearchUpperPanel upperPanel = null;
    protected SearchLowerPanel lowerPanel = null;
    protected SearchButtonPanel buttonsPanel = null;
    protected CatalogClient client = null;
    protected boolean isMinimized = true;
    private Collection searchThreads = new ArrayList();
    private String currentServer = null;
    private GetRecordsReply recordsReply = null;

    public SearchDialogPanel(CatalogClient client, Object serverConnectFrame) {
        this.client = client;
        this.isMinimized = true;
        this.serverConnectFrame = serverConnectFrame;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getUpperPanel(), "North");
        this.add((Component)this.getLowerPanel(), "Center");
        this.add((Component)this.getButtonPanel(), "South");
        this.getLowerPanel().setVisible(false);
    }

    public SearchUpperPanel getUpperPanel() {
        if (this.upperPanel == null) {
            this.upperPanel = new SearchUpperPanel();
            this.upperPanel.addActionListener(this);
        }
        return this.upperPanel;
    }

    public SearchLowerPanel getLowerPanel() {
        if (this.lowerPanel == null) {
            this.lowerPanel = new SearchLowerPanel(this.client.getAditionalSearchPanel());
            this.lowerPanel.addCoordinatesRelationship(Messages.getText((String)"coordinatesContains"));
            this.lowerPanel.addCoordinatesRelationship(Messages.getText((String)"coordinatesFullyOutsideOf"));
            this.addServices();
            this.addCathegories();
            this.addScales();
        }
        return this.lowerPanel;
    }

    private void addServices() {
        this.upperPanel.addService(new MetadataSearch(Messages.getText((String)"data")));
    }

    private void addCathegories() {
        this.lowerPanel.addCathegory(Messages.getText((String)"cathegoryAny"));
        this.lowerPanel.addCathegory(Messages.getText((String)"cathegoryBiota"));
        this.lowerPanel.addCathegory(Messages.getText((String)"cathegoryBoundaries"));
        this.lowerPanel.addCathegory(Messages.getText((String)"cathegoryClimatologyMeteorologyAtmosphere"));
        this.lowerPanel.addCathegory(Messages.getText((String)"cathegoryEconomy"));
        this.lowerPanel.addCathegory(Messages.getText((String)"cathegoryElevation"));
        this.lowerPanel.addCathegory(Messages.getText((String)"cathegoryEnvironment"));
        this.lowerPanel.addCathegory(Messages.getText((String)"cathegoryFarming"));
        this.lowerPanel.addCathegory(Messages.getText((String)"cathegoryGeoscientificInformation"));
        this.lowerPanel.addCathegory(Messages.getText((String)"cathegoryHealth"));
        this.lowerPanel.addCathegory(Messages.getText((String)"cathegoryImageryBaseMapsEarthCover"));
        this.lowerPanel.addCathegory(Messages.getText((String)"cathegoryInlandWaters"));
        this.lowerPanel.addCathegory(Messages.getText((String)"cathegoryIntelligenceMilitary"));
        this.lowerPanel.addCathegory(Messages.getText((String)"cathegoryLocation"));
        this.lowerPanel.addCathegory(Messages.getText((String)"cathegoryOceans"));
        this.lowerPanel.addCathegory(Messages.getText((String)"cathegoryPlanningCadastre"));
        this.lowerPanel.addCathegory(Messages.getText((String)"cathegorySociety"));
        this.lowerPanel.addCathegory(Messages.getText((String)"cathegoryStructure"));
        this.lowerPanel.addCathegory(Messages.getText((String)"cathegoryTransportation"));
        this.lowerPanel.addCathegory(Messages.getText((String)"cathegoryUtilitiesCommunication"));
    }

    private void addScales() {
        this.lowerPanel.addScale(Messages.getText((String)"scaleAny"));
        this.lowerPanel.addScale(Messages.getText((String)"scaleI"));
        this.lowerPanel.addScale(Messages.getText((String)"scaleII"));
        this.lowerPanel.addScale(Messages.getText((String)"scaleIII"));
        this.lowerPanel.addScale(Messages.getText((String)"scaleIV"));
        this.lowerPanel.addScale(Messages.getText((String)"scaleV"));
        this.lowerPanel.addScale(Messages.getText((String)"scaleVI"));
    }

    public JPanel getButtonPanel() {
        if (this.buttonsPanel == null) {
            this.buttonsPanel = new SearchButtonPanel();
            this.buttonsPanel.addActionListener(this);
        }
        return this.buttonsPanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().compareTo("search") == 0) {
            this.searchButtonActionPerformed();
        } else if (e.getActionCommand().compareTo("close") == 0) {
            this.closeButtonActionPerformed();
        } else if (e.getActionCommand().compareTo("cancel") == 0) {
            this.cancelSearchesButtonActionPerformed();
        } else if (e.getActionCommand().compareTo("previous") == 0) {
            this.lastButtonActionPerformed();
        }
    }

    protected void searchButtonActionPerformed() {
        SearchThread st = new SearchThread();
        this.searchThreads.add(st);
        this.setCursor(new Cursor(3));
    }

    protected void lastButtonActionPerformed() {
        ((JFrame)this.serverConnectFrame).setVisible(true);
        this.parent.setVisible(false);
    }

    protected void cancelSearchesButtonActionPerformed() {
        for (int i = 0; i < this.searchThreads.size(); ++i) {
            SearchThread st = (SearchThread)this.searchThreads.toArray()[i];
            st.stop();
        }
        this.searchThreads.clear();
        this.setCursor(new Cursor(0));
    }

    protected void closeButtonActionPerformed() {
        this.parent.setVisible(false);
    }

    protected CatalogQuery doQuery() {
        CatalogQuery query = this.client.createNewQuery();
        query.setService(this.upperPanel.getService());
        query.setTitle(this.upperPanel.getTitle());
        query.setTitleFilter(this.lowerPanel.getTitleOption());
        query.setAbstract(this.lowerPanel.getAbstract());
        query.setThemeKey(this.lowerPanel.getKeys());
        query.setTopic(this.lowerPanel.getCathegory());
        query.setScale(this.lowerPanel.getScale());
        query.setProvider(this.lowerPanel.getProvider());
        query.setDateFrom(this.lowerPanel.getDateFrom());
        query.setDateTo(this.lowerPanel.getDateTo());
        query.setCoordenates(this.lowerPanel.getCoordinates());
        query.setCoordenatesFilter(this.lowerPanel.getCoordinatesOption());
        query.setMinimized(this.isMinimized);
        query.setCoordinatesClicked(this.upperPanel.getRestrictAreaClicked());
        return query;
    }

    private void doSearch() throws Exception {
        this.recordsReply = this.client.getRecords(this.doQuery(), 1);
        if (this.recordsReply == null) {
            JOptionPane.showMessageDialog(this, Messages.getText((String)"errorGetRecords"), "Error", 0);
        } else if (this.recordsReply.getRecordsNumber() == 0) {
            JOptionPane.showMessageDialog(this, Messages.getText((String)"anyResult"), Messages.getText((String)"catalog_search"), 1);
        }
    }

    protected void showResultsActionPerformed(GetRecordsReply recordsReply) {
        new ShowResultsDialog(this.client, recordsReply, 1);
    }

    public void setParent(JFrame parent) {
        this.parent = parent;
    }

    public CatalogQuery getQuery() {
        return this.query;
    }

    public String getCurrentServer() {
        return this.currentServer;
    }

    public void setCurrentServer(String currentServer) {
        this.currentServer = currentServer;
    }

    private class SearchThread
    implements Runnable {
        volatile Thread myThread = new Thread(this);

        public SearchThread() {
            this.myThread.start();
        }

        public void stop() {
            this.myThread.stop();
        }

        @Override
        public void run() {
            try {
                SearchDialogPanel.this.doSearch();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (SearchDialogPanel.this.recordsReply != null && SearchDialogPanel.this.recordsReply.getRecordsNumber() > 0) {
                SearchDialogPanel.this.showResultsActionPerformed(SearchDialogPanel.this.recordsReply);
            }
            SearchDialogPanel.this.searchThreads.remove(this);
            if (SearchDialogPanel.this.searchThreads.size() == 0) {
                SearchDialogPanel.this.setCursor(new Cursor(0));
            }
        }
    }
}

