/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.catalog.z3950.drivers;

import java.io.ByteArrayInputStream;
import java.net.URI;
import java.util.ArrayList;
import org.gvsig.catalog.drivers.AbstractCatalogServiceDriver;
import org.gvsig.catalog.drivers.CatalogCapabilities;
import org.gvsig.catalog.drivers.DiscoveryServiceCapabilities;
import org.gvsig.catalog.drivers.GetRecordsReply;
import org.gvsig.catalog.metadataxml.XMLNode;
import org.gvsig.catalog.metadataxml.XMLTree;
import org.gvsig.catalog.protocols.Z3950Protocol;
import org.gvsig.catalog.querys.CatalogQuery;
import org.gvsig.catalog.z3950.drivers.Z3950Messages;

public class Z3950CatalogServiceDriver
extends AbstractCatalogServiceDriver {
    @Override
    public DiscoveryServiceCapabilities getCapabilities(URI uri) {
        ArrayList<XMLNode> nodes = new ArrayList<XMLNode>();
        Z3950Messages messages = new Z3950Messages(this);
        String message = messages.getCapabilities(new Z3950Protocol().openConnection(uri));
        ByteArrayInputStream buffer = new ByteArrayInputStream(message.getBytes());
        nodes.add(XMLTree.xmlToTree(buffer));
        this.setServerAnswerReady(XMLTree.searchNodeValue((XMLNode)nodes.toArray()[0], "Servidor"));
        CatalogCapabilities capabilities = new CatalogCapabilities();
        capabilities.setVersion("3.0");
        return capabilities;
    }

    @Override
    public GetRecordsReply getRecords(URI uri, CatalogQuery query, int firstRecord) {
        this.setQuery(query);
        Z3950Messages messages = new Z3950Messages(this);
        String message = messages.getRecords(this.getQuery(), Z3950Protocol.getDatabase(uri));
        System.out.println(message);
        new Z3950Protocol().doQuery(this.getRecordsReply(), uri, message, firstRecord);
        return this.getRecordsReply();
    }

    @Override
    public boolean isProtocolSupported(URI uri) {
        return new Z3950Protocol().isProtocolSupported(uri);
    }

    public String getQueryProfile() {
        return "Z3950";
    }

    @Override
    public String getServiceName() {
        return "Z3950";
    }

    @Override
    public int getDefaultPort() {
        return 2100;
    }

    @Override
    public String getDefaultSchema() {
        return "z3950";
    }
}

