/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.raster.bean.previewbase;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.gui.beans.imagenavigator.ImageUnavailableException;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.swing.preview.DataSourcePreview;
import org.gvsig.tools.task.Cancellable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RasterDataSourcePreview
implements DataSourcePreview {
    private FLyrRaster lyr = null;
    private IProjection viewProjection = null;
    private static GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private static final Logger logger = LoggerFactory.getLogger(RasterDataSourcePreview.class);

    public RasterDataSourcePreview(FLyrRaster lyr, IProjection proj) {
        this.lyr = lyr;
        this.viewProjection = proj;
    }

    public void closePreviewLayer() {
        if (this.lyr != null) {
            this.lyr.setRemoveRasterFlag(true);
            this.lyr.removeLayerListener(null);
        }
    }

    public Rectangle2D getBBoxRectangle() {
        Extent e = this.lyr.getFullRasterExtent();
        return e.toRectangle2D();
    }

    public double getCellSize() {
        return this.lyr.getDataStore().getCellSize();
    }

    public DataSourcePreview cloneDataSourcePreview() {
        if (this.lyr != null) {
            try {
                IProjection viewProj = null;
                if (this.lyr.getMapContext() != null) {
                    viewProj = this.lyr.getMapContext().getProjection();
                }
                return new RasterDataSourcePreview((FLyrRaster)this.lyr.cloneLayer(), viewProj);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public void popStatus() {
        if (this.lyr != null) {
            this.lyr.getRender().getFilterList().popStatus();
        }
    }

    public void pushStatus() {
        if (this.lyr != null) {
            this.lyr.getRender().getFilterList().pushStatus();
        }
    }

    public void draw(BufferedImage image, Graphics2D g, double[] coords, int w, int h, Cancellable cancel, double scale) throws ImageUnavailableException {
        try {
            ViewPort vp = new ViewPort(this.viewProjection);
            try {
                Envelope env = geomManager.createEnvelope(coords[0], coords[3], coords[2], coords[1], 0);
                vp.setEnvelope(env);
            }
            catch (CreateEnvelopeException e3) {
                logger.error("Error drawing the image", (Throwable)e3);
            }
            vp.setImageSize(new Dimension(w, h));
            if (this.lyr != null) {
                this.lyr.setLayerInitialized(true);
                this.lyr.draw(image, g, vp, cancel, scale);
            }
        }
        catch (ReadException e) {
            throw new ImageUnavailableException("Error drawing raster");
        }
    }

    public Object getSource() {
        return this.lyr;
    }
}

