/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.raster.gui.preference.panel;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import org.gvsig.fmap.dal.coverage.RasterLibrary;
import org.gvsig.raster.mainplugin.config.Configuration;
import org.gvsig.raster.util.BasePanel;

public class PreferenceGeneral
extends BasePanel {
    private static final long serialVersionUID = 1L;
    private JCheckBox checkBoxPreview = null;
    private JLabel labelNumClases = null;
    private JComboBox comboBoxNumClases = null;

    public PreferenceGeneral() {
        this.init();
        this.translate();
    }

    protected void translate() {
        this.setBorder(BorderFactory.createTitledBorder(this.getText((Object)this, "general")));
        this.getCheckBoxPreview().setText(this.getText((Object)this, "previsualizar_automaticamente_raster"));
        this.getCheckBoxPreview().setToolTipText(this.getCheckBoxPreview().getText());
        this.getLabelNumClases().setText(this.getText((Object)this, "num_clases") + ":");
    }

    protected void init() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 2, 5);
        this.add(this.getCheckBoxPreview(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 5, 2, 2);
        this.add(this.getLabelNumClases(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 5);
        this.add(this.getComboBoxNumClases(), gridBagConstraints);
    }

    private JCheckBox getCheckBoxPreview() {
        if (this.checkBoxPreview == null) {
            this.checkBoxPreview = new JCheckBox();
            this.checkBoxPreview.setMargin(new Insets(0, 0, 0, 0));
        }
        return this.checkBoxPreview;
    }

    private JLabel getLabelNumClases() {
        if (this.labelNumClases == null) {
            this.labelNumClases = new JLabel();
        }
        return this.labelNumClases;
    }

    private JComboBox getComboBoxNumClases() {
        if (this.comboBoxNumClases == null) {
            this.comboBoxNumClases = new JComboBox();
            this.comboBoxNumClases.setModel(new DefaultComboBoxModel<String>(new String[]{"32", "64", "128", "256"}));
        }
        return this.comboBoxNumClases;
    }

    public void initializeDefaults() {
        this.getCheckBoxPreview().setSelected((Boolean)Configuration.getDefaultValue((String)"general_auto_preview"));
        Integer defaultNumberOfClasses = (Integer)Configuration.getDefaultValue((String)"general_defaultNumberOfClasses");
        for (int i = 0; i < this.getComboBoxNumClases().getItemCount(); ++i) {
            if (!this.getComboBoxNumClases().getItemAt(i).toString().equals(defaultNumberOfClasses.toString())) continue;
            this.getComboBoxNumClases().setSelectedIndex(i);
            break;
        }
    }

    public void initializeValues() {
        this.getCheckBoxPreview().setSelected(Configuration.getValue((String)"general_auto_preview", (Boolean)true));
        Integer defaultNumberOfClasses = Configuration.getValue((String)"general_defaultNumberOfClasses", (Integer)RasterLibrary.defaultNumberOfClasses);
        for (int i = 0; i < this.getComboBoxNumClases().getItemCount(); ++i) {
            if (!this.getComboBoxNumClases().getItemAt(i).toString().equals(defaultNumberOfClasses.toString())) continue;
            this.getComboBoxNumClases().setSelectedIndex(i);
            break;
        }
    }

    public void storeValues() {
        Configuration.setValue((String)"general_auto_preview", (Object)this.getCheckBoxPreview().isSelected());
        int nClasses = Integer.valueOf(this.getComboBoxNumClases().getSelectedItem().toString());
        Configuration.setValue((String)"general_defaultNumberOfClasses", (Object)nClasses);
        RasterLibrary.defaultNumberOfClasses = nClasses;
    }
}

