/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.raster.gui.preference.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.gvsig.andami.PluginServices;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.gui.beans.swing.JFileChooser;
import org.gvsig.raster.mainplugin.config.Configuration;
import org.gvsig.raster.util.BasePanel;

public class PreferenceTemporal
extends BasePanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JLabel labelTemporales = null;
    private JButton buttonOpen = null;
    private JTextField textFieldDirectory = null;

    public PreferenceTemporal() {
        this.init();
        this.translate();
    }

    protected void translate() {
        this.setBorder(BorderFactory.createTitledBorder(this.getText(this, "rutas")));
        this.getLabelTemporales().setText(this.getText(this, "temporales") + ":");
        this.getButtonOpen().setText(this.getText(this, "seleccionar_directorio"));
    }

    protected void init() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 2);
        this.add(this.getLabelTemporales(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 2, 5, 2);
        this.add(this.getTextFieldDirectory(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 2, 5, 5);
        this.add(this.getButtonOpen(), gridBagConstraints);
    }

    private JLabel getLabelTemporales() {
        if (this.labelTemporales == null) {
            this.labelTemporales = new JLabel();
        }
        return this.labelTemporales;
    }

    private JButton getButtonOpen() {
        if (this.buttonOpen == null) {
            this.buttonOpen = new JButton();
            this.buttonOpen.addActionListener(this);
        }
        return this.buttonOpen;
    }

    private JTextField getTextFieldDirectory() {
        if (this.textFieldDirectory == null) {
            this.textFieldDirectory = new JTextField();
            this.textFieldDirectory.setEditable(false);
            this.textFieldDirectory.setPreferredSize(new Dimension(0, this.textFieldDirectory.getPreferredSize().height));
        }
        return this.textFieldDirectory;
    }

    public void initializeDefaults() {
        File file = new File((String)Configuration.getDefaultValue((String)"path_temp_cache_directory"));
        if (!file.exists()) {
            file.mkdir();
        }
        this.getTextFieldDirectory().setText(file.getAbsolutePath());
    }

    public void initializeValues() {
        File file = new File(Configuration.getValue((String)"path_temp_cache_directory", (String)RasterLocator.getManager().getFileUtils().getTemporalPath()));
        if (!file.exists()) {
            file.mkdir();
        }
        this.getTextFieldDirectory().setText(file.getAbsolutePath());
    }

    public void storeValues() {
        Configuration.setValue((String)"path_temp_cache_directory", (Object)this.getTextFieldDirectory().getText());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser chooser = new JFileChooser(this.getClass().getName(), new File(this.getTextFieldDirectory().getText()));
        chooser.setFileSelectionMode(1);
        chooser.setDialogTitle(PluginServices.getText((Object)this, (String)"seleccionar_directorio"));
        if (chooser.showOpenDialog((Component)((Object)this)) == 0) {
            this.getTextFieldDirectory().setText(chooser.getSelectedFile().getAbsolutePath());
        }
        JFileChooser.setLastPath((String)this.getClass().getName(), (File)new File(this.getTextFieldDirectory().getText()));
    }
}

