/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.raster.process;

import javax.swing.SwingUtilities;
import org.gvsig.andami.PluginServices;
import org.gvsig.fmap.dal.coverage.datastruct.BufferHistogram;
import org.gvsig.fmap.dal.coverage.exception.HistogramException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.store.props.HistogramComputer;
import org.gvsig.raster.tools.app.basic.raster.process.ProcessException;
import org.gvsig.raster.tools.app.basic.raster.process.RasterProcess;

public class HistogramProcess
extends RasterProcess {
    private BufferHistogram lastHistogram = null;
    private HistogramComputer histogramable = null;

    @Override
    public void init() {
        this.histogramable = (HistogramComputer)this.getParam("histogramable");
    }

    @Override
    public void process() throws ProcessInterruptedException, ProcessException {
        try {
            this.lastHistogram = this.histogramable.getBufferHistogram();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (HistogramProcess.this.externalActions != null && HistogramProcess.this.lastHistogram != null) {
                        HistogramProcess.this.externalActions.end(HistogramProcess.this.lastHistogram);
                    }
                }
            });
        }
        catch (HistogramException e) {
            throw new ProcessException("Error calculando el histograma", e);
        }
    }

    @Override
    public Object getResult() {
        return this.lastHistogram;
    }

    @Override
    public String getLog() {
        return PluginServices.getText((Object)this, (String)"calculando_histograma") + "...\n";
    }

    public int getPercent() {
        if (this.histogramable != null) {
            return this.histogramable.getPercent();
        }
        return 0;
    }

    public String getTitle() {
        return PluginServices.getText((Object)this, (String)"calculando_histograma");
    }

    @Override
    protected void finalize() throws Throwable {
        this.lastHistogram = null;
        this.histogramable = null;
        super.finalize();
    }
}

