/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.raster.process;

import java.io.File;
import java.net.URI;
import org.gvsig.andami.PluginServices;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.exception.OverviewException;
import org.gvsig.fmap.dal.coverage.process.BaseIncrementableTask;
import org.gvsig.fmap.dal.coverage.process.overview.OverviewBuilder;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.mainplugin.config.Configuration;
import org.gvsig.raster.tools.app.basic.raster.process.ProcessException;
import org.gvsig.raster.tools.app.basic.raster.process.RasterProcess;

public class OverviewsProcess
extends RasterProcess
implements BaseIncrementableTask {
    private FLyrRaster rasterSE = null;
    private int value = 0;
    private int resamplingAlg = 1;
    private int[] overviews = new int[]{2, 4, 8, 16};
    private String builder = "GDAL";

    @Override
    public void init() {
        this.rasterSE = this.getLayerParam("layer");
        this.builder = this.getStringParam("builder") != null ? this.getStringParam("builder") : this.builder;
        int overviewsRate = 2;
        int nOverviews = 4;
        overviewsRate = Configuration.getValue((String)"overviews_rate", (Integer)new Integer(overviewsRate));
        nOverviews = Configuration.getValue((String)"overviews_number", (Integer)new Integer(nOverviews));
        this.resamplingAlg = Configuration.getValue((String)"overviews_resampling_algorithm", (Integer)new Integer(this.resamplingAlg));
        this.overviews = new int[nOverviews];
        this.overviews[0] = overviewsRate;
        for (int i = 1; i < nOverviews; ++i) {
            this.overviews[i] = overviewsRate * this.overviews[i - 1];
        }
    }

    @Override
    public void process() throws ProcessException {
        this.insertLineLog(PluginServices.getText((Object)this, (String)"overviews_generating"));
        OverviewBuilder overviewBuilder = RasterLocator.getManager().getOverviewBuilder(this.builder);
        overviewBuilder.setIncrementListener((BaseIncrementableTask)this);
        try {
            URI[] uri = this.rasterSE.getDataStore().getURIByProvider();
            for (int i = 0; i < uri.length; ++i) {
                this.insertLineLog(" Dataset: " + i);
                overviewBuilder.buildOverviews(this.resamplingAlg, new File(uri[i]).getAbsolutePath(), this.overviews);
            }
            if (this.externalActions != null) {
                this.externalActions.end(this.rasterSE);
            }
        }
        catch (OverviewException e) {
            if (this.incrementableTask != null) {
                this.incrementableTask.hideWindow();
            }
            throw new ProcessException("error_write_overviews", e);
        }
    }

    public int getPercent() {
        return this.value;
    }

    public void setPercent(int value) {
        this.value = value;
    }

    public String getTitle() {
        return PluginServices.getText((Object)this, (String)"incremento_overview");
    }

    @Override
    protected void finalize() throws Throwable {
        this.rasterSE = null;
        this.overviews = null;
        super.finalize();
    }
}

