/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.raster.process;

import java.util.Date;
import java.util.EventObject;
import java.util.Hashtable;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.process.CancelEvent;
import org.gvsig.fmap.dal.coverage.process.TaskEventManager;
import org.gvsig.gui.beans.incrementabletask.IIncrementable;
import org.gvsig.gui.beans.incrementabletask.IncrementableEvent;
import org.gvsig.gui.beans.incrementabletask.IncrementableListener;
import org.gvsig.gui.beans.incrementabletask.IncrementableTask;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.tools.app.basic.raster.process.IProcessActions;
import org.gvsig.raster.tools.app.basic.raster.process.ProcessException;
import org.gvsig.tools.dispose.Disposable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RasterProcess
implements IIncrementable,
IncrementableListener,
Runnable,
Disposable {
    protected IncrementableTask incrementableTask = null;
    protected volatile Thread blinker = null;
    protected TaskEventManager taskEventManager = null;
    protected IProcessActions externalActions = null;
    protected Hashtable<String, Object> taskParams = new Hashtable();
    private String log = "";
    private String lastLine = "";
    private long time = 0L;
    private boolean progressActive = true;
    private IProcessActions queueActions = null;
    private Logger logger = LoggerFactory.getLogger((String)RasterProcess.class.toString());

    public IncrementableTask getIncrementableTask() {
        if (this.incrementableTask == null) {
            this.incrementableTask = new IncrementableTask((IIncrementable)this);
            this.incrementableTask.addIncrementableListener((IncrementableListener)this);
        }
        return this.incrementableTask;
    }

    public void setCancelable(boolean enabled) {
        this.getIncrementableTask().getButtonsPanel().setEnabled(2, enabled);
    }

    public void showIncrementableWindow() {
        if (this.progressActive) {
            this.getIncrementableTask().showWindow();
            this.getIncrementableTask().start();
        }
    }

    public void start() {
        this.showIncrementableWindow();
        if (this.blinker == null) {
            this.blinker = new Thread(this);
        }
        this.blinker.start();
    }

    public abstract void init();

    public abstract void process() throws ProcessInterruptedException, ProcessException;

    public Object getResult() {
        return null;
    }

    public void execute() throws ProcessInterruptedException, ProcessException {
        this.init();
        this.process();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long t1 = new Date().getTime();
        try {
            this.taskEventManager = RasterLocator.getManager().createRasterTask((Object)this);
            this.execute();
        }
        catch (ProcessInterruptedException e) {
            if (this.externalActions != null) {
                this.externalActions.interrupted();
            }
            Thread.currentThread().interrupt();
        }
        catch (ProcessException e) {
            if (this.progressActive && this.incrementableTask != null) {
                this.getIncrementableTask().processFinalize();
                this.incrementableTask = null;
            }
            this.logger.warn(RasterLocator.getManager().getRasterUtils().getTrace((Exception)e));
            if (e.getMessage() != null && e.getMessage().compareTo("") != 0) {
                RasterSwingLibrary.messageBoxError((String)e.getMessage(), (Object)this);
            } else {
                RasterSwingLibrary.messageBoxError((String)"error_processing", (Object)this);
            }
            this.queueActions = null;
        }
        catch (Exception e) {
            if (this.progressActive && this.incrementableTask != null) {
                this.getIncrementableTask().processFinalize();
                this.incrementableTask = null;
            }
            this.logger.warn(RasterLocator.getManager().getRasterUtils().getTrace(e));
            if (e.getMessage() != null && e.getMessage().compareTo("") != 0) {
                RasterSwingLibrary.messageBoxError((String)e.getMessage(), (Object)this);
            } else {
                RasterSwingLibrary.messageBoxError((String)"error_processing", (Object)this);
            }
            this.queueActions = null;
        }
        finally {
            this.taskEventManager.removeTask();
            if (this.progressActive && this.incrementableTask != null) {
                this.getIncrementableTask().processFinalize();
            }
            if (this.queueActions != null) {
                this.queueActions.end(this);
            }
            this.time = new Date().getTime() - t1;
            this.blinker = null;
        }
    }

    public void setProgressActive(boolean active) {
        this.progressActive = active;
    }

    public long getTime() {
        return this.time;
    }

    public IProcessActions getActions() {
        return this.externalActions;
    }

    public void setActions(IProcessActions actions) {
        this.externalActions = actions;
    }

    public IProcessActions getUniqueProcessActions() {
        return this.queueActions;
    }

    public void setUniqueProcessActions(IProcessActions actions) {
        this.queueActions = actions;
    }

    protected void insertLineLog(String line) {
        this.lastLine = line;
        this.log = this.log + line + "\n";
    }

    public String getLabel() {
        return this.lastLine;
    }

    public String getLog() {
        return this.log;
    }

    public void actionCanceled(IncrementableEvent e) {
        this.taskEventManager.setEvent((EventObject)new CancelEvent((Object)this));
    }

    public void addParam(String name, Object param) {
        if (param != null) {
            this.taskParams.put(name, param);
        } else {
            this.taskParams.remove(name);
        }
    }

    public void removeParam(String name) {
        this.taskParams.remove(name);
    }

    public Object getParam(String name) {
        return this.taskParams.get(name);
    }

    public String getStringParam(String name) {
        Object value = this.taskParams.get(name);
        return value != null && value instanceof String ? (String)value : null;
    }

    public byte getByteParam(String name) {
        Object value = this.taskParams.get(name);
        return value != null && value instanceof Byte ? (Byte)value : (byte)0;
    }

    public float getFloatParam(String name) {
        Object value = this.taskParams.get(name);
        return value != null && value instanceof Float ? ((Float)value).floatValue() : 0.0f;
    }

    public double getDoubleParam(String name) {
        Object value = this.taskParams.get(name);
        return value != null && value instanceof Double ? (Double)value : 0.0;
    }

    public int getIntParam(String name) {
        Object value = this.taskParams.get(name);
        return value != null && value instanceof Integer ? (Integer)value : 0;
    }

    public boolean getBooleanParam(String name) {
        Object value = this.taskParams.get(name);
        return value != null && value instanceof Boolean ? (Boolean)value : false;
    }

    public int[] getIntArrayParam(String name) {
        Object value = this.taskParams.get(name);
        return value != null && value instanceof int[] ? (int[])value : null;
    }

    public double[] getDoubleArrayParam(String name) {
        Object value = this.taskParams.get(name);
        return value != null && value instanceof double[] ? (double[])value : null;
    }

    public FLyrRaster getLayerParam(String name) {
        Object value = this.taskParams.get(name);
        return value != null && value instanceof FLyrRaster ? (FLyrRaster)value : null;
    }

    public Extent getExtentParam(String name) {
        Object value = this.taskParams.get(name);
        return value != null && value instanceof Extent ? (Extent)value : null;
    }

    public void actionResumed(IncrementableEvent e) {
    }

    public void actionSuspended(IncrementableEvent e) {
    }

    public boolean isCancelable() {
        return true;
    }

    public boolean isPausable() {
        return false;
    }

    public void dispose() {
        try {
            this.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void finalize() throws Throwable {
        this.incrementableTask = null;
        this.blinker = null;
        this.externalActions = null;
        if (this.taskParams != null) {
            this.taskParams.clear();
            this.taskParams = null;
        }
        this.log = null;
        this.lastLine = null;
        this.queueActions = null;
        this.logger = null;
        super.finalize();
    }
}

