/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.clip;

import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import org.gvsig.andami.PluginServices;
import org.gvsig.app.project.documents.view.gui.AbstractViewPanel;
import org.gvsig.app.project.documents.view.toc.AbstractTocContextMenuAction;
import org.gvsig.app.project.documents.view.toc.ITocItem;
import org.gvsig.app.project.documents.view.toolListeners.StatusBarListener;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.tools.Behavior.Behavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.MouseMovementBehavior;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PointListener;
import org.gvsig.fmap.mapcontrol.tools.Listeners.RectangleListener;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.fmap.layers.ILayerState;
import org.gvsig.raster.fmap.layers.IRasterLayerActions;
import org.gvsig.raster.fmap.tool.behavior.TransformedRectangleBehavior;
import org.gvsig.raster.mainplugin.toolbar.IGenericToolBarMenuItem;
import org.gvsig.raster.tools.app.basic.RasterToolsUtil;
import org.gvsig.raster.tools.app.basic.tool.clip.ClippingData;
import org.gvsig.raster.tools.app.basic.tool.clip.ui.ClippingDialog;
import org.gvsig.raster.tools.app.basic.tool.clip.ui.listener.ClippingMouseViewListener;
import org.gvsig.raster.tools.app.basic.tool.clip.ui.listener.ClippingPanelListener;

public class ClippingTocMenuEntry
extends AbstractTocContextMenuAction
implements IGenericToolBarMenuItem {
    private static ClippingTocMenuEntry singleton = null;

    private ClippingTocMenuEntry() {
    }

    public static ClippingTocMenuEntry getSingleton() {
        if (singleton == null) {
            singleton = new ClippingTocMenuEntry();
        }
        return singleton;
    }

    private void loadClippingListener(MapControl m_MapControl, ClippingMouseViewListener clippingMouseViewListener, FLyrRaster lyr) {
        StatusBarListener sbl = new StatusBarListener(m_MapControl);
        TransformedRectangleBehavior trb = new TransformedRectangleBehavior((RectangleListener)clippingMouseViewListener);
        AffineTransform at = lyr.getAffineTransform();
        trb.setAffineTransform(at);
        m_MapControl.addBehavior("clipRaster", new Behavior[]{trb, new MouseMovementBehavior((PointListener)sbl)});
    }

    public String getGroup() {
        return "RasterExport";
    }

    public int getGroupOrder() {
        return 50;
    }

    public int getOrder() {
        return 2;
    }

    public String getText() {
        return RasterToolsUtil.getText((Object)this, "recorte");
    }

    public boolean isEnabled(ITocItem item, FLayer[] selectedItems) {
        if (selectedItems == null || selectedItems.length != 1) {
            return false;
        }
        if (!(selectedItems[0] instanceof ILayerState)) {
            return false;
        }
        return ((ILayerState)selectedItems[0]).isOpen();
    }

    public boolean isVisible(ITocItem item, FLayer[] selectedItems) {
        if (selectedItems == null || selectedItems.length != 1) {
            return false;
        }
        if (!(selectedItems[0] instanceof IRasterLayerActions)) {
            return false;
        }
        return ((IRasterLayerActions)selectedItems[0]).isActionEnabled(1);
    }

    public void execute(ITocItem item, FLayer[] selectedItems) {
        FLayer fLayer = null;
        AbstractViewPanel theView = (AbstractViewPanel)PluginServices.getMDIManager().getActiveWindow();
        MapControl mapCtrl = theView.getMapControl();
        if (selectedItems.length != 1) {
            return;
        }
        fLayer = selectedItems[0];
        if (!(fLayer instanceof FLyrRaster)) {
            return;
        }
        ClippingDialog clippingDialog = new ClippingDialog(420, 290, fLayer.getName());
        ClippingPanelListener clippingPanelListener = new ClippingPanelListener(clippingDialog.getClippingPanel());
        clippingPanelListener.setLayer((FLyrRaster)fLayer);
        clippingDialog.getClippingPanel().setClippingListener(clippingPanelListener);
        ClippingData clippingData = new ClippingData();
        clippingPanelListener.setData(clippingData);
        clippingData.addObserver(clippingDialog.getClippingPanel());
        ClippingMouseViewListener clippingMouseViewListener = new ClippingMouseViewListener(mapCtrl, clippingDialog.getClippingPanel(), clippingData, (FLyrRaster)fLayer);
        this.loadClippingListener(mapCtrl, clippingMouseViewListener, (FLyrRaster)fLayer);
        clippingData.updateObservers();
        clippingDialog.getClippingPanel().getButtonsPanel().getButton(3).setEnabled(false);
        clippingDialog.getClippingPanel().getButtonsPanel().getButton(1).setEnabled(false);
        RasterToolsUtil.addWindow(clippingDialog);
    }

    public Icon getIcon() {
        return RasterToolsUtil.getIcon("layer-clip-raster");
    }
}

