/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.clip.ui.panel;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import org.gvsig.andami.PluginServices;
import org.gvsig.gui.beans.coordinatespanel.CoordinatesListener;
import org.gvsig.gui.beans.coordinatespanel.CoordinatesPanel;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.swing.RasterSwingLocator;
import org.gvsig.raster.swing.buttonbar.ButtonBar;
import org.gvsig.raster.tools.app.basic.tool.clip.ui.listener.ClippingPanelListener;

public class ClippingCoordinatesPanel
extends JPanel {
    private static final long serialVersionUID = -410791369185749893L;
    private CoordinatesPanel coordinatesPixel = null;
    private CoordinatesPanel coordinatesReales = null;
    private ButtonBar buttonBarContainer = null;

    public ClippingCoordinatesPanel() {
        this.initialize();
    }

    public void setClippingListener(ClippingPanelListener clippingPanelListener) {
        this.getPixelCoordinates().addValueChangedListener((CoordinatesListener)clippingPanelListener);
        this.getRealCoordinates().addValueChangedListener((CoordinatesListener)clippingPanelListener);
        this.getButtonBarContainer().getButton(0).addActionListener(clippingPanelListener);
        this.getButtonBarContainer().getButton(1).addActionListener(clippingPanelListener);
        this.getButtonBarContainer().getButton(2).addActionListener(clippingPanelListener);
        this.getButtonBarContainer().getButton(3).addActionListener(clippingPanelListener);
        this.getButtonBarContainer().getButton(4).addActionListener(clippingPanelListener);
        this.getButtonBarContainer().getButton(5).addActionListener(clippingPanelListener);
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 2, 5);
        this.add((Component)this.getPixelCoordinates(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.add((Component)this.getRealCoordinates(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(2, 5, 5, 5);
        this.add((Component)this.getButtonBarContainer(), gridBagConstraints);
    }

    public CoordinatesPanel getPixelCoordinates() {
        if (this.coordinatesPixel == null) {
            this.coordinatesPixel = new CoordinatesPanel();
            this.coordinatesPixel.setTitlePanel(Messages.getText((String)"coordenadas_pixel"));
        }
        return this.coordinatesPixel;
    }

    public CoordinatesPanel getRealCoordinates() {
        if (this.coordinatesReales == null) {
            this.coordinatesReales = new CoordinatesPanel();
            this.coordinatesReales.setTitlePanel(PluginServices.getText((Object)this, (String)"coordenadas_reales"));
        }
        return this.coordinatesReales;
    }

    public ButtonBar getButtonBarContainer() {
        if (this.buttonBarContainer == null) {
            this.buttonBarContainer = RasterSwingLocator.getSwingManager().createButtonBar();
            this.buttonBarContainer.addButton("view-export-image", Messages.getText((String)"load_parameters"), 0);
            this.buttonBarContainer.addButton("import-icon", Messages.getText((String)"save_parameters"), 1);
            this.buttonBarContainer.addButton("round-icon", Messages.getText((String)"round_pixels"), 2);
            this.buttonBarContainer.addButton("layer-modify-roi", Messages.getText((String)"adjust_to_rois"), 3);
            this.buttonBarContainer.addButton("fullextent-icon", Messages.getText((String)"fullExtent"), 4);
            this.buttonBarContainer.addButton("selecttool-icon", Messages.getText((String)"select_tool"), 5);
            this.buttonBarContainer.setButtonAlignment("right");
            this.buttonBarContainer.setComponentBorder(false);
        }
        return this.buttonBarContainer;
    }

    public void setCoordReal(String[] values) {
        this.getRealCoordinates().setValues(values);
    }

    public void setCoordPixel(String[] values) {
        this.getPixelCoordinates().setValues(values);
    }
}

