/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.colortable.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.gvsig.fmap.dal.coverage.store.props.Statistics;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.tools.app.basic.raster.process.IProcessActions;
import org.gvsig.raster.tools.app.basic.raster.process.StatisticsProcess;
import org.gvsig.raster.tools.app.basic.tool.colortable.data.ColorTableData;
import org.gvsig.raster.util.BasePanel;

public class ColorTableGlobalPanel
extends BasePanel
implements ActionListener,
PropertyChangeListener,
IProcessActions {
    private static final long serialVersionUID = 1L;
    private JCheckBox checkBoxInterpolated = null;
    private JCheckBox checkBoxEnabled = null;
    private ColorTableData colorTableData = null;
    private JCheckBox checkBoxLimits = null;
    private JFormattedTextField textFieldMinim = null;
    private JFormattedTextField textFieldMaxim = null;
    private JLabel labelMinim = null;
    private JLabel labelMaxim = null;
    private JButton buttonStatistics = null;
    private NumberFormat doubleDisplayFormat = null;
    private NumberFormat doubleEditFormat = null;
    private FLyrRaster fLayer = null;

    public ColorTableGlobalPanel() {
        this.init();
        this.translate();
    }

    public ColorTableGlobalPanel(ColorTableData colorTableData) {
        this.doubleDisplayFormat = NumberFormat.getNumberInstance();
        this.doubleDisplayFormat.setMinimumFractionDigits(0);
        this.doubleEditFormat = NumberFormat.getNumberInstance();
        this.colorTableData = colorTableData;
        this.init();
    }

    protected void init() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 2, 2, 5);
        this.add(this.getButtonStatistics(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 2, 2, 2);
        this.add(this.getTextFieldMinim(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 2, 2, 2);
        this.add(this.getTextFieldMaxim(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 2, 2);
        this.add(this.getLabelMinim(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 2, 2, 2);
        this.add(this.getLabelMaxim(), gridBagConstraints);
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 5, 5, 2);
        panel.add((Component)this.getCheckBoxEnabled(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 5, 5);
        panel.add((Component)this.getCheckBoxInterpolated(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 5, 5);
        panel.add((Component)this.getCheckBoxLimits(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 5, 5);
        this.add(panel, gridBagConstraints);
    }

    protected void translate() {
    }

    private JCheckBox getCheckBoxInterpolated() {
        if (this.checkBoxInterpolated == null) {
            this.checkBoxInterpolated = new JCheckBox(this.getText(this, "interpolado"));
            this.checkBoxInterpolated.setSelected(true);
            this.checkBoxInterpolated.addActionListener(this);
        }
        return this.checkBoxInterpolated;
    }

    private JButton getButtonStatistics() {
        if (this.buttonStatistics == null) {
            this.buttonStatistics = new JButton(this.getText(this, "recalc_stats"));
            this.buttonStatistics.addActionListener(this);
        }
        return this.buttonStatistics;
    }

    public JCheckBox getCheckBoxEnabled() {
        if (this.checkBoxEnabled == null) {
            this.checkBoxEnabled = new JCheckBox(this.getText(this, "activar_tablas_color"));
            this.checkBoxEnabled.setSelected(true);
            this.checkBoxEnabled.addActionListener(this);
        }
        return this.checkBoxEnabled;
    }

    public void setCheckBoxInterpolated(boolean b) {
        this.getCheckBoxInterpolated().setSelected(b);
        this.colorTableData.setInterpolated(b);
    }

    public void setCheckBoxEnabled(boolean b) {
        this.getCheckBoxEnabled().setSelected(b);
        this.colorTableData.setEnabled(b);
    }

    private boolean isInterpolated() {
        return this.getCheckBoxInterpolated().isSelected();
    }

    private boolean isCheckEnabled() {
        return this.getCheckBoxEnabled().isSelected();
    }

    public void setEnabledPanel(boolean enabled) {
        this.getLabelMinim().setEnabled(enabled);
        this.getTextFieldMinim().setEnabled(enabled);
        this.getLabelMaxim().setEnabled(enabled);
        this.getTextFieldMaxim().setEnabled(enabled);
        this.getCheckBoxLimits().setEnabled(enabled);
        this.getCheckBoxInterpolated().setEnabled(enabled);
        this.getButtonStatistics().setEnabled(enabled);
        if (enabled) {
            this.setLimitsEnabled(this.getCheckBoxLimits().isSelected());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getCheckBoxInterpolated()) {
            this.colorTableData.setInterpolated(this.isInterpolated());
            return;
        }
        if (e.getSource() == this.getCheckBoxEnabled()) {
            this.colorTableData.setEnabled(this.isCheckEnabled());
            return;
        }
        if (e.getSource() == this.getCheckBoxLimits()) {
            this.setLimitsEnabled(this.getCheckBoxLimits().isSelected());
            return;
        }
        if (e.getSource() == this.getButtonStatistics() && this.fLayer != null) {
            StatisticsProcess process = new StatisticsProcess();
            process.setActions(this);
            process.addParam("layer", this.fLayer);
            process.addParam("force", new Boolean(false));
            process.start();
            return;
        }
    }

    public void setLimitsEnabled(boolean enabled) {
        this.colorTableData.setLimitsEnabled(enabled);
        this.getCheckBoxLimits().setSelected(enabled);
        this.getLabelMaxim().setEnabled(enabled);
        this.getLabelMinim().setEnabled(enabled);
        this.getTextFieldMinim().setEnabled(enabled);
        this.getTextFieldMaxim().setEnabled(enabled);
        this.getButtonStatistics().setEnabled(enabled);
    }

    private JCheckBox getCheckBoxLimits() {
        if (this.checkBoxLimits == null) {
            this.checkBoxLimits = new JCheckBox();
            this.checkBoxLimits.setText(this.getText(this, "ajustar_limites"));
            this.checkBoxLimits.addActionListener(this);
        }
        return this.checkBoxLimits;
    }

    private JFormattedTextField getTextFieldMinim() {
        if (this.textFieldMinim == null) {
            this.textFieldMinim = new JFormattedTextField(new DefaultFormatterFactory(new NumberFormatter(this.doubleDisplayFormat), new NumberFormatter(this.doubleDisplayFormat), new NumberFormatter(this.doubleEditFormat)));
            this.textFieldMinim.setText("0");
            this.textFieldMinim.setEnabled(false);
            this.textFieldMinim.addPropertyChangeListener("value", this);
        }
        return this.textFieldMinim;
    }

    private JFormattedTextField getTextFieldMaxim() {
        if (this.textFieldMaxim == null) {
            this.textFieldMaxim = new JFormattedTextField(new DefaultFormatterFactory(new NumberFormatter(this.doubleDisplayFormat), new NumberFormatter(this.doubleDisplayFormat), new NumberFormatter(this.doubleEditFormat)));
            this.textFieldMaxim.setText("255");
            this.textFieldMaxim.setEnabled(false);
            this.textFieldMaxim.addPropertyChangeListener("value", this);
        }
        return this.textFieldMaxim;
    }

    private JLabel getLabelMinim() {
        if (this.labelMinim == null) {
            this.labelMinim = new JLabel();
            this.labelMinim.setText(this.getText(this, "minimo") + ":");
            this.labelMinim.setEnabled(false);
        }
        return this.labelMinim;
    }

    private JLabel getLabelMaxim() {
        if (this.labelMaxim == null) {
            this.labelMaxim = new JLabel();
            this.labelMaxim.setText(this.getText(this, "maximo") + ":");
            this.labelMaxim.setEnabled(false);
        }
        return this.labelMaxim;
    }

    private void setLimitMaxim(double limit) {
        this.getTextFieldMaxim().setValue(limit);
        this.colorTableData.setMaxim(limit);
    }

    private void setLimitMinim(double limit) {
        this.getTextFieldMinim().setValue(limit);
        this.colorTableData.setMinim(limit);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.getTextFieldMaxim()) {
            double max = ((Number)this.getTextFieldMaxim().getValue()).doubleValue();
            this.colorTableData.setMaxim(max);
            return;
        }
        if (evt.getSource() == this.getTextFieldMinim()) {
            double min = ((Number)this.getTextFieldMinim().getValue()).doubleValue();
            this.colorTableData.setMinim(min);
            return;
        }
    }

    private void putStatistics() {
        Statistics statistics = this.fLayer.getDataStore().getStatistics();
        if (statistics.isCalculated()) {
            if (this.fLayer.getDataStore().getDataType()[0] == 0 && (double)((byte)statistics.getMinimun()) == statistics.getMinimun() && (double)((byte)statistics.getMaximun()) == statistics.getMaximun()) {
                this.setLimitMaxim(statistics.getMaximunByteUnsigned());
                this.setLimitMinim(statistics.getMinimunByteUnsigned());
            } else {
                this.setLimitMaxim(statistics.getMaximun());
                this.setLimitMinim(statistics.getMinimun());
            }
        }
    }

    public void setLayer(FLyrRaster fLayer) {
        this.fLayer = fLayer;
        this.putStatistics();
    }

    @Override
    public void end(Object param) {
        this.putStatistics();
    }

    @Override
    public void interrupted() {
    }
}

