/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.colortable.ui;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.gvsig.andami.PluginServices;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.datastruct.ColorItem;
import org.gvsig.fmap.dal.coverage.datastruct.ColorTableLibrary;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.ColorTableException;
import org.gvsig.fmap.dal.coverage.exception.FilterManagerException;
import org.gvsig.fmap.dal.coverage.exception.FilterTypeException;
import org.gvsig.fmap.dal.coverage.grid.RasterFilterList;
import org.gvsig.fmap.dal.coverage.grid.RasterFilterListManager;
import org.gvsig.fmap.dal.coverage.store.props.ColorTable;
import org.gvsig.fmap.dal.coverage.util.PropertyEvent;
import org.gvsig.fmap.dal.coverage.util.PropertyListener;
import org.gvsig.gui.beans.imagenavigator.ImageUnavailableException;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.swing.preview.DataSourcePreview;
import org.gvsig.raster.swing.preview.PreviewRenderProcess;
import org.gvsig.raster.tools.app.basic.RasterToolsUtil;
import org.gvsig.raster.tools.app.basic.tool.colortable.data.ColorTableData;
import org.gvsig.raster.tools.app.basic.tool.colortable.ui.ColorTablePanel;
import org.gvsig.raster.tools.app.basic.tool.colortable.ui.library.ColorTableLibraryPanel;
import org.gvsig.raster.tools.app.basic.tool.colortable.ui.tabs.ColorTableUIListener;
import org.gvsig.raster.tools.app.basic.tool.colortable.ui.tabs.IColorTableUI;

public class ColorTableListener
implements PropertyListener,
ColorTableUIListener,
PreviewRenderProcess {
    private ColorTablePanel colorTablePanel = null;
    private FLyrRaster previewLayer = null;
    private ColorTableData colorTableData = null;
    private ArrayList<StatusComponent> statusList = new ArrayList();
    private IColorTableUI lastColorTableUI = null;
    private boolean showPreview = true;

    public ColorTableListener(ColorTablePanel colorTablePanel, ColorTableData colorTableData) {
        this.colorTablePanel = colorTablePanel;
        this.colorTableData = colorTableData;
        this.getColorTableData().addValueChangedListener(this);
    }

    private ColorTablePanel getColorTablePanel() {
        return this.colorTablePanel;
    }

    private ColorTableData getColorTableData() {
        return this.colorTableData;
    }

    public void setLayer(FLyrRaster fLayer) {
        if (fLayer instanceof FLyrRaster) {
            try {
                this.previewLayer = (FLyrRaster)fLayer.cloneLayer();
            }
            catch (Exception e) {
                RasterSwingLibrary.messageBoxError((String)"preview_not_available", (Object)this.colorTablePanel, (Exception)e);
            }
        }
    }

    public void closePreviewLayer() {
        if (this.previewLayer != null) {
            this.previewLayer.setRemoveRasterFlag(true);
            this.previewLayer.removeLayerListener(null);
        }
    }

    private void applyColorTable(FLyrRaster rendering, boolean isPreview) throws FilterTypeException, FilterManagerException {
        RasterFilterList filterList = rendering.getRender().getFilterList();
        RasterFilterListManager cManager = filterList.getManagerByID("ColorTable");
        filterList.remove("colortable");
        this.getColorTablePanel().getLayer().setLastLegend(null);
        if (this.getColorTableData().isEnabled()) {
            filterList.removeAll();
            filterList.addEnvParam("Transparency", (Object)rendering.getRender().getRenderingTransparency());
            Params params = filterList.createEmptyFilterParams();
            ColorTable colorTable = this.getColorTableData().getColorTable();
            params.setParam("colorTable", (Object)colorTable);
            cManager.addFilter(params);
            if (!isPreview) {
                colorTable.compressPalette();
                this.getColorTablePanel().getLayer().setLastLegend(colorTable);
            }
        }
        for (int i = 0; i < filterList.lenght(); ++i) {
            filterList.get(i).setEnv(filterList.getEnv());
        }
        rendering.getRender().setFilterList(filterList);
    }

    public void accept() {
        try {
            ColorTableLibrary tableLib = RasterLocator.getManager().getDataStructFactory().getColorTableLibrary();
            this.applyColorTable(this.getColorTablePanel().getLayer(), false);
            this.getColorTablePanel().getLayer().getMapContext().invalidate();
            tableLib.save_to_1_1(ColorTableLibraryPanel.palettesPath, this.getColorTableData().getColorTable());
        }
        catch (FilterTypeException e) {
            RasterSwingLibrary.messageBoxError((String)PluginServices.getText((Object)this, (String)"error_adding_filters"), (Object)this, (Exception)((Object)e));
        }
        catch (FilterManagerException e) {
            RasterSwingLibrary.messageBoxError((String)PluginServices.getText((Object)this, (String)"error_adding_filters"), (Object)this, (Exception)((Object)e));
        }
    }

    private void saveComponentsStatus(JComponent component) {
        StatusComponent auxStatus = new StatusComponent();
        auxStatus.setEnabled(component.isEnabled());
        auxStatus.setObject(component);
        this.statusList.add(auxStatus);
        for (int i = 0; i < component.getComponentCount(); ++i) {
            if (!(component.getComponent(i) instanceof JComponent)) continue;
            this.saveComponentsStatus((JComponent)component.getComponent(i));
        }
    }

    private void setEnabledRecursive(JComponent component, boolean enabled, int level) {
        if (enabled) {
            boolean auxEnabled = false;
            boolean finded = false;
            for (int i = 0; i < this.statusList.size(); ++i) {
                StatusComponent auxStatus = this.statusList.get(i);
                if (auxStatus.getObject() != component) continue;
                auxEnabled = auxStatus.isEnabled();
                this.statusList.remove(i);
                --i;
                finded = true;
                break;
            }
            if (finded) {
                component.setEnabled(auxEnabled);
            }
        } else {
            if (level == 0) {
                this.saveComponentsStatus(component);
            }
            component.setEnabled(false);
        }
        for (int i = 0; i < component.getComponentCount(); ++i) {
            if (!(component.getComponent(i) instanceof JComponent)) continue;
            this.setEnabledRecursive((JComponent)component.getComponent(i), enabled, level + 1);
        }
    }

    private void setEnabledPanel(boolean enabled) {
        this.colorTablePanel.getGeneralPanel().setEnabledPanel(enabled);
        this.colorTablePanel.getPreviewBasePanel().getTabbedPane().setEnabled(enabled);
        this.setEnabledRecursive(this.getLastColorTableUI().getPanel(), enabled, 0);
        this.setEnabledRecursive((JComponent)this.colorTablePanel.getPreviewBasePanel().getImageNavigator(), enabled, 0);
        this.setEnabledRecursive(this.colorTablePanel.getPanelListView(), enabled, 0);
    }

    public void actionValueChanged(PropertyEvent e) {
        if (e.getName().equals("refreshPreview")) {
            this.colorTablePanel.getPreviewBasePanel().refreshPreview();
            return;
        }
        if (e.getName().equals("interpolated")) {
            this.colorTablePanel.getColorTableLibraryPanel().setInterpolated((Boolean)e.getValue());
            this.getColorTableData().getColorTable().setInterpolated(((Boolean)e.getValue()).booleanValue());
            this.getColorTableData().refreshPreview();
            this.getLastColorTableUI().setColorTable(this.getColorTableData().getColorTable());
            return;
        }
        if (e.getName().equals("limits") || e.getName().equals("maxim") || e.getName().equals("minim")) {
            if (this.getColorTableData().isLimitsEnabled()) {
                double min = this.getColorTableData().getMinim();
                double max = this.getColorTableData().getMaxim();
                this.getLastColorTableUI().getColorTable().createColorTableInRange(min, max, false);
                this.getLastColorTableUI().setColorTable(this.getLastColorTableUI().getColorTable());
                this.getColorTableData().refreshPreview();
            } else {
                try {
                    this.colorTablePanel.reloadPanelsFromLibraryPanel();
                }
                catch (ColorTableException colorTableException) {
                    // empty catch block
                }
            }
            return;
        }
    }

    public void refreshItems(boolean isNewSelection) {
        if (this.getColorTableData().getColorTable() == null) {
            return;
        }
        if (isNewSelection) {
            this.getColorTableData().getColorTable().removeDuplicatedValues();
        }
        this.getLastColorTableUI().setColorTable(this.getColorTableData().getColorTable());
    }

    public void equidistar() {
        ColorItem colorItem;
        int i;
        ColorTable colorTable = this.getColorTableData().getColorTable();
        if (colorTable == null) {
            return;
        }
        colorTable.removeDuplicatedValues();
        List list = colorTable.getColorItems();
        double min2 = Double.POSITIVE_INFINITY;
        double max2 = Double.NEGATIVE_INFINITY;
        for (i = 0; i < list.size(); ++i) {
            colorItem = (ColorItem)list.get(i);
            if (min2 > colorItem.getValue()) {
                min2 = colorItem.getValue();
            }
            if (!(max2 < colorItem.getValue())) continue;
            max2 = colorItem.getValue();
        }
        for (i = 0; i < list.size(); ++i) {
            colorItem = (ColorItem)list.get(i);
            colorItem.setValue(min2 + (max2 - min2) / (double)(list.size() - 1) * (double)i);
        }
        this.refreshItems(true);
        this.getColorTableData().refreshPreview();
    }

    private IColorTableUI getLastColorTableUI() {
        return this.lastColorTableUI;
    }

    public void setLastColorTableUI(IColorTableUI lastColorTableUI) {
        this.lastColorTableUI = lastColorTableUI;
    }

    @Override
    public void actionColorTableUIChanged(IColorTableUI colorTableUI) {
        ColorTable colorTable = this.colorTablePanel.getColorTableLibraryPanel().getColorTableSelected();
        colorTable.createPaletteFromColorItems(colorTableUI.getColorTable().getColorItems(), false);
        this.colorTablePanel.getColorTableLibraryPanel().setColorTableSelected(colorTable);
        this.getColorTableData().setColorTable((ColorTable)colorTableUI.getColorTable().clone());
        this.getColorTableData().refreshPreview();
    }

    public void process(DataSourcePreview rendering) throws ImageUnavailableException {
        if (!this.showPreview) {
            throw new ImageUnavailableException(RasterToolsUtil.getText(this, "panel_preview_not_available"));
        }
        try {
            if (!(rendering.getSource() instanceof FLyrRaster)) {
                return;
            }
            FLyrRaster lyr = (FLyrRaster)rendering.getSource();
            this.applyColorTable(lyr, true);
        }
        catch (FilterTypeException e1) {
            RasterSwingLibrary.messageBoxError((String)PluginServices.getText((Object)this, (String)"error_adding_filters"), (Object)this, (Exception)((Object)e1));
        }
        catch (FilterManagerException e) {
            RasterSwingLibrary.messageBoxError((String)PluginServices.getText((Object)this, (String)"error_adding_filters"), (Object)this, (Exception)((Object)e));
        }
    }

    public boolean isShowPreview() {
        return this.showPreview;
    }

    public void setShowPreview(boolean showPreview) {
        this.showPreview = showPreview;
    }

    public class StatusComponent {
        private JComponent object;
        private boolean enabled;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public JComponent getObject() {
            return this.object;
        }

        public void setObject(JComponent object) {
            this.object = object;
        }
    }
}

