/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.colortable.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.cresques.cts.IProjection;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.RasterManager;
import org.gvsig.fmap.dal.coverage.exception.ColorTableException;
import org.gvsig.fmap.dal.coverage.exception.RmfSerializerException;
import org.gvsig.fmap.dal.coverage.grid.RasterFilter;
import org.gvsig.fmap.dal.coverage.grid.RasterFilterList;
import org.gvsig.fmap.dal.coverage.grid.render.Render;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.store.props.ColorTable;
import org.gvsig.fmap.dal.coverage.store.props.Transparency;
import org.gvsig.gui.beans.buttonspanel.ButtonsPanelEvent;
import org.gvsig.gui.beans.buttonspanel.ButtonsPanelListener;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.swing.RasterSwingLocator;
import org.gvsig.raster.swing.preview.DataSourcePreview;
import org.gvsig.raster.swing.preview.PreviewBasePanelTab;
import org.gvsig.raster.swing.preview.PreviewPanel;
import org.gvsig.raster.swing.preview.PreviewRenderProcess;
import org.gvsig.raster.tools.app.basic.RasterToolsUtil;
import org.gvsig.raster.tools.app.basic.raster.bean.previewbase.RasterDataSourcePreview;
import org.gvsig.raster.tools.app.basic.tool.colortable.data.ColorTableData;
import org.gvsig.raster.tools.app.basic.tool.colortable.ui.ColorTableDialog;
import org.gvsig.raster.tools.app.basic.tool.colortable.ui.ColorTableGlobalPanel;
import org.gvsig.raster.tools.app.basic.tool.colortable.ui.ColorTableListener;
import org.gvsig.raster.tools.app.basic.tool.colortable.ui.library.ColorTableLibraryEvent;
import org.gvsig.raster.tools.app.basic.tool.colortable.ui.library.ColorTableLibraryListener;
import org.gvsig.raster.tools.app.basic.tool.colortable.ui.library.ColorTableLibraryPanel;
import org.gvsig.raster.tools.app.basic.tool.colortable.ui.tabs.IColorTableUI;
import org.gvsig.raster.tools.app.basic.tool.colortable.ui.tabs.TabInterpolated;
import org.gvsig.raster.tools.app.basic.tool.colortable.ui.tabs.TabTable;

public class ColorTablePanel
extends JPanel
implements ChangeListener,
ButtonsPanelListener,
ColorTableLibraryListener {
    private static final long serialVersionUID = 6028780107787443656L;
    private ColorTableListener colorTableListener = null;
    private FLyrRaster fLayer = null;
    private List<RasterFilter> filterStatus = null;
    private ColorTableData colorTableData = null;
    private IColorTableUI tabTable = null;
    private IColorTableUI tabInterpolated = null;
    private ColorTableLibraryPanel colorTableLibraryPanel = null;
    private JPanel jPanelListView = null;
    private ColorTableGlobalPanel panelGeneral = null;
    private ColorTableDialog colorTableDialog = null;
    private PreviewPanel previewBasePanel = null;
    boolean accepted = false;

    public ColorTablePanel(FLyrRaster layer, ColorTableDialog colorTableDialog) throws ColorTableException {
        this.colorTableDialog = colorTableDialog;
        this.fLayer = layer;
        this.initialize();
        this.setLayer(layer);
    }

    public PreviewPanel getPreviewBasePanel() {
        if (this.previewBasePanel == null) {
            ArrayList<PreviewBasePanelTab> list = new ArrayList<PreviewBasePanelTab>();
            list.add((PreviewBasePanelTab)this.getTabTable());
            list.add((PreviewBasePanelTab)this.getTabInterpolated());
            this.getColorTableListener().setLastColorTableUI(this.getTabTable());
            IProjection viewProj = null;
            if (this.fLayer.getMapContext() != null) {
                viewProj = this.fLayer.getMapContext().getProjection();
            }
            RasterDataSourcePreview previewDataSource = new RasterDataSourcePreview(this.fLayer, viewProj);
            this.previewBasePanel = RasterSwingLocator.getSwingManager().createPreviewPanel(8, list, (JPanel)((Object)this.getGeneralPanel()), this.getPanelListView(), (PreviewRenderProcess)this.getColorTableListener(), (DataSourcePreview)previewDataSource);
            this.previewBasePanel.getTabbedPane().addChangeListener(this);
            this.previewBasePanel.getButtonsPanel().addButton(RasterToolsUtil.getText(this, "equidistar"), 15);
            this.previewBasePanel.getButtonsPanel().addButton(RasterToolsUtil.getText(this, "guardar_predeterminado"), 14);
            this.previewBasePanel.getButtonsPanel().addApply();
            this.previewBasePanel.getButtonsPanel().addAccept();
            this.previewBasePanel.getButtonsPanel().addCancel();
            this.previewBasePanel.addButtonPressedListener((ButtonsPanelListener)this);
        }
        return this.previewBasePanel;
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)((JPanel)this.getPreviewBasePanel()), "Center");
    }

    private IColorTableUI getTabTable() {
        if (this.tabTable == null) {
            this.tabTable = new TabTable();
            this.tabTable.addColorTableUIChangedListener(this.getColorTableListener());
        }
        return this.tabTable;
    }

    private IColorTableUI getTabInterpolated() {
        if (this.tabInterpolated == null) {
            this.tabInterpolated = new TabInterpolated();
            this.tabInterpolated.addColorTableUIChangedListener(this.getColorTableListener());
        }
        return this.tabInterpolated;
    }

    public JPanel getPanelListView() {
        if (this.jPanelListView == null) {
            this.jPanelListView = new JPanel();
            this.jPanelListView.setBorder(BorderFactory.createTitledBorder(null, RasterToolsUtil.getText(this, "libreria"), 0, 0, null, null));
            this.jPanelListView.setLayout(new BorderLayout());
            this.jPanelListView.add((Component)((Object)this.getColorTableLibraryPanel()));
        }
        return this.jPanelListView;
    }

    public ColorTableLibraryPanel getColorTableLibraryPanel() {
        if (this.colorTableLibraryPanel == null) {
            this.colorTableLibraryPanel = new ColorTableLibraryPanel(this.getColorTableData());
            this.colorTableLibraryPanel.addColorTableLibraryListener(this);
            this.colorTableLibraryPanel.selectDefault();
        }
        return this.colorTableLibraryPanel;
    }

    private ColorTableListener getColorTableListener() {
        if (this.colorTableListener == null) {
            this.colorTableListener = new ColorTableListener(this, this.getColorTableData());
        }
        return this.colorTableListener;
    }

    public ColorTableGlobalPanel getGeneralPanel() {
        if (this.panelGeneral == null) {
            this.panelGeneral = new ColorTableGlobalPanel(this.getColorTableData());
        }
        return this.panelGeneral;
    }

    private boolean restoreFilters() {
        if (this.getLayer() != null) {
            Render rendering = this.getLayer().getRender();
            if (rendering.getFilterList() == null) {
                return false;
            }
            rendering.getFilterList().setStatus(this.getFilterStatus());
            this.getLayer().getRender().setFilterList(rendering.getFilterList());
        }
        return true;
    }

    private List<RasterFilter> getFilterStatus() {
        return this.filterStatus;
    }

    public void reloadPanelsFromLibraryPanel() throws ColorTableException {
        ColorTable colorTable = this.getColorTableLibraryPanel().getColorTableSelected();
        if (colorTable == null) {
            throw new ColorTableException(ColorTableException.MESSAGE_NOTLOADED);
        }
        this.getColorTableData().setColorTable((ColorTable)colorTable.clone());
        if (this.colorTableData.isLimitsEnabled()) {
            double min = this.getColorTableData().getMinim();
            double max = this.getColorTableData().getMaxim();
            this.getColorTableData().getColorTable().createColorTableInRange(min, max, false);
        }
        this.getColorTableListener().refreshItems(true);
        this.getColorTableData().refreshPreview();
    }

    private void saveColorTable() {
        RasterDataStore dataset = this.getLayer().getDataStore();
        try {
            if (this.getColorTableData().isEnabled()) {
                dataset.saveColorTableToRmf(this.getColorTableData().getColorTable());
            } else {
                dataset.saveColorTableToRmf(null);
            }
        }
        catch (RmfSerializerException e) {
            RasterSwingLibrary.messageBoxError((String)"error_salvando_rmf", (Object)this, (Exception)((Object)e));
        }
    }

    private void restoreSettings() {
        if (this.getLayer() == null) {
            return;
        }
        if (!this.restoreFilters()) {
            return;
        }
        this.getLayer().setLastLegend(null);
        RasterFilterList rasterFilterList = this.getLayer().getRender().getFilterList();
        RasterFilter colorTableFilter = rasterFilterList.getByName("colortable");
        if (colorTableFilter != null) {
            ColorTable colorTable = (ColorTable)colorTableFilter.getParam("colorTable");
            this.getLayer().setLastLegend(colorTable);
        }
        try {
            Transparency transparency = this.getLayer().getRender().getRenderingTransparency();
            transparency.setTransparencyBand(-1);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private ColorTableData getColorTableData() {
        if (this.colorTableData == null) {
            this.colorTableData = new ColorTableData();
        }
        return this.colorTableData;
    }

    private void setLayer(FLyrRaster fLayer) throws ColorTableException {
        try {
            this.fLayer = fLayer;
            RasterManager rManager = RasterLocator.getManager();
            this.getGeneralPanel().setLayer(fLayer);
            this.getColorTableListener().setLayer(fLayer);
            RasterFilterList rasterFilterList = this.getLayer().getRender().getFilterList();
            this.filterStatus = rasterFilterList.getStatusCloned();
            RasterFilter colorTableFilter = rasterFilterList.getByName("colortable");
            if (colorTableFilter != null) {
                ColorTable colorTable = (ColorTable)colorTableFilter.getParam("colorTable");
                if (colorTable.isCompressible() && RasterSwingLibrary.messageBoxYesOrNot((String)"comprimir_paleta", (Object)this)) {
                    colorTable.compressPalette();
                    colorTable.setInterpolated(true);
                }
                ColorTable ct = rManager.getDataStructFactory().getColorTableLibrary().createColorTable();
                ct.setName(RasterToolsUtil.getText(this, "tabla_actual"));
                ct.createPaletteFromColorItems(colorTable.getColorItems(), false);
                ct.setInterpolated(colorTable.isInterpolated());
                this.getGeneralPanel().setCheckBoxInterpolated(colorTable.isInterpolated());
                this.getColorTableLibraryPanel().addColorTable(0, ct);
                this.getGeneralPanel().setLimitsEnabled(false);
                this.getGeneralPanel().setCheckBoxEnabled(true);
            } else {
                this.getColorTableLibraryPanel().selectDefault();
                this.getGeneralPanel().setLimitsEnabled(true);
                this.getGeneralPanel().setCheckBoxEnabled(false);
            }
            this.reloadPanelsFromLibraryPanel();
        }
        catch (Exception e) {
            throw new ColorTableException(ColorTableException.MESSAGE_NOTLOADED);
        }
    }

    public FLyrRaster getLayer() {
        return this.fLayer;
    }

    private void accept() {
        if (!this.getGeneralPanel().getCheckBoxEnabled().isSelected()) {
            boolean ok = RasterSwingLibrary.messageBoxYesOrNot((String)"colortable_not_active", (Object)this);
            if (ok) {
                this.getColorTableListener().accept();
            } else {
                return;
            }
        }
        this.getColorTableListener().accept();
    }

    private void cancel() {
        this.getColorTableListener().closePreviewLayer();
        this.getLayer().getMapContext().invalidate();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        switch (this.getPreviewBasePanel().getTabbedPane().getSelectedIndex()) {
            case 1: {
                this.getColorTableListener().setLastColorTableUI(this.getTabInterpolated());
                break;
            }
            default: {
                this.getColorTableListener().setLastColorTableUI(this.getTabTable());
            }
        }
        this.getColorTableListener().refreshItems(true);
    }

    public void actionButtonPressed(ButtonsPanelEvent e) {
        this.restoreSettings();
        if (e.getButton() == 3 || e.getButton() == 1) {
            this.accept();
        }
        if (e.getButton() == 2) {
            this.cancel();
            this.close();
        }
        if (e.getButton() == 1) {
            this.accepted = true;
            this.close();
        }
        if (e.getButton() == 14 && RasterSwingLibrary.messageBoxYesOrNot((String)"guardar_como_predeterminado", (Object)this)) {
            this.saveColorTable();
            this.accept();
        }
        if (e.getButton() == 15) {
            this.getColorTableListener().equidistar();
        }
    }

    private void close() {
        if (this.colorTableDialog == null) {
            return;
        }
        try {
            PluginServices.getMDIManager().closeWindow((IWindow)this.colorTableDialog);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void windowClosed() {
        if (!this.accepted) {
            this.restoreSettings();
            this.cancel();
        }
    }

    @Override
    public void actionColorTableChanged(ColorTableLibraryEvent e) {
        try {
            this.reloadPanelsFromLibraryPanel();
        }
        catch (ColorTableException colorTableException) {
            // empty catch block
        }
    }
}

