/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.colortable.ui.library;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileFilter;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.Launcher;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.RasterManager;
import org.gvsig.fmap.dal.coverage.datastruct.ColorTableLibrary;
import org.gvsig.fmap.dal.coverage.exception.FilePaletteException;
import org.gvsig.fmap.dal.coverage.exception.RasterLegendIONotFound;
import org.gvsig.fmap.dal.coverage.store.props.ColorTable;
import org.gvsig.gui.beans.listview.IIconPaint;
import org.gvsig.gui.beans.listview.ListViewComponent;
import org.gvsig.gui.beans.listview.ListViewItem;
import org.gvsig.gui.beans.listview.ListViewListener;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.tools.app.basic.tool.colortable.data.ColorTableData;
import org.gvsig.raster.tools.app.basic.tool.colortable.ui.library.AddLibraryWindow;
import org.gvsig.raster.tools.app.basic.tool.colortable.ui.library.ColorTableIconPainter;
import org.gvsig.raster.tools.app.basic.tool.colortable.ui.library.ColorTableLibraryEvent;
import org.gvsig.raster.tools.app.basic.tool.colortable.ui.library.ColorTableLibraryListener;
import org.gvsig.raster.util.BasePanel;
import org.gvsig.raster.util.ExtendedFileFilter;

public class ColorTableLibraryPanel
extends BasePanel
implements ActionListener,
ListViewListener {
    private static final long serialVersionUID = 1L;
    private JPanel panelButtons = null;
    private JButton buttonAdd = null;
    private JButton buttonDel = null;
    private JButton buttonImport = null;
    private JButton buttonExport = null;
    private ListViewComponent listViewComponent = null;
    private boolean hasChanged = false;
    private ArrayList<ColorTableLibraryListener> actionCommandListeners = new ArrayList();
    private ColorTableData colorTableData = null;
    private ColorTable currentColorTable = null;
    public static String palettesPath = Launcher.getAppHomeDir() + File.separator + "colortable";
    private ColorTableLibrary tableLib = null;
    private RasterManager rManager = null;

    public ColorTableLibraryPanel() {
        this.init();
        this.translate();
    }

    public ColorTableLibraryPanel(ColorTableData colorTableData) {
        this.colorTableData = colorTableData;
        this.init();
        this.translate();
    }

    protected void init() {
        this.rManager = RasterLocator.getManager();
        this.tableLib = this.rManager.getDataStructFactory().getColorTableLibrary();
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView((Component)this.getListViewComponent());
        jScrollPane.setAutoscrolls(true);
        panel.add((Component)jScrollPane, "Center");
        this.add(panel, "Center");
        this.add(this.getPanelButtons(), "South");
        this.setPreferredSize(new Dimension(0, 192));
        this.loadDiskLibrary();
    }

    protected void translate() {
    }

    private void loadDiskLibrary() {
        try {
            ArrayList fileList = this.tableLib.getPaletteFileList(palettesPath);
            for (int i = 0; i < fileList.size(); ++i) {
                ArrayList paletteItems = new ArrayList();
                String paletteName = this.tableLib.loadPalette(palettesPath, (String)fileList.get(i), paletteItems);
                if (paletteItems.size() <= 0) continue;
                ColorTable colorTable = this.tableLib.createColorTable();
                colorTable.setName(paletteName);
                colorTable.createPaletteFromColorItems(paletteItems, true);
                colorTable.setInterpolated(true);
                ListViewItem item = new ListViewItem((IIconPaint)new ColorTableIconPainter(colorTable), paletteName);
                item.setTag(fileList.get(i));
                this.getListViewComponent().addItem(item);
            }
            this.getListViewComponent().sort();
            this.getListViewComponent().setSelectedIndex(0);
            this.callColorTableChanged();
        }
        catch (FilePaletteException e) {
            RasterSwingLibrary.messageBoxError((String)e.getMessage(), (Object)this, (Exception)((Object)e));
        }
    }

    private JButton getButtonAdd() {
        if (this.buttonAdd == null) {
            ImageIcon icon = null;
            try {
                icon = IconThemeHelper.getImageIcon((String)"addlayer-icon");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.buttonAdd = new JButton(icon);
            this.buttonAdd.setPreferredSize(new Dimension(22, 19));
            this.buttonAdd.addActionListener(this);
            this.buttonAdd.setToolTipText(this.getText(this, "nueva_libreria_title"));
        }
        return this.buttonAdd;
    }

    private JButton getButtonDel() {
        if (this.buttonDel == null) {
            ImageIcon icon = null;
            try {
                icon = IconThemeHelper.getImageIcon((String)"delall-icon");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.buttonDel = new JButton(icon);
            this.buttonDel.setPreferredSize(new Dimension(22, 19));
            this.buttonDel.addActionListener(this);
            this.buttonDel.setToolTipText(this.getText(this, "borrar_libreria"));
        }
        return this.buttonDel;
    }

    private JButton getButtonImport() {
        if (this.buttonImport == null) {
            ImageIcon icon = null;
            try {
                icon = IconThemeHelper.getImageIcon((String)"import-icon");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.buttonImport = new JButton(icon);
            this.buttonImport.setPreferredSize(new Dimension(22, 19));
            this.buttonImport.addActionListener(this);
            this.buttonImport.setToolTipText(this.getText(this, "import_libreria"));
        }
        return this.buttonImport;
    }

    private JButton getButtonExport() {
        if (this.buttonExport == null) {
            ImageIcon icon = null;
            try {
                icon = IconThemeHelper.getImageIcon((String)"view-export-image");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.buttonExport = new JButton(icon);
            this.buttonExport.setPreferredSize(new Dimension(22, 19));
            this.buttonExport.addActionListener(this);
            this.buttonExport.setToolTipText(this.getText(this, "export_libreria"));
        }
        return this.buttonExport;
    }

    private JPanel getPanelButtons() {
        if (this.panelButtons == null) {
            this.panelButtons = new JPanel();
            this.panelButtons.setPreferredSize(new Dimension(0, 21));
            FlowLayout flowLayout5 = new FlowLayout();
            flowLayout5.setHgap(5);
            flowLayout5.setVgap(0);
            flowLayout5.setAlignment(1);
            this.panelButtons.setLayout(flowLayout5);
            this.panelButtons.add((Component)this.getButtonAdd(), null);
            this.panelButtons.add((Component)this.getButtonExport(), null);
            this.panelButtons.add((Component)this.getButtonImport(), null);
            this.panelButtons.add((Component)this.getButtonDel(), null);
        }
        return this.panelButtons;
    }

    private ListViewComponent getListViewComponent() {
        if (this.listViewComponent == null) {
            this.listViewComponent = new ListViewComponent();
            this.listViewComponent.addListSelectionListener((ListViewListener)this);
            this.listViewComponent.setEditable(true);
        }
        return this.listViewComponent;
    }

    private void callColorTableChanged() {
        for (ColorTableLibraryListener listener : this.actionCommandListeners) {
            listener.actionColorTableChanged(new ColorTableLibraryEvent(this));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int returnVal;
        String desc;
        String s2;
        int i;
        String[] formats;
        JFileChooser chooser;
        if (e.getSource() == this.getButtonAdd()) {
            ColorTable colorTable;
            AddLibraryWindow addLibrary = new AddLibraryWindow();
            if (addLibrary.showConfirm((Component)((Object)this)) == 0 && (colorTable = addLibrary.getColorTable()) != null) {
                ListViewItem item = new ListViewItem((IIconPaint)new ColorTableIconPainter(colorTable), colorTable.getName());
                item.setTag((Object)(item.getName() + ".xml"));
                this.getListViewComponent().addItem(item);
                this.getListViewComponent().setSelectedIndex(this.getListViewComponent().getItems().size() - 1);
                ((ColorTableIconPainter)item.getIcon()).getColorTable().setName(item.getName());
                colorTable.setName(((ColorTableIconPainter)item.getIcon()).getColorTable().getName());
                this.tableLib.save_to_1_1(palettesPath, colorTable);
                this.callColorTableChanged();
            }
            this.getListViewComponent().sort();
        }
        if (e.getSource() == this.getButtonExport()) {
            chooser = new JFileChooser();
            chooser.setAcceptAllFileFilterUsed(false);
            formats = this.tableLib.getFormats();
            ExtendedFileFilter fileFilter = null;
            ExtendedFileFilter firstFileFilter = null;
            for (i = 0; i < formats.length; ++i) {
                fileFilter = new ExtendedFileFilter();
                fileFilter.addExtension(formats[i]);
                try {
                    s2 = RasterLocator.getManager().getFileUtils().getExtensionFromFileName(formats[i]);
                    desc = this.rManager.getRasterLegendIO(s2).getDescription();
                    if (desc != null) {
                        fileFilter.setDescription(desc);
                    }
                }
                catch (RasterLegendIONotFound s2) {
                    // empty catch block
                }
                if (firstFileFilter == null) {
                    firstFileFilter = fileFilter;
                }
                chooser.addChoosableFileFilter((FileFilter)fileFilter);
            }
            if (firstFileFilter != null) {
                chooser.setFileFilter((FileFilter)firstFileFilter);
            }
            if ((returnVal = chooser.showSaveDialog((Component)((Object)this))) == 0) {
                try {
                    if (this.colorTableData != null) {
                        this.tableLib.save_to_1_1(palettesPath, this.colorTableData.getColorTable());
                    }
                    ExtendedFileFilter filter = (ExtendedFileFilter)chooser.getFileFilter();
                    String file = filter.getNormalizedFilename(chooser.getSelectedFile());
                    String s3 = RasterLocator.getManager().getFileUtils().getExtensionFromFileName(file);
                    this.rManager.getRasterLegendIO(s3).write(this.getColorTableSelected(), new File(file));
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                catch (RasterLegendIONotFound e1) {
                    e1.printStackTrace();
                }
            }
        }
        if (e.getSource() == this.getButtonImport()) {
            chooser = new JFileChooser();
            chooser.setAcceptAllFileFilterUsed(false);
            chooser.setMultiSelectionEnabled(true);
            formats = this.tableLib.getFormats();
            ExtendedFileFilter allFilters = new ExtendedFileFilter();
            ExtendedFileFilter fileFilter = null;
            for (i = 0; i < formats.length; ++i) {
                fileFilter = new ExtendedFileFilter();
                fileFilter.addExtension(formats[i]);
                allFilters.addExtension(formats[i]);
                try {
                    s2 = RasterLocator.getManager().getFileUtils().getExtensionFromFileName(formats[i]);
                    desc = this.rManager.getRasterLegendIO(s2).getDescription();
                    if (desc != null) {
                        fileFilter.setDescription(desc);
                    }
                }
                catch (RasterLegendIONotFound s4) {
                    // empty catch block
                }
                chooser.addChoosableFileFilter((FileFilter)fileFilter);
            }
            allFilters.setDescription(this.getText(this, "todos_soportados"));
            chooser.addChoosableFileFilter((FileFilter)allFilters);
            chooser.setFileFilter((FileFilter)allFilters);
            returnVal = chooser.showOpenDialog((Component)((Object)this));
            if (returnVal == 0) {
                try {
                    block12: for (int file = 0; file < chooser.getSelectedFiles().length; ++file) {
                        fileFilter = null;
                        for (int i2 = 0; i2 < formats.length; ++i2) {
                            fileFilter = new ExtendedFileFilter();
                            fileFilter.addExtension(formats[i2]);
                            if (!fileFilter.accept(chooser.getSelectedFiles()[file])) continue;
                            ColorTable colorTable = this.rManager.getRasterLegendIO(formats[i2]).read(chooser.getSelectedFiles()[file]);
                            if (colorTable != null) {
                                colorTable.setInterpolated(true);
                                ListViewItem item = new ListViewItem((IIconPaint)new ColorTableIconPainter(colorTable), colorTable.getName());
                                item.setTag((Object)(item.getName() + ".xml"));
                                this.getListViewComponent().addItem(item);
                                this.getListViewComponent().setSelectedIndex(this.getListViewComponent().getItems().size() - 1);
                                ((ColorTableIconPainter)item.getIcon()).getColorTable().setName(item.getName());
                                colorTable.setName(((ColorTableIconPainter)item.getIcon()).getColorTable().getName());
                                this.tableLib.save_to_1_1(palettesPath, colorTable);
                                this.callColorTableChanged();
                                continue block12;
                            }
                            RasterSwingLibrary.messageBoxError((String)"error_importando_tabla_color_rmf", (Object)this);
                            continue block12;
                        }
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    RasterSwingLibrary.messageBoxError((String)"error_importando_tabla_color_rmf", (Object)this);
                }
                catch (RasterLegendIONotFound e1) {
                    e1.printStackTrace();
                }
            }
        }
        if (e.getSource() == this.getButtonDel()) {
            if (this.getListViewComponent().getSelectedIndices().length > 0 && RasterSwingLibrary.messageBoxYesOrNot((String)"desea_borrar_librerias", (Object)this)) {
                File oldFile = new File(palettesPath + File.separator + this.getListViewComponent().getSelectedValue().getTag());
                oldFile.delete();
                int pos = this.getListViewComponent().getSelectedIndices()[0];
                this.getListViewComponent().removeSelecteds();
                if (this.getListViewComponent().getItems().size() == 0) {
                    this.loadDiskLibrary();
                } else {
                    this.getListViewComponent().setSelectedIndex(pos - 1);
                    this.callColorTableChanged();
                }
            }
            return;
        }
    }

    public void actionItemNameChanged(EventObject e, String oldName, ListViewItem item) {
        File oldFile = new File(palettesPath + File.separator + oldName + ".xml");
        oldFile.delete();
        this.getColorTableSelected().setName(item.getName());
        item.setTag((Object)(item.getName() + ".xml"));
        this.tableLib.save_to_1_1(palettesPath, this.getColorTableSelected());
        this.callColorTableChanged();
    }

    private void testLibraryChanged() {
        if (this.hasChanged) {
            if (RasterSwingLibrary.messageBoxYesOrNot((String)"desea_guardar_cambios", (Object)this)) {
                this.tableLib.save_to_1_1(palettesPath, this.getColorTableSelected());
                this.getListViewComponent().repaint();
            }
            this.hasChanged = false;
        }
    }

    public void selectDefault() {
        int selected = 0;
        for (int i = 0; i < this.getListViewComponent().getItems().size(); ++i) {
            if (!((ListViewItem)this.getListViewComponent().getItems().get(i)).getName().equals("Default")) continue;
            selected = i;
            break;
        }
        this.getListViewComponent().setSelectedIndex(selected);
        this.callColorTableChanged();
    }

    public void addColorTable(int pos, ColorTable colorTable) {
        ListViewItem item = new ListViewItem((IIconPaint)new ColorTableIconPainter(colorTable), this.getText(this, "tabla_actual"));
        this.getListViewComponent().addItem(pos, item);
        this.getListViewComponent().setSelectedIndex(pos);
        this.callColorTableChanged();
    }

    public void actionValueChanged(EventObject e) {
        this.currentColorTable = ((ColorTableIconPainter)this.getListViewComponent().getSelectedValue().getIcon()).getColorTable();
        this.testLibraryChanged();
        this.callColorTableChanged();
    }

    public void setInterpolated(boolean enabled) {
        for (int i = 0; i < this.getListViewComponent().getItems().size(); ++i) {
            ((ColorTableIconPainter)((ListViewItem)this.getListViewComponent().getItems().get(i)).getIcon()).setInterpolated(enabled);
        }
        this.getListViewComponent().repaint();
    }

    public void addColorTableLibraryListener(ColorTableLibraryListener listener) {
        if (!this.actionCommandListeners.contains(listener)) {
            this.actionCommandListeners.add(listener);
        }
    }

    public void removeColorTableLibraryListener(ColorTableLibraryListener listener) {
        this.actionCommandListeners.remove(listener);
    }

    public ColorTable getColorTableSelected() {
        if (this.getListViewComponent().getSelectedValue() != null) {
            this.currentColorTable = ((ColorTableIconPainter)this.getListViewComponent().getSelectedValue().getIcon()).getColorTable();
        }
        return this.currentColorTable;
    }

    public void setColorTableSelected(ColorTable colorTable) {
        this.hasChanged = true;
        ((ColorTableIconPainter)this.getListViewComponent().getSelectedValue().getIcon()).getColorTable().createPaletteFromColorItems(colorTable.getColorItems(), false);
        this.getListViewComponent().repaint();
    }
}

