/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.colortable.ui.tabs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.datastruct.ColorItem;
import org.gvsig.fmap.dal.coverage.datastruct.ColorTableLibrary;
import org.gvsig.fmap.dal.coverage.store.props.ColorTable;
import org.gvsig.gui.beans.table.TableContainer;
import org.gvsig.gui.beans.table.exceptions.NotInitializeException;
import org.gvsig.gui.beans.table.models.TableColorModel;
import org.gvsig.raster.swing.preview.PreviewBasePanelTab;
import org.gvsig.raster.tools.app.basic.RasterToolsUtil;
import org.gvsig.raster.tools.app.basic.tool.colortable.ui.tabs.ColorTableUIListener;
import org.gvsig.raster.tools.app.basic.tool.colortable.ui.tabs.IColorTableUI;
import org.gvsig.raster.util.BasePanel;

public class TabTable
extends BasePanel
implements IColorTableUI,
TableModelListener,
PreviewBasePanelTab {
    private static final long serialVersionUID = -6971866166164473789L;
    private ArrayList<ColorTableUIListener> actionCommandListeners = new ArrayList();
    private boolean listenerEnabled = false;
    private ColorTable colorTable = null;
    private TableContainer tableContainer = null;

    public TabTable() {
        ColorTableLibrary colorTableLibrary = RasterLocator.getManager().getDataStructFactory().getColorTableLibrary();
        this.colorTable = colorTableLibrary.createColorTable();
        this.init();
        this.translate();
        this.getTableContainer().getTable().getJTable().getModel().addTableModelListener(this);
    }

    protected void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getTableContainer(), "Center");
    }

    protected void translate() {
    }

    private TableContainer getTableContainer() {
        if (this.tableContainer == null) {
            String[] columnNames = new String[]{this.getText(this, "color"), this.getText(this, "clase"), "RGB", this.getText(this, "valor"), this.getText(this, "hasta"), this.getText(this, "alpha")};
            int[] columnWidths = new int[]{55, 68, 110, 64, 71, 43};
            this.tableContainer = new TableContainer(columnNames, columnWidths);
            this.tableContainer.setModel("TableColorModel");
            this.tableContainer.initialize();
        }
        return this.tableContainer;
    }

    private void clearTable() {
        try {
            this.getTableContainer().removeAllRows();
        }
        catch (NotInitializeException e) {
            e.printStackTrace();
        }
    }

    private String getColorString(Color c) {
        return c.getRed() + ", " + c.getGreen() + ", " + c.getBlue();
    }

    private void addRowToTable(Color color, String name, Double fromRange, Double toRange, String alpha) {
        try {
            this.getTableContainer().addRow(new Object[]{color, name, this.getColorString(color), fromRange, toRange, alpha});
        }
        catch (NotInitializeException notInitializeException) {
            // empty catch block
        }
    }

    private ArrayList<ColorItem> getPalette() {
        ArrayList<ColorItem> arrayList = new ArrayList<ColorItem>();
        JTable jTable = this.getTableContainer().getTable().getJTable();
        TableColorModel model = (TableColorModel)jTable.getModel();
        ColorTableLibrary colorTableLibrary = RasterLocator.getManager().getDataStructFactory().getColorTableLibrary();
        for (int iRow = 0; iRow < jTable.getRowCount(); ++iRow) {
            Color rgb = (Color)model.getValueAt(iRow, 0);
            ColorItem colorItem = colorTableLibrary.createColorItem();
            colorItem.setColor(new Color(rgb.getRed(), rgb.getGreen(), rgb.getBlue(), Integer.valueOf((String)model.getValueAt(iRow, 5))));
            if (model.getValueAt(iRow, 3) != null) {
                colorItem.setValue(((Double)model.getValueAt(iRow, 3)).doubleValue());
            }
            colorItem.setNameClass((String)model.getValueAt(iRow, 1));
            arrayList.add(colorItem);
        }
        return arrayList;
    }

    private void reloadItems() {
        this.listenerEnabled = false;
        List colorItems = this.colorTable.getColorItems();
        this.clearTable();
        for (int i = 0; i < colorItems.size(); ++i) {
            ColorItem c1 = (ColorItem)colorItems.get(i);
            Double toRange = null;
            if (i + 1 < colorItems.size()) {
                toRange = new Double(((ColorItem)colorItems.get(i + 1)).getValue());
            }
            this.addRowToTable(c1.getColor(), c1.getNameClass(), new Double(c1.getValue()), toRange, c1.getColor().getAlpha() + "");
        }
        this.listenerEnabled = true;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (!this.listenerEnabled) {
            return;
        }
        this.colorTable.createPaletteFromColorItems(this.getPalette(), false);
        this.callColorTableUIChangedListener();
    }

    @Override
    public ColorTable getColorTable() {
        return this.colorTable;
    }

    @Override
    public void setColorTable(ColorTable colorTable) {
        this.colorTable = colorTable;
        this.reloadItems();
    }

    @Override
    public void addColorTableUIChangedListener(ColorTableUIListener listener) {
        if (!this.actionCommandListeners.contains(listener)) {
            this.actionCommandListeners.add(listener);
        }
    }

    @Override
    public void removeColorTableUIChangedListener(ColorTableUIListener listener) {
        this.actionCommandListeners.remove(listener);
    }

    private void callColorTableUIChangedListener() {
        for (ColorTableUIListener listener : this.actionCommandListeners) {
            listener.actionColorTableUIChanged(this);
        }
    }

    public String getTitle() {
        return RasterToolsUtil.getText(this, "tabla");
    }

    @Override
    public JPanel getPanel() {
        return this;
    }
}

