/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.properties.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URI;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import org.apache.commons.io.FilenameUtils;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.RasterManager;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.exception.BandAccessException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.store.props.Metadata;
import org.gvsig.gui.beans.panelGroup.panels.AbstractPanel;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.utils.swing.JComboBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfoPanel
extends AbstractPanel {
    private static final long serialVersionUID = -3764465947289974528L;
    private static final Logger logger = LoggerFactory.getLogger(InfoPanel.class);
    private final String bgColor0 = "\"#FEEDD6\"";
    private final String bgColor1 = "\"#EAEAEA\"";
    private final String bgColor3 = "\"#FBFFE1\"";
    private final String bgColor4 = "\"#D6D6D6\"";
    private final String bgColorBody = "\"#FFFFFF\"";
    private JScrollPane jScrollPane = null;
    public JEditorPane jEditorPane = null;
    private JComboBox jComboBox = null;
    private int selectedDataSet = 0;
    private boolean jComboBoxEvent = false;
    public Object[] columnNames = new Object[]{"Propiedad", "Valor"};
    private FLyrRaster lyr = null;
    private boolean rowColor = true;
    private RasterManager rManager = RasterLocator.getManager();

    public InfoPanel() {
        this.setLabel(Messages.getText((String)"info"));
        this.initialize();
    }

    protected void initialize() {
        this.setLayout(new BorderLayout(5, 5));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add(this.getJScrollPane(), "Center");
        this.add((Component)this.getJComboBox(), "South");
        this.getJEditorPane().repaint();
        this.getJComboBox().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                InfoPanel.this.refresh();
            }
        });
        this.setPreferredSize(new Dimension(100, 80));
        this.setPriority(100);
    }

    public void initializeUI() {
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJEditorPane());
        }
        return this.jScrollPane;
    }

    private JComboBox getJComboBox() {
        if (this.jComboBox == null) {
            this.jComboBox = new JComboBox();
        }
        return this.jComboBox;
    }

    private JEditorPane getJEditorPane() {
        if (this.jEditorPane == null) {
            this.jEditorPane = new JEditorPane();
            this.jEditorPane.setEditable(false);
            this.jEditorPane.setContentType("text/html");
        }
        return this.jEditorPane;
    }

    public void resetTable() {
        this.jEditorPane = null;
    }

    private String getColor() {
        String color = this.rowColor ? "\"#FEEDD6\"" : "\"#EAEAEA\"";
        this.rowColor = !this.rowColor;
        return color;
    }

    private String setHTMLBasicProperty(String prop, String value) {
        String content = "<tr valign=\"top\">";
        if (prop != null) {
            content = content + "<td bgcolor=\"#D6D6D6\"align=\"right\" width=\"140\"><font face=\"Arial\" size=\"3\">" + prop + ":&nbsp;</font></td>";
        }
        content = content + "<td bgcolor=" + this.getColor() + "align=\"left\"><font face=\"Arial\" size=\"3\">" + value + "</font></td>";
        content = content + "</tr>";
        return content;
    }

    private String setHTMLTitleTable(String title, int colspan) {
        return "<tr valign=\"middle\" ><td bgcolor=\"#FBFFE1\" align=\"center\" colspan=\"" + colspan + "\"><font face=\"Arial\" size=\"3\"><b> " + title + "</b></font></td>" + "</tr>";
    }

    private String setHTMLTable(String content) {
        return "<table cellpadding=\"0\" cellspacing=\"0\" align=\"center\" width=\"100%\">" + content + "</table>";
    }

    private String setHTMLBody(String content) {
        String html = "<html>";
        html = html + "<body bgcolor=\"#FFFFFF\" topmargin=\"0\" marginheight=\"0\">";
        html = html + content;
        html = html + "</body>";
        html = html + "</html>";
        return html;
    }

    public String tablaInfo() {
        this.rowColor = true;
        String cabInfo = Messages.getText((String)"general_info");
        String propiedades = "";
        long fileSize = 0L;
        String cabecera = this.setHTMLTitleTable(cabInfo, 2);
        long[] filesSize = this.lyr.getDataStore().getFileSizeByProvider();
        fileSize = filesSize[this.selectedDataSet];
        URI[] names = this.lyr.getDataStore().getURIByProvider();
        URI uri = names[this.selectedDataSet];
        propiedades = "FILE".equalsIgnoreCase(uri.getScheme()) ? propiedades + this.setHTMLBasicProperty(Messages.getText((String)"archivo"), names[this.selectedDataSet].getPath()) : propiedades + this.setHTMLBasicProperty(Messages.getText((String)"uri"), names[this.selectedDataSet].toString());
        propiedades = propiedades + this.setHTMLBasicProperty(Messages.getText((String)"size"), this.rManager.getFileUtils().formatFileSize(fileSize) + " ");
        propiedades = propiedades + this.setHTMLBasicProperty(Messages.getText((String)"ancho_alto"), this.lyr.getDataStore().getWidth() + " X " + this.lyr.getDataStore().getHeight());
        propiedades = propiedades + this.setHTMLBasicProperty(Messages.getText((String)"formato"), this.lyr.getFileFormat());
        propiedades = propiedades + this.setHTMLBasicProperty(Messages.getText((String)"georref"), this.lyr.isGeoreferenced() ? Messages.getText((String)"si") : Messages.getText((String)"no"));
        propiedades = propiedades + this.setHTMLBasicProperty(Messages.getText((String)"nbandas"), new Integer(this.lyr.getDataStore().getBandCount()).toString());
        propiedades = propiedades + this.setHTMLBasicProperty(Messages.getText((String)"nbandas_file"), new Integer(this.lyr.getBandCountFromDataset()[this.selectedDataSet]).toString());
        propiedades = propiedades + this.setHTMLBasicProperty(Messages.getText((String)"tipo_dato"), this.rManager.getRasterUtils().typesToString(this.lyr.getDataStore().getDataType()[0]));
        propiedades = propiedades + this.setHTMLBasicProperty(Messages.getText((String)"tipo_proveedor"), this.lyr.getDataStore().getProviderName());
        return this.setHTMLTable(cabecera + propiedades);
    }

    public String tablaCoord() {
        this.rowColor = true;
        String cabCoord = Messages.getText((String)"coor_geograficas");
        String propiedades = "";
        String cabecera = this.setHTMLTitleTable(cabCoord, 2);
        double pixelSizeX = this.lyr.getDataStore().getAffineTransform().getScaleX();
        double pixelSizeY = this.lyr.getDataStore().getAffineTransform().getScaleY();
        Extent ext = this.lyr.getFullRasterExtent();
        propiedades = propiedades + this.setHTMLBasicProperty(Messages.getText((String)"ul"), ext.getULX() + ", " + ext.getULY());
        propiedades = propiedades + this.setHTMLBasicProperty(Messages.getText((String)"lr"), ext.getLRX() + ", " + ext.getLRY());
        propiedades = propiedades + this.setHTMLBasicProperty(Messages.getText((String)"ur"), ext.getURX() + ", " + ext.getURY());
        propiedades = propiedades + this.setHTMLBasicProperty(Messages.getText((String)"ll"), ext.getLLX() + ", " + ext.getLLY());
        double rotX = this.lyr.getDataStore().getAffineTransform().getShearX();
        double rotY = this.lyr.getDataStore().getAffineTransform().getShearY();
        propiedades = propiedades + this.setHTMLBasicProperty(Messages.getText((String)"tamPixX"), String.valueOf(pixelSizeX));
        propiedades = propiedades + this.setHTMLBasicProperty(Messages.getText((String)"tamPixY"), String.valueOf(pixelSizeY));
        propiedades = propiedades + this.setHTMLBasicProperty(Messages.getText((String)"rotX"), String.valueOf(rotX));
        propiedades = propiedades + this.setHTMLBasicProperty(Messages.getText((String)"rotY"), String.valueOf(rotY));
        return "<br>" + this.setHTMLTable(cabecera + propiedades);
    }

    public String tablaOrigen() {
        this.rowColor = true;
        String propiedades = "";
        String bandType = "";
        String cabOrig = Messages.getText((String)"origin");
        String cabecera = this.setHTMLTitleTable(cabOrig, 2);
        for (int j = 0; j < this.lyr.getBandCountFromDataset()[this.selectedDataSet]; ++j) {
            bandType = this.rManager.getRasterUtils().typesToString(this.lyr.getDataStore().getDataType()[j]);
            String data = "";
            data = data + "Type=" + bandType;
            data = data + ", ";
            data = data + "ColorInterp=" + this.lyr.getColorInterpretation(j, this.selectedDataSet);
            if (this.lyr.getNoDataValue().isDefined()) {
                data = data + ", ";
                switch (this.lyr.getDataStore().getDataType()[0]) {
                    case 0: {
                        data = data + "NoData=" + this.lyr.getNoDataValue().getValue().byteValue();
                        break;
                    }
                    case 2: {
                        data = data + "NoData=" + this.lyr.getNoDataValue().getValue().shortValue();
                        break;
                    }
                    case 3: {
                        data = data + "NoData=" + this.lyr.getNoDataValue().getValue().intValue();
                        break;
                    }
                    case 4: {
                        data = data + "NoData=" + this.lyr.getNoDataValue().getValue().floatValue();
                        break;
                    }
                    case 5: {
                        data = data + "NoData=" + this.lyr.getNoDataValue().getValue().doubleValue();
                    }
                }
            }
            propiedades = propiedades + this.setHTMLBasicProperty("Band " + (j + 1), data);
            data = "";
            try {
                int count = this.lyr.getDataStore().getOverviewCount(j);
                if (count <= 0) continue;
                for (int i = 0; i < count; ++i) {
                    int w = this.lyr.getDataStore().getOverviewWidth(j, i);
                    int h = this.lyr.getDataStore().getOverviewHeight(j, i);
                    if (w == 0 || h == 0) continue;
                    data = data + i + ": " + "(" + w + "X" + h + ")<BR>";
                }
                propiedades = propiedades + this.setHTMLBasicProperty("Overviews", data);
                continue;
            }
            catch (BandAccessException e) {
                logger.info("Error reading overviews", (Throwable)e);
                continue;
            }
            catch (RasterDriverException e) {
                logger.info("Error reading overviews", (Throwable)e);
            }
        }
        return "<br>" + this.setHTMLTable(cabecera + propiedades);
    }

    public String tablaProjection() {
        this.rowColor = true;
        String propiedades = "";
        String projection = null;
        boolean datos = false;
        String cabProjection = Messages.getText((String)"projection");
        String cabecera = this.setHTMLTitleTable(cabProjection, 1);
        String wktProj = null;
        try {
            wktProj = this.lyr.getWktProjection();
        }
        catch (RasterDriverException rasterDriverException) {
            // empty catch block
        }
        if (wktProj != null && (projection = this.rManager.getRasterUtils().parserGdalProj(wktProj)) != null) {
            datos = true;
            propiedades = propiedades + this.setHTMLBasicProperty(null, projection);
        }
        if (!datos) {
            return "";
        }
        return "<br>" + this.setHTMLTable(cabecera + propiedades);
    }

    public String tablaMetadatos() {
        this.rowColor = true;
        String propiedades = "";
        String[] metadatos = null;
        Metadata meta = null;
        boolean datos = false;
        String cabMeta = Messages.getText((String)"metadata");
        String cabecera = this.setHTMLTitleTable(cabMeta, 2);
        Metadata[] metaList = this.lyr.getDataStore().getMetadataByProvider();
        meta = metaList[this.selectedDataSet];
        if (meta != null && (metadatos = meta.getMetadataString()) != null) {
            for (int j = 0; j < metadatos.length; ++j) {
                datos = true;
                int index = metadatos[j].indexOf("=");
                propiedades = propiedades + this.setHTMLBasicProperty(metadatos[j].substring(0, index), metadatos[j].substring(index + 1));
            }
        }
        if (!datos) {
            return "";
        }
        return "<br>" + this.setHTMLTable(cabecera + propiedades);
    }

    public void refresh() {
        boolean refresh = false;
        if (!this.jComboBoxEvent) {
            this.jComboBoxEvent = true;
            this.selectedDataSet = this.getJComboBox().getSelectedIndex();
            if (this.selectedDataSet < 0) {
                this.selectedDataSet = 0;
            }
            String nameFile = "";
            URI[] uris = this.lyr.getDataStore().getURIByProvider();
            this.getJComboBox().removeAllItems();
            for (int i = 0; i < uris.length; ++i) {
                URI uri = uris[i];
                if ("FILE".equalsIgnoreCase(uri.getScheme())) {
                    nameFile = uris[i].getPath();
                    nameFile = FilenameUtils.getName((String)nameFile);
                } else {
                    nameFile = uris[i].toString();
                }
                this.getJComboBox().addItem((Object)nameFile);
            }
            try {
                this.getJComboBox().setSelectedIndex(this.selectedDataSet);
            }
            catch (IllegalArgumentException iae) {
                this.selectedDataSet = 0;
            }
            this.jComboBoxEvent = false;
            refresh = true;
        }
        String html = "";
        if (refresh && this.lyr.getDataStore().getProviderCount() >= 1) {
            html = this.setHTMLBody(this.tablaInfo() + this.tablaCoord() + this.tablaOrigen() + this.tablaProjection() + this.tablaMetadatos());
        }
        this.getJEditorPane().setContentType("text/html");
        this.getJEditorPane().setText(html);
        this.getJEditorPane().setCaretPosition(0);
    }

    public void setReference(Object ref) {
        super.setReference(ref);
        if (!(ref instanceof FLyrRaster)) {
            return;
        }
        this.lyr = (FLyrRaster)ref;
        this.refresh();
    }

    public void selected() {
        this.refresh();
    }

    public void accept() {
    }

    public void apply() {
    }

    public void cancel() {
    }
}

