/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.raw.tool;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.gvsig.raster.tools.app.basic.tool.raw.tool.VRTFormatUtils;

public class VRTFileCreator {
    private Writer writer = null;
    private File m_File = null;
    private int width = 0;
    private int height = 0;
    private int bands = 0;
    private int headerSize = 0;
    private int fileSize = 0;
    private String rawFile = null;
    private String dataType = null;
    private int dataSize = 0;
    private String byteOrder = null;
    private String interleaving = null;
    private String outputHeaderFormat = null;

    public VRTFileCreator(File m_File) {
        this.m_File = m_File;
    }

    public VRTFileCreator(String file) {
        this.m_File = new File(file);
    }

    public void writeFile() throws IOException {
        if (!this.m_File.exists()) {
            this.m_File.createNewFile();
        }
        this.writer = new FileWriter(this.m_File);
        this.createVRTFile();
        this.writer.close();
    }

    private void createVRTFile() throws IOException {
        this.writer.write(this.getXMLVRTDatasetHeaderTag());
        for (int i = 0; i < this.getBands(); ++i) {
            this.createOneBand(i + 1);
        }
        this.writer.write(this.getXMLVRTDatasetEndTag());
    }

    private void createOneBand(int band) throws IOException {
        this.writer.write(this.getXMLVRTRasterBandHeaderTag(band));
        this.writer.write(this.getXMLSourceFilenameTag());
        this.writer.write(this.getXMLByteOrderTag());
        this.writer.write(this.getXMLImageOffsetTag(band));
        this.writer.write(this.getXMLPixelOffsetTag());
        this.writer.write(this.getXMLLineOffsetTag());
        this.writer.write(this.getXMLVRTRasterBandEndTag());
    }

    private String getXMLVRTDatasetHeaderTag() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<VRTDataset rasterXSize=\"" + this.getImageWidth() + "\" ");
        buffer.append("rasterYSize=\"" + this.getImageHeight() + "\">\n");
        return buffer.toString();
    }

    private String getXMLVRTDatasetEndTag() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("</VRTDataset>\n");
        return buffer.toString();
    }

    private String getXMLVRTRasterBandHeaderTag(int band) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\t<VRTRasterBand dataType=\"" + this.getDataType() + "\" ");
        buffer.append("band=\"" + band + "\" ");
        buffer.append("subClass=\"VRTRawRasterBand\">\n");
        return buffer.toString();
    }

    private String getXMLVRTRasterBandEndTag() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\t</VRTRasterBand>\n");
        return buffer.toString();
    }

    private String getXMLSourceFilenameTag() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\t\t<SourceFilename relativetoVRT=\"1\">");
        buffer.append(this.getRawFile());
        buffer.append("</SourceFilename>\n");
        return buffer.toString();
    }

    private String getXMLByteOrderTag() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\t\t<ByteOrder>");
        buffer.append(this.getByteOrder());
        buffer.append("</ByteOrder>\n");
        return buffer.toString();
    }

    private String getXMLImageOffsetTag(int band) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\t\t<ImageOffset>");
        buffer.append(VRTFormatUtils.getImageOffset(this, band));
        buffer.append("</ImageOffset>\n");
        return buffer.toString();
    }

    private String getXMLPixelOffsetTag() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\t\t<PixelOffset>");
        buffer.append(VRTFormatUtils.getPixelOffset(this));
        buffer.append("</PixelOffset>\n");
        return buffer.toString();
    }

    private String getXMLLineOffsetTag() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\t\t<LineOffset>");
        buffer.append(VRTFormatUtils.getLineOffset(this));
        buffer.append("</LineOffset>\n");
        return buffer.toString();
    }

    public int getBands() {
        return this.bands;
    }

    public void setBands(int bands) {
        this.bands = bands;
    }

    public String getByteOrder() {
        return this.byteOrder;
    }

    public void setByteOrder(String byteOrder) {
        this.byteOrder = byteOrder;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public int getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(int fileSize) {
        this.fileSize = fileSize;
    }

    public int getHeaderSize() {
        return this.headerSize;
    }

    public void setHeaderSize(int headerSize) {
        this.headerSize = headerSize;
    }

    public int getImageHeight() {
        return this.height;
    }

    public void setImageHeight(int height) {
        this.height = height;
    }

    public String getInterleaving() {
        return this.interleaving;
    }

    public void setInterleaving(String interleaving) {
        this.interleaving = interleaving;
    }

    public String getOutputHeaderFormat() {
        return this.outputHeaderFormat;
    }

    public void setOutputHeaderFormat(String outputHeaderFormat) {
        this.outputHeaderFormat = outputHeaderFormat;
    }

    public int getImageWidth() {
        return this.width;
    }

    public void setImageWidth(int width) {
        this.width = width;
    }

    public String getRawFile() {
        return this.rawFile;
    }

    public void setRawFile(String rawFile) {
        this.rawFile = rawFile;
    }

    public File getM_File() {
        return this.m_File;
    }

    public int getDataSize() {
        return this.dataSize;
    }

    public void setDataSize(int dataSize) {
        this.dataSize = dataSize;
    }
}

