/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.roi.ui.listener;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.andami.ui.mdiManager.IWindowListener;
import org.gvsig.fmap.dal.coverage.exception.RmfSerializerException;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.gui.beans.buttonspanel.ButtonsPanelEvent;
import org.gvsig.gui.beans.buttonspanel.ButtonsPanelListener;
import org.gvsig.gui.beans.table.exceptions.NotInitializeException;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.roi.ROI;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.tools.app.basic.tool.roi.ROIDataModel;
import org.gvsig.raster.tools.app.basic.tool.roi.ui.ROIWindow;

public class ROIPanelListener
implements ButtonsPanelListener,
IWindowListener {
    private ROIWindow window = null;
    private ROIDataModel dataModel = null;

    public ROIPanelListener(ROIWindow window, ROIDataModel dataModel) {
        this.window = window;
        this.dataModel = dataModel;
    }

    public void actionButtonPressed(ButtonsPanelEvent e) {
        if (e.getButton() == 3 || e.getButton() == 1) {
            List<ROI> rois = this.dataModel.getROIs();
            ((FLyrRaster)this.dataModel.getFLayer()).setRois(rois);
            try {
                if (this.dataModel.getROIFile() != null) {
                    ArrayList<File> fileList = new ArrayList<File>();
                    fileList.add(this.dataModel.getROIFile());
                    ((FLyrRaster)this.dataModel.getFLayer()).setROIsFiles(fileList);
                }
            }
            catch (RmfSerializerException e1) {
                RasterSwingLibrary.messageBoxError((String)"error_saving_rois_rmf", (Object)this, (Exception)((Object)e1));
            }
        }
        if (e.getButton() == 2) {
            this.window.close();
        }
        if (e.getButton() == 1) {
            this.window.close();
        }
    }

    public void windowClosed() {
        FeatureStore graphicStore = this.dataModel.getGraphicLayer().getFeatureStore();
        if (graphicStore.isEditing()) {
            try {
                graphicStore.finishEditing();
            }
            catch (DataException e) {
                e.printStackTrace();
            }
        }
        this.dataModel.clearRoiGraphics();
        this.dataModel.getMapControl().rePaintDirtyLayers();
        this.dataModel.setPreviousTool();
    }

    public void windowActivated() {
        try {
            if (this.dataModel.getTable().getSelectedRows().length == 1) {
                this.dataModel.getROIPanel().setToolsEnabled(true);
                this.dataModel.selectDrawRoiTool();
            }
        }
        catch (NotInitializeException e) {
            RasterSwingLibrary.messageBoxError((String)"error_tabla_rois", (Object)this, (Exception)((Object)e));
        }
    }
}

