/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.saveas;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.documents.view.gui.AbstractViewPanel;
import org.gvsig.app.project.documents.view.toc.AbstractTocContextMenuAction;
import org.gvsig.app.project.documents.view.toc.ITocItem;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.RasterManager;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.NotSupportedExtensionException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.util.ProviderServices;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.gui.beans.propertiespanel.PropertiesComponent;
import org.gvsig.gui.beans.swing.JFileChooser;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.fmap.layers.ILayerState;
import org.gvsig.raster.fmap.layers.IRasterLayerActions;
import org.gvsig.raster.mainplugin.toolbar.IGenericToolBarMenuItem;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.tools.app.basic.RasterToolsUtil;
import org.gvsig.raster.tools.app.basic.raster.process.ClippingProcess;
import org.gvsig.raster.tools.app.basic.tool.saveas.SaveAsActions;
import org.gvsig.raster.util.ExtendedFileFilter;

public class SaveAsTocMenuEntry
extends AbstractTocContextMenuAction
implements PropertyChangeListener,
IGenericToolBarMenuItem {
    private static SaveAsTocMenuEntry singleton = null;
    private JFileChooser chooser = null;
    private PropertiesComponent panelProperty = null;

    private SaveAsTocMenuEntry() {
    }

    public static SaveAsTocMenuEntry getSingleton() {
        if (singleton == null) {
            singleton = new SaveAsTocMenuEntry();
        }
        return singleton;
    }

    public String getGroup() {
        return "RasterExport";
    }

    public int getGroupOrder() {
        return 50;
    }

    public int getOrder() {
        return 1;
    }

    public String getText() {
        return Messages.getText((String)"saveas");
    }

    public boolean isEnabled(ITocItem item, FLayer[] selectedItems) {
        if (selectedItems == null || selectedItems.length != 1) {
            return false;
        }
        if (!(selectedItems[0] instanceof ILayerState)) {
            return false;
        }
        return ((ILayerState)selectedItems[0]).isOpen();
    }

    public boolean isVisible(ITocItem item, FLayer[] selectedItems) {
        if (selectedItems == null || selectedItems.length != 1) {
            return false;
        }
        if (!(selectedItems[0] instanceof IRasterLayerActions)) {
            return false;
        }
        return ((IRasterLayerActions)selectedItems[0]).isActionEnabled(4);
    }

    public void execute(ITocItem item, FLayer[] selectedItems) {
        FLayer lyr = null;
        IWindow w = PluginServices.getMDIManager().getActiveWindow();
        RasterManager rManager = RasterLocator.getManager();
        if (selectedItems.length != 1) {
            return;
        }
        lyr = selectedItems[0];
        if (!(lyr instanceof FLyrRaster)) {
            return;
        }
        FLyrRaster fLayer = (FLyrRaster)lyr;
        this.chooser = new JFileChooser("SAVE_AS_TOC_MENU_ENTRY", JFileChooser.getLastPath((String)"SAVE_AS_TOC_MENU_ENTRY", null));
        this.chooser.addPropertyChangeListener((PropertyChangeListener)this);
        this.chooser.setDialogTitle(Messages.getText((String)"seleccionar_fichero"));
        ArrayList extList = new ArrayList();
        try {
            ProviderServices serv = rManager.getProviderServices();
            extList = serv.getExtensionsSupported(fLayer.getDataStore().getDataType()[0], fLayer.getDataStore().getBandCount());
        }
        catch (RasterDriverException e2) {
            RasterSwingLibrary.messageBoxError((String)"error_extensiones_soportadas", (Object)this.chooser, (Exception)((Object)e2));
            e2.printStackTrace();
            return;
        }
        int selected_id = extList.size() - 1;
        ExtendedFileFilter selected = null;
        for (int i = 0; i < extList.size(); ++i) {
            ExtendedFileFilter filter = new ExtendedFileFilter((String)extList.get(i));
            if (((String)extList.get(i)).equals("tif")) {
                selected = filter;
                selected_id = i;
            }
            this.chooser.addChoosableFileFilter((FileFilter)filter);
        }
        if (selected != null) {
            this.chooser.setFileFilter(selected);
        }
        this.panelProperty = this.loadPanelProperties((String)extList.get(selected_id));
        this.chooser.setAccessory((JComponent)this.panelProperty);
        this.chooser.setAcceptAllFileFilterUsed(false);
        if (w instanceof AbstractViewPanel && this.chooser.showSaveDialog(((AbstractViewPanel)w).getComponent(0)) == 0) {
            String suffix;
            String tit = PluginServices.getMDIManager().getWindowInfo(w).getTitle();
            RasterDataStore datastore = fLayer.getDataStore();
            int[] drawableBands = new int[fLayer.getDataStore().getBandCount()];
            for (int i = 0; i < fLayer.getDataStore().getBandCount(); ++i) {
                drawableBands[i] = i;
            }
            JFileChooser.setLastPath((String)"SAVE_AS_TOC_MENU_ENTRY", (File)this.chooser.getCurrentDirectory());
            String file = ((ExtendedFileFilter)this.chooser.getFileFilter()).getNormalizedFilename(this.chooser.getSelectedFile());
            long bytes = rManager.getRasterUtils().getBytesFromRaster((int)fLayer.getDataStore().getWidth(), (int)fLayer.getDataStore().getHeight(), fLayer.getDataStore().getDataType()[0], fLayer.getDataStore().getBandCount());
            long maxJp2 = 487500000L;
            if (bytes > 1200000000L && !RasterSwingLibrary.messageBoxYesOrNot((String)"output_file_too_big", null)) {
                return;
            }
            if (new File(file).exists() && !RasterSwingLibrary.messageBoxYesOrNot((String)"raster_error_file_exists", null)) {
                return;
            }
            if (file.endsWith(".jp2") && bytes > maxJp2 && !RasterSwingLibrary.messageBoxYesOrNot((String)"output_file_too_big_jpeg2000", null)) {
                return;
            }
            if (!RasterToolsUtil.canWrite(this.chooser.getCurrentDirectory().toString())) {
                return;
            }
            Params params = null;
            try {
                params = rManager.createWriter(file).getParams();
            }
            catch (NotSupportedExtensionException e1) {
                RasterSwingLibrary.messageBoxError((String)"no_driver_escritura", (Object)this, (Exception)((Object)e1));
            }
            catch (RasterDriverException e1) {
                RasterSwingLibrary.messageBoxError((String)"no_driver_escritura", (Object)this, (Exception)((Object)e1));
            }
            ClippingProcess clippingProcess = new ClippingProcess();
            clippingProcess.setActions(new SaveAsActions());
            clippingProcess.addParam("viewname", tit);
            if (fLayer.isRemote()) {
                Envelope env = ((AbstractViewPanel)w).getMapControl().getViewPort().getEnvelope();
                clippingProcess.addParam("realcoordinates", new double[]{env.getMinimum(0), env.getMaximum(1), env.getMaximum(0), env.getMinimum(1)});
                clippingProcess.addParam("resolution", new int[]{(int)fLayer.getDataStore().getWidth(), (int)fLayer.getDataStore().getHeight()});
            } else {
                clippingProcess.addParam("pixelcoordinates", new int[]{0, (int)fLayer.getDataStore().getHeight(), (int)fLayer.getDataStore().getWidth(), 0});
                clippingProcess.addParam("resolution", new int[]{(int)fLayer.getDataStore().getWidth(), (int)fLayer.getDataStore().getHeight()});
            }
            int index = file.lastIndexOf(".");
            if (index > 0 && (suffix = file.substring(index, file.length())).length() == 4) {
                clippingProcess.addParam("suffix", suffix);
            }
            clippingProcess.addParam("filename", file);
            clippingProcess.addParam("layer", fLayer.getDataStore());
            clippingProcess.addParam("drawablebands", drawableBands);
            clippingProcess.addParam("colorInterpretation", datastore.getColorInterpretation());
            clippingProcess.addParam("onelayerperband", new Boolean(false));
            clippingProcess.addParam("interpolationmethod", new Integer(1));
            clippingProcess.addParam("affinetransform", datastore.getAffineTransform());
            clippingProcess.addParam("viewProjection", ((AbstractViewPanel)w).getMapControl().getProjection());
            if (params != null) {
                RasterToolsUtil.loadWriterParamsFromPropertiesPanel(this.panelProperty, params);
            }
            clippingProcess.addParam("driverparams", params);
            clippingProcess.start();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getNewValue() instanceof ExtendedFileFilter) {
            String ext = ((String)((ExtendedFileFilter)evt.getNewValue()).getExtensions().get(0)).toString();
            this.panelProperty = this.loadPanelProperties(ext);
            this.chooser.setAccessory((JComponent)this.panelProperty);
            this.chooser.revalidate();
        }
    }

    private PropertiesComponent loadPanelProperties(String file) {
        PropertiesComponent panelProperty = new PropertiesComponent();
        Params params = null;
        try {
            params = RasterLocator.getManager().createWriter(file).getParams();
        }
        catch (NotSupportedExtensionException e1) {
            JOptionPane.showMessageDialog((Component)PluginServices.getMainFrame(), PluginServices.getText((Object)this, (String)"no_driver_escritura"));
            return null;
        }
        catch (RasterDriverException e1) {
            JOptionPane.showMessageDialog((Component)PluginServices.getMainFrame(), PluginServices.getText((Object)this, (String)"no_driver_escritura"));
            return null;
        }
        RasterToolsUtil.loadPropertiesFromWriterParams(panelProperty, params, null);
        return panelProperty;
    }

    public Icon getIcon() {
        return IconThemeHelper.getImageIcon((String)"layer-saveas");
    }

    public boolean isEnableEvents() {
        return true;
    }
}

