/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.saveraster.operation;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.store.DataServerWriter;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.impl.DefaultMapContextDrawer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.gui.beans.incrementabletask.IIncrementable;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.tools.task.Cancellable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RasterizerLayer
implements DataServerWriter,
IIncrementable {
    private static final GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private Logger log = LoggerFactory.getLogger(RasterizerLayer.class);
    private ViewPort viewPort = null;
    private ViewPort viewPortBlock = null;
    private FLayers flayers = null;
    private Color backgroundColor = null;
    private boolean firstRead = true;
    private int nBlocks = 0;
    protected double wcIntervalo = 0.0;
    protected Dimension dimension = null;
    protected int blockSize = 0;
    protected double wcAlto = 0.0;
    protected int lastBlock = 0;
    protected BufferedImage image = null;
    protected int[] rasterData = null;
    protected int contBlocks = 1;
    protected int percent = 0;
    protected int imgHeight = 0;

    private void calcViewPort(ViewPort vp) {
        Rectangle2D.Double ext = null;
        ext = this.viewPortBlock == null ? new Rectangle2D.Double(vp.getExtent().getMinX(), vp.getExtent().getMaxY() - this.wcIntervalo, vp.getExtent().getWidth(), this.wcIntervalo) : new Rectangle2D.Double(this.viewPortBlock.getExtent().getMinX(), this.viewPortBlock.getExtent().getMinY() - this.wcIntervalo, this.viewPortBlock.getExtent().getWidth(), this.wcIntervalo);
        this.viewPortBlock = new ViewPort(vp.getProjection());
        try {
            Envelope env = geomManager.createEnvelope(ext.getMinX(), ext.getMinY(), ext.getMaxX(), ext.getMaxY(), 0);
            this.viewPortBlock.setEnvelope(env);
        }
        catch (CreateEnvelopeException e) {
            this.log.debug("Error creating the envelope", null, (Object)e);
        }
        this.viewPortBlock.setImageSize(this.dimension);
        this.viewPortBlock.refreshExtent();
    }

    public RasterizerLayer(FLayers flyrs, ViewPort vp, int blockSize) {
        this.blockSize = blockSize;
        this.backgroundColor = vp.getBackColor();
        this.viewPort = new ViewPort(vp.getProjection());
        this.viewPort.setImageSize(vp.getImageSize());
        Rectangle2D ex = vp.getExtent();
        Envelope env = null;
        try {
            env = geomManager.createEnvelope(ex.getMinX(), ex.getMinY(), ex.getMaxX(), ex.getMaxY(), 0);
        }
        catch (CreateEnvelopeException e) {
            this.log.debug("Error creating the envelope", null, (Object)e);
        }
        this.viewPort.setEnvelope(vp.getAdjustedExtent());
        this.wcAlto = this.viewPort.getExtent().getMaxY() - this.viewPort.getExtent().getMinY();
        this.wcIntervalo = (double)blockSize * this.wcAlto / (double)this.viewPort.getImageHeight();
        this.dimension = new Dimension(this.viewPort.getImageWidth(), blockSize);
        this.imgHeight = vp.getImageHeight();
        this.nBlocks = vp.getImageHeight() / blockSize;
        this.lastBlock = vp.getImageHeight() - this.nBlocks * blockSize;
        this.calcViewPort(this.viewPort);
        this.flayers = flyrs;
    }

    public int[] readARGBData(int sX, int sY, int nBand) throws ProcessInterruptedException, OutOfMemoryError {
        return this.readData(sX, sY, nBand);
    }

    public int[] readData(int sX, int sY, int nBand) throws ProcessInterruptedException, OutOfMemoryError {
        if (nBand == 0) {
            this.nBlocks = (int)Math.ceil((double)this.imgHeight / (double)this.blockSize);
            this.image = new BufferedImage(sX, sY, 1);
            Graphics2D g = (Graphics2D)this.image.getGraphics();
            g.setColor(this.backgroundColor);
            g.fillRect(0, 0, this.viewPortBlock.getImageWidth(), this.viewPortBlock.getImageHeight());
            try {
                if (this.firstRead) {
                    for (int i = 0; i < this.flayers.getLayersCount(); ++i) {
                        FLyrRaster raster;
                        if (this.flayers.getLayer(i) instanceof FLyrRaster && (raster = (FLyrRaster)this.flayers.getLayer(i)).getDataStore().getDataType()[0] != 2 && raster.getDataStore().getDataType()[0] != 1) continue;
                    }
                    this.firstRead = false;
                }
                DefaultMapContextDrawer mapContextDrawer = new DefaultMapContextDrawer();
                mapContextDrawer.setMapContext(this.flayers.getMapContext());
                mapContextDrawer.setViewPort(this.viewPortBlock);
                mapContextDrawer.draw(this.flayers, this.image, g, new Cancellable(){

                    public boolean isCanceled() {
                        return false;
                    }

                    public void setCanceled(boolean canceled) {
                    }
                }, this.flayers.getMapContext().getScaleView());
                if (this.contBlocks + 1 == this.nBlocks) {
                    for (int i = 0; i < this.flayers.getLayersCount(); ++i) {
                        FLyrRaster raster;
                        if (this.flayers.getLayer(i) instanceof FLyrRaster && (raster = (FLyrRaster)this.flayers.getLayer(i)).getDataStore().getDataType()[0] != 2 && raster.getDataStore().getDataType()[0] != 1) continue;
                    }
                }
            }
            catch (ReadException e) {
                NotificationManager.addError((String)"Error en el draw de capa", (Throwable)e);
            }
            this.rasterData = this.image.getRGB(0, 0, sX, sY, this.rasterData, 0, sX);
            if ((this.contBlocks + 1) * this.blockSize <= this.viewPort.getImageHeight()) {
                this.dimension = new Dimension(sX, sY);
            } else {
                this.dimension = new Dimension(sX, this.viewPort.getImageHeight() - this.contBlocks * this.blockSize);
                this.wcIntervalo = (double)this.lastBlock * this.wcAlto / (double)this.viewPort.getImageHeight();
            }
            this.calcViewPort(this.viewPortBlock);
            this.percent = 100 * this.contBlocks / this.nBlocks;
            ++this.contBlocks;
            return this.rasterData;
        }
        return null;
    }

    public void setBlockSize(int blockSize) {
        this.blockSize = blockSize;
    }

    public byte[][] readByteData(int sizeX, int sizeY) {
        return null;
    }

    public double[][] readDoubleData(int sizeX, int sizeY) {
        return null;
    }

    public float[][] readFloatData(int sizeX, int sizeY) {
        return null;
    }

    public int[][] readIntData(int sizeX, int sizeY) {
        return null;
    }

    public short[][] readShortData(int sizeX, int sizeY) {
        return null;
    }

    public String getTitle() {
        return PluginServices.getText((Object)this, (String)"salvando_raster");
    }

    public String getLog() {
        return PluginServices.getText((Object)this, (String)"salvando_bloque") + " " + Math.min(this.nBlocks, this.contBlocks) + " " + PluginServices.getText((Object)this, (String)"de") + " " + this.nBlocks;
    }

    public String getLabel() {
        return PluginServices.getText((Object)this, (String)"rasterizando") + "...";
    }

    public int getPercent() {
        return this.percent;
    }

    public boolean isCancelable() {
        return true;
    }

    public boolean isPausable() {
        return false;
    }

    public void setAlphaBuffer(Buffer alphaBuffer) {
    }

    public void setBuffer(Buffer buffer, int nband) {
    }

    public Buffer getBuffer() {
        return null;
    }

    public void setBand(int nband) {
    }

    public void dispose() {
    }

    public Buffer getSource() {
        return null;
    }

    public void setPercent(int value) {
    }
}

