/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.viewexport;

import java.io.File;
import javax.swing.filechooser.FileFilter;

class MyFileFilter
extends FileFilter {
    private String[] extensiones = new String[1];
    private String description = null;
    private boolean dirs = true;
    private String info = null;

    public MyFileFilter(String[] ext, String desc) {
        this.extensiones = ext;
        this.description = desc;
    }

    public MyFileFilter(String[] ext, String desc, String info) {
        this.extensiones = ext;
        this.description = desc;
        this.info = info;
    }

    public MyFileFilter(String ext, String desc) {
        this.extensiones[0] = ext;
        this.description = desc;
    }

    public MyFileFilter(String ext, String desc, String info) {
        this.extensiones[0] = ext;
        this.description = desc;
        this.info = info;
    }

    public MyFileFilter(String ext, String desc, boolean dirs) {
        this.extensiones[0] = ext;
        this.description = desc;
        this.dirs = dirs;
    }

    public MyFileFilter(String ext, String desc, boolean dirs, String info) {
        this.extensiones[0] = ext;
        this.description = desc;
        this.dirs = dirs;
        this.info = info;
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return this.dirs;
        }
        for (int i = 0; i < this.extensiones.length; ++i) {
            if (this.extensiones[i].equals("") || !this.getExtensionOfAFile(f).equalsIgnoreCase(this.extensiones[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String[] getExtensions() {
        return this.extensiones;
    }

    public boolean isDirectory() {
        return this.dirs;
    }

    private String getExtensionOfAFile(File file) {
        String name = file.getName();
        int dotPos = name.lastIndexOf(".");
        if (dotPos < 1) {
            return "";
        }
        return name.substring(dotPos + 1);
    }

    public File normalizeExtension(File file) {
        String ext = this.getExtensionOfAFile(file);
        if (ext.equals("") || !this.accept(file)) {
            return new File(file.getAbsolutePath() + "." + this.extensiones[0]);
        }
        return file;
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String info) {
        this.info = info;
    }
}

