/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.featureform.swing.impl.dynformfield.linkforeingkey;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.gvsig.featureform.swing.FeaturesFormContext;
import org.gvsig.featureform.swing.JFeaturesForm;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.ForeingKey;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.dal.swing.searchpanel.FeatureStoreSearchPanel;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynform.DynFormFieldDefinition;
import org.gvsig.tools.dynform.JDynForm;
import org.gvsig.tools.dynform.JDynFormField;
import org.gvsig.tools.dynform.spi.DynFormSPIManager;
import org.gvsig.tools.dynform.spi.dynformfield.AbstractJDynFormField;
import org.gvsig.tools.dynform.spi.dynformfield.JDynFormFieldFactory;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.Component;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;

public class JDynFormFieldForeingKey
extends AbstractJDynFormField
implements JDynFormField {
    private Object assignedValue = null;
    private Object value = null;
    private Feature relatedFeature = null;
    private JTextComponent txtDescription = null;
    private JButton btnLink = null;
    private JButton btnUnlink = null;
    private JButton btnEdit = null;
    private Color colorok;

    public JDynFormFieldForeingKey(DynFormSPIManager serviceManager, DynFormSPIManager.ComponentsFactory componentsFactory, JDynFormFieldFactory factory, DynFormFieldDefinition definition, Object value) {
        super(serviceManager, componentsFactory, factory, definition, value);
        if (value != null) {
            this.assignedValue = (DynObject)value;
        }
        this.colorok = Color.WHITE;
    }

    public Object getAssignedValue() {
        return this.assignedValue;
    }

    public void initComponentIfNeed() {
        if (this.contents == null) {
            this.initComponent();
        }
    }

    public void initComponent() {
        DynFormSPIManager.ComponentsFactory components = this.getComponentsFactory();
        FocusListener focusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                JDynFormFieldForeingKey.this.fireFieldEnterEvent();
            }

            @Override
            public void focusLost(FocusEvent e) {
                JDynFormFieldForeingKey.this.fireFieldExitEvent();
            }
        };
        this.txtDescription = components.getJTextField(this.getDefinition(), null);
        if (this.txtDescription == null) {
            this.txtDescription = new JTextField();
        }
        this.colorok = this.txtDescription.getBackground();
        this.btnLink = components.getJButton(this.getDefinition(), "Link");
        if (this.btnLink == null) {
            this.btnLink = new JButton();
        }
        this.btnUnlink = components.getJButton(this.getDefinition(), "Unlink");
        if (this.btnUnlink == null) {
            this.btnUnlink = new JButton();
        }
        this.btnEdit = components.getJButton(this.getDefinition(), "Edit");
        if (this.btnEdit == null) {
            this.btnEdit = new JButton();
        }
        ToolsSwingUtils.configurePickersButton((AbstractButton)this.btnLink, (String)"_Select_related_item", (String)"picker-foreingkey-link", ae -> this.doLink(), (FocusListener)focusListener);
        ToolsSwingUtils.configurePickersButton((AbstractButton)this.btnUnlink, (String)"_Remove_relation", (String)"picker-foreingkey-unlink", ae -> this.doUnlink(), (FocusListener)focusListener);
        ToolsSwingUtils.configurePickersButton((AbstractButton)this.btnEdit, (String)"_See_related_item", (String)"picker-foreingkey-showform", ae -> this.doEdit(), (FocusListener)focusListener);
        this.txtDescription.setText("");
        this.txtDescription.addFocusListener(focusListener);
        this.txtDescription.setEnabled(true);
        this.txtDescription.setEditable(false);
        this.txtDescription.setFocusable(true);
        boolean enabled = !this.isReadOnly();
        this.btnEdit.setEnabled(enabled);
        this.btnLink.setEnabled(enabled);
        this.btnUnlink.setEnabled(enabled);
        JPanel panel = new JPanel();
        panel.setFocusCycleRoot(false);
        panel.setFocusable(false);
        if (!components.containsJTextField(this.getDefinition(), null)) {
            panel.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.ipadx = 4;
            c.ipady = 1;
            c.gridx = 1;
            c.gridy = 0;
            c.weightx = 1.0;
            panel.add((java.awt.Component)this.txtDescription, c);
            c.fill = 0;
            c.ipadx = 4;
            c.ipady = 1;
            c.gridx = 2;
            c.gridy = 0;
            c.weightx = 0.0;
            panel.add((java.awt.Component)this.btnLink, c);
            c.fill = 0;
            c.ipadx = 4;
            c.ipady = 1;
            c.gridx = 3;
            c.gridy = 0;
            c.weightx = 0.0;
            panel.add((java.awt.Component)this.btnUnlink, c);
            c.fill = 0;
            c.ipadx = 4;
            c.ipady = 1;
            c.gridx = 4;
            c.gridy = 0;
            c.weightx = 0.0;
            panel.add((java.awt.Component)this.btnEdit, c);
        }
        this.contents = panel;
        this.setValue(this.assignedValue);
    }

    private void fireFocusEvent(java.awt.Component c, int eventId) {
        Object[] focusListeners = (FocusListener[])c.getListeners(FocusListener.class);
        if (!ArrayUtils.isEmpty((Object[])focusListeners)) {
            for (Object focusListener : focusListeners) {
                if (focusListener == null) continue;
                try {
                    FocusEvent e = new FocusEvent(c, eventId);
                    switch (eventId) {
                        case 1004: {
                            focusListener.focusGained(e);
                            break;
                        }
                        case 1005: {
                            focusListener.focusLost(e);
                        }
                    }
                }
                catch (Throwable t) {
                    LOGGER.warn("Can't fire eveny focusGained on DropDownLabel (" + focusListener.getClass().getName() + ").", t);
                }
            }
        }
    }

    private ForeingKey getForeingKey() {
        JDynForm.DynFormContext context = this.getForm().getContext();
        if (!(context instanceof FeaturesFormContext)) {
            return null;
        }
        FeatureType featureType = ((FeaturesFormContext)context).getFeatureType();
        if (featureType == null) {
            return null;
        }
        FeatureAttributeDescriptor attribute = featureType.getAttributeDescriptor(this.getName());
        if (attribute == null) {
            return null;
        }
        ForeingKey foreingKey = attribute.getForeingKey();
        return foreingKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLink0() {
        ForeingKey foreingKey = this.getForeingKey();
        if (foreingKey == null) {
            return;
        }
        final ForeingKey.ContextForeingKey context = foreingKey.createContext();
        try {
            final List features = foreingKey.getFeatures(context);
            ListModel<String> model = new ListModel<String>(){

                @Override
                public int getSize() {
                    return features.size();
                }

                @Override
                public String getElementAt(int index) {
                    Feature feature = (Feature)features.get(index);
                    ForeingKey foreingKey = JDynFormFieldForeingKey.this.getForeingKey();
                    return foreingKey.getLabel(context, feature);
                }

                @Override
                public void addListDataListener(ListDataListener l) {
                }

                @Override
                public void removeListDataListener(ListDataListener l) {
                }
            };
            WindowManager_v2 winManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
            JList<String> jlist = new JList<String>();
            JScrollPane jscroll = new JScrollPane(jlist);
            jscroll.setHorizontalScrollBarPolicy(31);
            jscroll.setVerticalScrollBarPolicy(20);
            jlist.setModel(model);
            jlist.setPreferredSize(new Dimension(350, 200));
            Dialog dialog = winManager.createDialog((JComponent)jscroll, "Select", "Select the '" + this.getLabel() + "'.", 3);
            dialog.addActionListener(e -> {
                if (dialog.getAction() == 1) {
                    int n = jlist.getSelectedIndex();
                    if (n < 0) {
                        return;
                    }
                    Feature feature = (Feature)features.get(n);
                    if (feature != null) {
                        this.setEditedValue(foreingKey.getCode(context, feature));
                        this.fireFieldChangedEvent();
                    }
                }
            });
            dialog.show(WindowManager.MODE.DIALOG);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't show selector", (Throwable)ex);
        }
        finally {
            DisposeUtils.disposeQuietly((Disposable)context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLink() {
        ForeingKey foreingKey = this.getForeingKey();
        if (foreingKey == null) {
            return;
        }
        ForeingKey.ContextForeingKey context = foreingKey.createContext();
        try {
            DataSwingManager dataSwingManager = DALSwingLocator.getSwingManager();
            FeatureStoreSearchPanel searchPanel = dataSwingManager.createFeatureStoreSearchPanel(foreingKey.getFeatureStore(context));
            searchPanel.setFilterOnlyMode(true);
            WindowManager_v2 winManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
            ToolsSwingUtils.ensureHeightWitdh((Component)searchPanel, (int)0, (float)0.75f, (float)0.75f, (float)0.85f, (float)0.85f);
            Dialog dialog = winManager.createDialog(searchPanel.asJComponent(), "Select", "Select the '" + this.getLabel() + "'.", 3);
            dialog.setButtonEnabled(1, this.btnUnlink.isEnabled());
            dialog.addActionListener(e -> {
                Feature feature;
                if (dialog.getAction() == 1 && (feature = searchPanel.getLastSelectedFeature()) != null) {
                    this.setEditedValue(foreingKey.getCode(context, feature));
                    this.relatedFeature = feature;
                    this.fireFieldChangedEvent();
                }
            });
            dialog.show(WindowManager.MODE.DIALOG);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't show selector", (Throwable)ex);
        }
        finally {
            DisposeUtils.disposeQuietly((Disposable)context);
        }
    }

    public Feature getRelatedFeature() {
        try {
            if (this.relatedFeature != null) {
                return this.relatedFeature;
            }
            ForeingKey foreingKey = this.getForeingKey();
            if (foreingKey == null) {
                return null;
            }
            this.relatedFeature = foreingKey.getFeature(null, this.value);
            return this.relatedFeature;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't retrieve related feature from '" + this.value + "'.", (Throwable)ex);
            return null;
        }
    }

    private void doUnlink() {
        this.setEditedValue(null);
        this.fireFieldChangedEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doEdit() {
        if (this.value == null) {
            return;
        }
        ForeingKey foreingKey = this.getForeingKey();
        if (foreingKey == null) {
            return;
        }
        ForeingKey.ContextForeingKey context = foreingKey.createContext();
        try {
            this.btnEdit.setEnabled(false);
            DataSwingManager dataSwingManager = DALSwingLocator.getSwingManager();
            FeatureQuery query = foreingKey.getQuery(context, this.value);
            JFeaturesForm form = dataSwingManager.createJFeaturesForm(foreingKey.getFeatureStore(context));
            form.setQuery(query);
            form.showForm(WindowManager.MODE.WINDOW);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't show linked form", (Throwable)ex);
        }
        finally {
            this.btnEdit.setEnabled(true);
            DisposeUtils.disposeQuietly((Disposable)context);
        }
    }

    private String getDescription() {
        if (this.value == null) {
            return null;
        }
        try {
            ForeingKey foreingKey = this.getForeingKey();
            if (foreingKey == null) {
                return null;
            }
            String description = foreingKey.getLabel(null, this.value);
            return description;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setReadOnly(boolean readonly) {
        this.initComponentIfNeed();
        this.readOnly = readonly;
        boolean editable = !readonly;
        JComponent theJLabel = this.getJLabel();
        if (this.jlabel != null) {
            this.jlabel.setEnabled(editable);
        } else if (theJLabel != null) {
            theJLabel.setEnabled(editable);
        }
        this.txtDescription.setEditable(false);
        this.btnEdit.setEnabled(true);
        this.btnLink.setEnabled(true);
        this.btnUnlink.setEnabled(editable);
        this.setReadOnlyButtonsOfEvents(readonly);
    }

    public void setValue(Object value) {
        this.setEditedValue(value);
        this.assignedValue = value;
        this.relatedFeature = null;
    }

    public void setEditedValue(Object value) {
        this.initComponentIfNeed();
        if (value == null) {
            this.value = null;
            this.txtDescription.setText("");
            return;
        }
        this.problemIndicator().clear();
        this.value = value;
        String description = this.getDescription();
        if (description == null) {
            this.txtDescription.setText(Objects.toString(value, ""));
            this.txtDescription.setBackground(ToolsSwingLocator.getToolsSwingManager().getWarningBackgroundColor());
            I18nManager i18n = ToolsLocator.getI18nManager();
            this.problemIndicator().set(i18n.getTranslation("_Related_feature_not_found"));
        } else {
            this.txtDescription.setText(Objects.toString(description));
            this.txtDescription.setBackground(this.colorok);
        }
    }

    public Object getValue() {
        return this.value;
    }

    public boolean hasValidValue() {
        return true;
    }

    public void clear() {
        this.setValue(null);
    }

    public boolean isModified() {
        return !Objects.equals(this.value, this.getAssignedValue());
    }

    public String toHTML() {
        return "<span>" + StringEscapeUtils.escapeHtml3((String)this.getDescription()) + "</span>";
    }
}

