/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.fmap.dal.DataSet;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.swing.AbstractDALActionFactory;
import org.gvsig.fmap.dal.swing.DALActionFactory;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectionFilterAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectionFilterAction.class);
    private final DALActionFactory.DALActionContext context;

    public SelectionFilterAction(DALActionFactory.DALActionContext context) {
        this.context = context;
        ImageIcon icon = ToolsSwingLocator.getIconThemeManager().getCurrent().get("storeaction-select-filter");
        if (icon == null) {
            LOGGER.warn("Can't locate icon 'search-action-select-filter'.");
        }
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.putValue("ActionCommandKey", "SelectionFilter");
        this.putValue("ShortDescription", i18n.getTranslation("_Filter_selection"));
        this.putValue("SmallIcon", icon);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            DataStore store = this.context.getStore();
            if (!(store instanceof FeatureStore)) {
                return;
            }
            FeatureStore featureStore = (FeatureStore)store;
            FeatureSelection contextSelection = this.context.getSelecteds();
            if (contextSelection == null) {
                Expression filter;
                FeatureQuery query = null;
                FeatureQuery contextQuery = this.context.getQuery();
                if (contextQuery != null && (filter = contextQuery.getExpressionFilter()) != null) {
                    query = featureStore.createFeatureQuery();
                    query.setFilter(filter);
                }
                contextSelection = featureStore.getFeatureSelection();
                if (query == null) {
                    return;
                }
                FeatureSet set = featureStore.getFeatureSet(query);
                FeatureSelection newSelection = featureStore.createFeatureSelection();
                for (Feature feature : set) {
                    if (!contextSelection.isSelected(feature)) continue;
                    newSelection.select(feature);
                }
                store.setSelection((DataSet)newSelection);
            } else {
                FeatureSelection newSelection = featureStore.createFeatureSelection();
                FeatureSelection currentSelection = featureStore.getFeatureSelection();
                for (FeatureReference ref : contextSelection.referenceIterable()) {
                    if (!currentSelection.isSelected(ref)) continue;
                    newSelection.select(ref);
                }
                store.setSelection((DataSet)newSelection);
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Can't build selecction.", (Throwable)ex);
        }
    }

    public static class SelectionFilterActionFactory
    extends AbstractDALActionFactory {
        public static final String ACTION_NAME = "SelectionFilter";

        public SelectionFilterActionFactory() {
            super(ACTION_NAME);
        }

        public Action createAction(DALActionFactory.DALActionContext context) {
            return new SelectionFilterAction(context);
        }

        public static void selfRegister() {
            DataSwingManager dalSwingManager = DALSwingLocator.getSwingManager();
            dalSwingManager.registerStoreAction((DALActionFactory)new SelectionFilterActionFactory());
        }
    }
}

