/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.featuretype;

import java.util.function.Predicate;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.event.ChangeListener;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.swing.ExpressionBuilderConfig;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingLocator;
import org.gvsig.expressionevaluator.swing.ExpressionEvaluatorSwingManager;
import org.gvsig.expressionevaluator.swing.ExpressionPickerController;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.swing.featuretype.AttributeDescriptorAndExpressionPickerController;
import org.gvsig.fmap.dal.swing.featuretype.AttributeDescriptorPickerController;
import org.gvsig.fmap.dal.swing.impl.featuretype.DefaultAttributeDescriptorPickerController;
import org.gvsig.tools.bookmarksandhistory.Bookmarks;
import org.gvsig.tools.bookmarksandhistory.History;

public class DefaultAttributeDescriptorAndExpressionPickerController
implements AttributeDescriptorAndExpressionPickerController {
    private final ExpressionPickerController expressionPicker;
    private final AttributeDescriptorPickerController attributePicker;
    private final JComboBox combo;

    public DefaultAttributeDescriptorAndExpressionPickerController(JComboBox combo, JButton button, JButton bookmarks, JButton history, Predicate<FeatureAttributeDescriptor> filter) {
        this.combo = combo;
        ExpressionEvaluatorSwingManager expressionSwingManager = ExpressionEvaluatorSwingLocator.getManager();
        this.expressionPicker = expressionSwingManager.createExpressionPickerController(combo, button, bookmarks, history);
        this.attributePicker = new DefaultAttributeDescriptorPickerController(combo, filter);
        this.attributePicker.addChangeListener(e -> {
            FeatureAttributeDescriptor descriptor = (FeatureAttributeDescriptor)this.attributePicker.get();
            if (descriptor == null) {
                this.expressionPicker.set(null);
            } else {
                String name = descriptor.getName();
                String id = ExpressionUtils.createExpressionBuilder().identifier(name);
                this.expressionPicker.set((Object)ExpressionUtils.createExpression((String)id));
            }
        });
        this.combo.setEditable(true);
    }

    public Expression get() {
        return this.expressionPicker.get();
    }

    public Expression getWithOutHistory() {
        return this.expressionPicker.getWithOutHistory();
    }

    public ExpressionBuilderConfig getConfig() {
        return this.expressionPicker.getConfig();
    }

    public void set(Expression value) {
        if (value == null) {
            this.attributePicker.clean();
        }
        this.expressionPicker.set((Object)value);
    }

    public void coerceAndSet(Object value) {
        this.expressionPicker.coerceAndSet(value);
    }

    public void setEnabled(boolean enabled) {
        this.expressionPicker.setEnabled(enabled);
        this.attributePicker.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.expressionPicker.isEnabled();
    }

    public void setEditable(boolean editable) {
        this.expressionPicker.setEditable(editable);
        this.attributePicker.setEditable(editable);
        this.combo.setEditable(true);
    }

    public boolean isEditable() {
        return this.expressionPicker.isEditable();
    }

    public boolean isValid() {
        return this.expressionPicker.isValid();
    }

    public boolean isEmpty() {
        return this.expressionPicker.isEmpty();
    }

    public void addChangeListener(ChangeListener listener) {
        this.expressionPicker.addChangeListener(listener);
    }

    public ChangeListener[] getChangeListeners() {
        return this.expressionPicker.getChangeListeners();
    }

    public void removeChangeListener(ChangeListener listener) {
        this.expressionPicker.removeChangeListener(listener);
    }

    public void removeAllChangeListener() {
        this.expressionPicker.removeAllChangeListener();
    }

    public boolean hasChangeListeners() {
        return this.expressionPicker.hasChangeListeners();
    }

    public void setFeatureType(FeatureType featureType) {
        this.attributePicker.setFeatureType(featureType);
    }

    public void setDescriptor(FeatureAttributeDescriptor descriptor) {
        this.attributePicker.set((Object)descriptor);
    }

    public String getName() {
        return this.attributePicker.getName();
    }

    public FeatureAttributeDescriptor getDescriptor() {
        return (FeatureAttributeDescriptor)this.attributePicker.get();
    }

    public void clean() {
        this.expressionPicker.set(null);
        this.attributePicker.clean();
    }

    public void setName(String name) {
        this.attributePicker.set(name);
    }

    public void setAllowNull(boolean allowNull) {
        this.attributePicker.setAllowNull(allowNull);
    }

    public boolean getAllowNull() {
        return this.attributePicker.getAllowNull();
    }

    public void setHistory(History history) {
        this.expressionPicker.setHistory(history);
    }

    public void setBookmarks(Bookmarks bookmarks) {
        this.expressionPicker.setBookmarks(bookmarks);
    }
}

