/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.featuretype;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.function.Predicate;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.swing.featuretype.AttributeDescriptorPickerController;
import org.gvsig.fmap.dal.swing.impl.featuretype.FeatureAttributeListCellRendererImpl;
import org.gvsig.tools.swing.api.ListElement;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.pickercontroller.AbstractPickerController;
import org.gvsig.tools.util.LabeledValue;
import org.gvsig.tools.util.LabeledValueImpl;

public class DefaultAttributeDescriptorPickerController
extends AbstractPickerController<FeatureAttributeDescriptor>
implements AttributeDescriptorPickerController {
    private final ComboOrList<FeatureAttributeDescriptor> combo;
    private FeatureType featureType;
    private final Predicate<FeatureAttributeDescriptor> filter;

    public DefaultAttributeDescriptorPickerController(JComboBox combo, Predicate<FeatureAttributeDescriptor> filter) {
        this(new ComboOrList(combo), filter);
        combo.setRenderer(new FeatureAttributeListCellRendererImpl());
    }

    public DefaultAttributeDescriptorPickerController(JList list, Predicate<FeatureAttributeDescriptor> filter) {
        this(new ComboOrList(list), filter);
        list.setCellRenderer(new FeatureAttributeListCellRendererImpl());
    }

    private DefaultAttributeDescriptorPickerController(ComboOrList combo, Predicate<FeatureAttributeDescriptor> filter) {
        this.combo = combo;
        this.filter = filter;
        ((ComboOrList)this.combo).addSelectionListener(e -> this.fireChangeEvent());
    }

    public void setFeatureType(FeatureType featureType) {
        this.featureType = featureType;
        this.combo.clear();
        if (this.featureType == null) {
            return;
        }
        ArrayList<FeatureAttributeDescriptor> attributes = new ArrayList<FeatureAttributeDescriptor>();
        for (FeatureAttributeDescriptor descriptor : featureType) {
            if (this.filter != null && !this.filter.test(descriptor)) continue;
            attributes.add(descriptor);
        }
        int useLabels = 2;
        attributes.sort((o1, o2) -> {
            String theLabel2;
            String theLabel1;
            switch (useLabels) {
                case 1: {
                    theLabel1 = o1.getName();
                    theLabel2 = o2.getName();
                    break;
                }
                case 0: {
                    theLabel1 = o1.hasLabel() ? o1.getLocalizedLabel() : o1.getName();
                    theLabel2 = o2.hasLabel() ? o2.getLocalizedLabel() : o2.getName();
                    break;
                }
                default: {
                    theLabel1 = o1.hasLabel() ? String.format("%s [%s]", o1.getLocalizedLabel(), o1.getName()) : o1.getName();
                    theLabel2 = o2.hasLabel() ? String.format("%s [%s]", o2.getLocalizedLabel(), o2.getName()) : o2.getName();
                }
            }
            return theLabel1.compareToIgnoreCase(theLabel2);
        });
        for (FeatureAttributeDescriptor descriptor : attributes) {
            this.combo.add((LabeledValue)descriptor);
        }
        if (this.combo.getSize() > 0) {
            this.combo.setSelectedIndex(0);
        } else {
            this.combo.setSelectedIndex(-1);
        }
    }

    public FeatureAttributeDescriptor get() {
        FeatureAttributeDescriptor o = this.combo.getSelectedValue();
        if (o instanceof FeatureAttributeDescriptor) {
            FeatureAttributeDescriptor descriptor = this.combo.getSelectedValue();
            return descriptor;
        }
        return null;
    }

    public void set(FeatureAttributeDescriptor descriptor) {
        this.combo.setSelectedValue(descriptor);
    }

    public void set(String name) {
        if (this.featureType == null) {
            this.combo.setSelectedIndex(-1);
            return;
        }
        FeatureAttributeDescriptor descriptor = this.featureType.getAttributeDescriptor(name);
        if (descriptor == null) {
            this.combo.setSelectedIndex(-1);
            return;
        }
        this.set(descriptor);
    }

    public void coerceAndSet(Object descriptor) {
        if (descriptor instanceof CharSequence) {
            this.set(descriptor.toString());
            return;
        }
        this.set((FeatureAttributeDescriptor)descriptor);
    }

    public void setEnabled(boolean enabled) {
        this.combo.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.combo.isEnabled();
    }

    public boolean isEmpty() {
        return this.get() == null;
    }

    public String getName() {
        Object selected = this.combo.getSelectedValue();
        if (selected == null) {
            return null;
        }
        if (selected instanceof CharSequence) {
            if (StringUtils.isBlank((CharSequence)((CharSequence)selected))) {
                return null;
            }
            return selected.toString();
        }
        if (selected instanceof LabeledValue && (selected = ((LabeledValue)selected).getValue()) == null) {
            return null;
        }
        if (selected instanceof FeatureAttributeDescriptor) {
            return selected.getName();
        }
        return null;
    }

    public void clean() {
        this.combo.setSelectedIndex(-1);
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.combo.setEnabled(editable);
    }

    public void setAllowNull(boolean allowNull) {
        this.combo.setAllowNull(allowNull);
    }

    public boolean getAllowNull() {
        return this.combo.getAllowNull();
    }

    private static class ComboOrList<T>
    implements org.gvsig.tools.swing.api.Component {
        private JComboBox combo;
        private JList list;
        private boolean allowNull;

        public ComboOrList(JComboBox combo) {
            this.combo = combo;
            this.combo.setEditor(new ComboBoxEditorAdapter(this.combo.getEditor()));
            this.combo.setEditable(true);
            JTextComponent text = (JTextComponent)this.combo.getEditor().getEditorComponent();
            text.setEditable(false);
            this.setAllowNull(true);
        }

        public ComboOrList(JList list) {
            this.list = list;
        }

        public JComponent asJComponent() {
            if (this.combo == null) {
                return this.list;
            }
            return this.combo;
        }

        private void addSelectionListener(ActionListener listener) {
            if (this.combo == null) {
                this.list.addListSelectionListener(e -> {
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    listener.actionPerformed(new ActionEvent(this.list, 0, "selected"));
                });
            } else {
                this.combo.addActionListener(e -> listener.actionPerformed(new ActionEvent(this.combo, 0, "selected")));
            }
        }

        public void clear() {
            if (this.combo == null) {
                DefaultListModel model = new DefaultListModel();
                this.list.setModel(model);
            } else {
                DefaultComboBoxModel model = new DefaultComboBoxModel();
                this.combo.setModel(model);
            }
        }

        public void add(LabeledValue value) {
            if (this.combo == null) {
                DefaultListModel model = (DefaultListModel)this.list.getModel();
                model.addElement(value);
            } else {
                DefaultComboBoxModel model = (DefaultComboBoxModel)this.combo.getModel();
                if (this.allowNull && model.getSize() == 0) {
                    model.addElement(new LabeledValueImpl("  ", null));
                }
                model.addElement(value);
            }
        }

        public int getSize() {
            if (this.combo == null) {
                return this.list.getModel().getSize();
            }
            return this.combo.getModel().getSize();
        }

        public void setSelectedIndex(int i) {
            if (this.combo == null) {
                this.list.setSelectedIndex(i);
            } else {
                this.combo.setSelectedIndex(i);
            }
        }

        public void setEnabled(boolean enabled) {
            if (this.combo == null) {
                this.list.setEnabled(enabled);
            } else {
                this.combo.setEnabled(enabled);
            }
        }

        public boolean isEnabled() {
            if (this.combo == null) {
                return this.list.isEnabled();
            }
            return this.combo.isEnabled();
        }

        public boolean getAllowNull() {
            return this.allowNull;
        }

        public final void setAllowNull(boolean allowNull) {
            this.allowNull = allowNull;
            if (this.combo != null) {
                ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
                if (this.allowNull) {
                    toolsSwingManager.addClearButton(this.combo, e -> this.combo.setSelectedIndex(-1));
                }
            }
        }

        public void setSelectedValue(T value) {
            if (this.combo == null) {
                ListElement.setSelected((JList)this.list, value);
            } else {
                ListElement.setSelected((JComboBox)this.combo, value);
            }
        }

        public T getSelectedValue() {
            Object value = this.combo == null ? ListElement.getSelected((JList)this.list) : ListElement.getSelected((JComboBox)this.combo);
            return (T)value;
        }
    }

    private static class ComboBoxEditorAdapter
    implements ComboBoxEditor {
        private ComboBoxEditor delegate;

        public ComboBoxEditorAdapter(ComboBoxEditor delegate) {
            this.delegate = delegate;
        }

        @Override
        public Component getEditorComponent() {
            return this.delegate.getEditorComponent();
        }

        @Override
        public void setItem(Object anObject) {
            if (anObject instanceof LabeledValue) {
                this.delegate.setItem(((LabeledValue)anObject).getLabel());
            } else {
                this.delegate.setItem(anObject);
            }
        }

        @Override
        public Object getItem() {
            return null;
        }

        @Override
        public void selectAll() {
            this.delegate.selectAll();
        }

        @Override
        public void addActionListener(ActionListener l) {
            this.delegate.addActionListener(l);
        }

        @Override
        public void removeActionListener(ActionListener l) {
            this.delegate.removeActionListener(l);
        }
    }
}

