/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.featuretype.featurerule;

import java.util.Collections;
import java.util.Iterator;
import javax.swing.table.AbstractTableModel;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.feature.FeatureRule;
import org.gvsig.fmap.dal.feature.FeatureRuleExpression;
import org.gvsig.fmap.dal.feature.FeatureRules;
import org.gvsig.fmap.dal.swing.impl.featuretype.aggregatecontroller.AggregateController;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;

public class FeatureRulesModel
extends AbstractTableModel
implements AggregateController.AggregateModel<FeatureRule> {
    private static final int COLUMN_NAME = 0;
    private static final int COLUMN_AT_FINISH_EDITING = 1;
    private static final int COLUMN_AT_INSERT = 2;
    private FeatureRules rules;
    private String[] columnNames;
    private Class[] columnClases;

    public FeatureRulesModel() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.rules = null;
        this.columnNames = new String[]{i18n.getTranslation("_Name"), i18n.getTranslation("_At_finish_editing"), i18n.getTranslation("_At_insert")};
        this.columnClases = new Class[]{String.class, Boolean.class, Boolean.class};
    }

    public FeatureRulesModel(FeatureRules rules) {
        this();
        this.rules = rules;
    }

    @Override
    public FeatureRule createItem() {
        DataManager manager = DALLocator.getDataManager();
        FeatureRuleExpression rule = manager.createFeatureRuleExpression();
        return rule;
    }

    @Override
    public int addItem(FeatureRule rule) {
        if (this.rules == null) {
            return -1;
        }
        this.rules.add(rule);
        this.fireTableDataChanged();
        return this.rules.size() - 1;
    }

    @Override
    public void itemUpdated(int position) {
        this.fireTableDataChanged();
    }

    public FeatureRule get(int position) {
        if (this.rules == null) {
            return null;
        }
        return this.rules.get(position);
    }

    @Override
    public Iterator<FeatureRule> iterator() {
        if (this.rules == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.rules.iterator();
    }

    @Override
    public int getRowCount() {
        if (this.rules == null) {
            return 0;
        }
        return this.rules.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columnNames[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.columnClases[columnIndex];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.rules == null) {
            return null;
        }
        FeatureRule rule = this.rules.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return rule.getName();
            }
            case 1: {
                return rule.checkAtFinishEditing();
            }
            case 2: {
                return rule.checkAtUpdate();
            }
        }
        return null;
    }

    @Override
    public void fetch(Object container) {
        if (container == this.rules) {
            return;
        }
        FeatureRules theRules = (FeatureRules)container;
        while (!theRules.isEmpty()) {
            theRules.remove(0);
        }
        for (FeatureRule rule : this.rules) {
            theRules.add(rule);
        }
    }
}

