/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.searchPostProcess.distinctOn;

import java.util.List;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.swing.impl.searchPostProcess.distinctOn.AbstractAggregateOperation;
import org.gvsig.fmap.dal.swing.impl.searchPostProcess.distinctOn.AggregateOperation;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;

public class STConvexHullAggregateOperation
extends AbstractAggregateOperation {
    Geometry geom = null;

    public boolean isApplicable(Object ... value) {
        return value[0] instanceof Geometry;
    }

    @Override
    public void reset() {
        this.geom = null;
    }

    @Override
    public void perform(Object value) {
        try {
            if (value == null) {
                return;
            }
            if (this.geom == null) {
                this.geom = ((Geometry)value).convexHull();
                return;
            }
            MultiPolygon mp = GeometryUtils.createMultiPolygon((int)this.geom.getGeometryType().getSubType());
            mp.addPrimitives(this.geom);
            mp.addPrimitives((Geometry)value);
            this.geom = mp.convexHull();
        }
        catch (Exception ex) {
            throw new RuntimeException("", ex);
        }
    }

    @Override
    public Object getValue() {
        return this.geom;
    }

    @Override
    public void fixAttributeDescriptor(EditableFeatureAttributeDescriptor descriptor) {
        super.fixAttributeDescriptor(descriptor);
        descriptor.setDataType(66);
        descriptor.setGeometryType(19, 0);
        descriptor.setRelationType(0);
        descriptor.getForeingKey().clean();
        descriptor.setAvailableValues((List)null);
    }

    public static class STConvexHullAggregateOperationFactory
    implements AggregateOperation.AggregateOperationFactory {
        public static final String NAME = "ConvexHull";

        public String getName() {
            return NAME;
        }

        @Override
        public AggregateOperation create(Object ... os) {
            return new STConvexHullAggregateOperation();
        }

        public boolean isApplicable(Object ... value) {
            return Geometry.class.isAssignableFrom((Class)value[0]);
        }
    }
}

