/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.searchPostProcess.distinctOn;

import java.util.List;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.swing.impl.searchPostProcess.distinctOn.AbstractAggregateOperation;
import org.gvsig.fmap.dal.swing.impl.searchPostProcess.distinctOn.AggregateOperation;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.aggregate.MultiCurve;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiSurface;
import org.gvsig.fmap.geom.complex.Complex;
import org.gvsig.fmap.geom.type.GeometryType;

public class STUnionAggregateOperation
extends AbstractAggregateOperation {
    private static final int HAS_POINT = 1;
    private static final int HAS_CURVE = 2;
    private static final int HAS_SURFACE = 4;
    MultiPoint multiPoint = null;
    MultiCurve multiCurve = null;
    MultiSurface multiSurface = null;
    int resultType = 0;
    int resultSubType = 4;
    GeometryManager geometryManager = GeometryLocator.getGeometryManager();

    public boolean isApplicable(Object ... value) {
        return value[0] instanceof Geometry;
    }

    @Override
    public void reset() {
        this.multiPoint = null;
        this.multiCurve = null;
        this.multiSurface = null;
        this.resultType = 0;
        this.resultSubType = 4;
    }

    @Override
    public void perform(Object value) {
        try {
            if (value == null) {
                return;
            }
            Geometry geom = (Geometry)value;
            GeometryType type = geom.getGeometryType();
            if (this.multiPoint == null) {
                this.resultSubType = type.getSubType();
                this.multiPoint = this.geometryManager.createMultiPoint(this.resultSubType);
                this.multiCurve = this.geometryManager.createMultiCurve(this.resultSubType);
                this.multiSurface = this.geometryManager.createMultiSurface(this.resultSubType);
            }
            if (type.isTypeOf(1) || type.isTypeOf(7)) {
                this.multiPoint.addPrimitives(geom);
                this.resultType |= 1;
            } else if (type.isTypeOf(2) || type.isTypeOf(8)) {
                this.multiCurve.addPrimitives(geom);
                this.resultType |= 2;
            } else if (type.isTypeOf(3) || type.isTypeOf(9)) {
                this.multiSurface.addPrimitives(geom);
                this.resultType |= 4;
            } else if (type.isTypeOf(17)) {
                Complex complex = (Complex)value;
                for (Geometry geom1 : complex) {
                    if (geom1.getGeometryType().isTypeOf(1) || geom1.getGeometryType().isTypeOf(7)) {
                        this.multiPoint.addPrimitives(geom1);
                        this.resultType |= 1;
                        continue;
                    }
                    if (geom1.getGeometryType().isTypeOf(2) || geom1.getGeometryType().isTypeOf(8)) {
                        this.multiCurve.addPrimitives(geom1);
                        this.resultType |= 2;
                        continue;
                    }
                    if (!geom1.getGeometryType().isTypeOf(3) && !geom1.getGeometryType().isTypeOf(9)) continue;
                    this.multiSurface.addPrimitives(geom1);
                    this.resultType |= 4;
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("", ex);
        }
    }

    @Override
    public Object getValue() {
        try {
            if (this.resultType == 1) {
                return this.multiPoint.union();
            }
            if (this.resultType == 2) {
                return this.multiCurve.dissolve();
            }
            if (this.resultType == 4) {
                return this.multiSurface.union();
            }
            Geometry combinedGeometry = this.geometryManager.create(17, this.resultSubType);
            Complex complex = (Complex)combinedGeometry;
            if ((this.resultType & 1) == 1) {
                complex.addPrimitives(this.multiPoint.union());
            }
            if ((this.resultType & 2) == 2) {
                complex.addPrimitives(this.multiCurve.dissolve());
            }
            if ((this.resultType & 4) == 4) {
                complex.addPrimitives(this.multiSurface.union());
            }
            return complex;
        }
        catch (Exception ex) {
            throw new RuntimeException("", ex);
        }
    }

    @Override
    public void fixAttributeDescriptor(EditableFeatureAttributeDescriptor descriptor) {
        super.fixAttributeDescriptor(descriptor);
        descriptor.setRelationType(0);
        descriptor.getForeingKey().clean();
        descriptor.setAvailableValues((List)null);
    }

    public static class STUnionAggregateOperationFactory
    implements AggregateOperation.AggregateOperationFactory {
        public static final String NAME = "Combine";

        public String getName() {
            return NAME;
        }

        @Override
        public AggregateOperation create(Object ... os) {
            return new STUnionAggregateOperation();
        }

        public boolean isApplicable(Object ... value) {
            return Geometry.class.isAssignableFrom((Class)value[0]);
        }
    }
}

