/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.searchpanel;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.expressionevaluator.FeatureAttributeEmulatorExpression;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureQueryOrder;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.swing.searchpanel.SearchParameters;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class DefaultSearchParameters
implements SearchParameters,
Cloneable {
    private List<String> resultColumnNames = new ArrayList<String>();
    private FeatureQuery query = null;
    private String name;
    private Map<String, JsonObject> values = new HashMap<String, JsonObject>();
    private int searchMode = 0;
    private boolean ignoreAggregateFunctions;

    public List<String> getResultColumnNames() {
        return this.resultColumnNames;
    }

    public List<String> getGroupByColumns() {
        return this.query.getGroupByColumns();
    }

    public Map<String, String> getAggregateFunctions() {
        return this.query.getAggregateFunctions();
    }

    public void setQuery(FeatureQuery query) {
        this.query = query;
    }

    public void setFilter(Expression exp) {
        this.query.setFilter(exp);
    }

    public FeatureQuery getQuery() {
        return this.query;
    }

    public FeatureQuery getQueryToApply() {
        if (this.query == null) {
            return null;
        }
        FeatureQuery theQuery = this.query.getCopy();
        if (this.ignoreAggregateFunctions) {
            theQuery.getAggregateFunctions().clear();
        }
        return theQuery;
    }

    void setResultColumnNames(List<String> selectedNames) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Map<String, JsonObject> getValues() {
        return this.values;
    }

    public static void registerPersistence() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition("SearchParameters") == null) {
            DynStruct definition = manager.addDefinition(DefaultSearchParameters.class, "DefaultSearchParameters", "DefaultSearchParameters persistence definition", null, null);
            definition.addDynFieldList("resultColumnNames").setClassOfItems(String.class);
            definition.addDynFieldMap("values").setClassOfItems(String.class);
            definition.addDynFieldObject("query").setClassOfValue(FeatureQuery.class).setMandatory(false);
            definition.addDynFieldString("name");
            definition.addDynFieldInt("searchMode").setDefaultFieldValue((Object)0).setMandatory(false);
            definition.addDynFieldBoolean("ignoreAggregateFunctions").setDefaultFieldValue((Object)false).setMandatory(false);
        }
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("resultColumnNames", this.resultColumnNames);
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        for (String key : this.values.keySet()) {
            JsonObject value = this.values.get(key);
            valuesMap.put(key, value.toString());
        }
        state.set("values", valuesMap);
        state.set("query", (Persistent)this.query);
        state.set("name", this.name);
        state.set("searchMode", this.searchMode);
        state.set("ignoreAggregateFunctions", this.ignoreAggregateFunctions);
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.resultColumnNames = new ArrayList<String>(state.getList("resultColumnNames"));
        Map valuesState = state.getMap("values");
        HashMap<String, JsonObject> valuesMap = new HashMap<String, JsonObject>();
        for (String key : valuesState.keySet()) {
            String value = (String)valuesState.get(key);
            ByteArrayInputStream targetStream = new ByteArrayInputStream(value.getBytes());
            JsonReader reader = Json.createReader((InputStream)targetStream);
            JsonObject jsonObject = reader.readObject();
            valuesMap.put(key, jsonObject);
        }
        this.values = valuesMap;
        this.query = (FeatureQuery)state.get("query");
        this.name = state.getString("name");
        this.searchMode = state.getInt("searchMode", 0);
        this.ignoreAggregateFunctions = state.getBoolean("ignoreAggregateFunctions", false);
    }

    private boolean isColumn(String name, FeatureType type) {
        FeatureAttributeDescriptor attr;
        if (type != null && (attr = type.getAttributeDescriptorFromAll(name)) != null) {
            return true;
        }
        if (this.query != null) {
            EditableFeatureAttributeDescriptor x = this.query.getExtraColumn().get(name);
            return x != null;
        }
        return false;
    }

    private FeatureAttributeDescriptor getColumn(String name, FeatureType type) {
        FeatureAttributeDescriptor attr;
        if (type != null && (attr = type.getAttributeDescriptorFromAll(name)) != null) {
            return attr;
        }
        if (this.query != null) {
            EditableFeatureAttributeDescriptor x = this.query.getExtraColumn().get(name);
            return x;
        }
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("NAME: ");
        builder.append(this.getName());
        builder.append("\n");
        builder.append("SEARCH MODE: ");
        builder.append(this.getSearchMode());
        builder.append("\n");
        builder.append("IGNORE AGGREGATE FUNCTIONS: ");
        builder.append(this.getIgnoreAggregateFunctions());
        builder.append("\n");
        boolean first = true;
        for (String string : this.getResultColumnNames()) {
            if (first) {
                builder.append("COLUMNS:\n  ");
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("\"");
            builder.append(string);
            builder.append("\"");
        }
        if (!first) {
            builder.append("\n");
        }
        if (this.query != null) {
            String exp;
            try {
                first = true;
                for (Map.Entry entry : this.getAggregateFunctions().entrySet()) {
                    exp = (String)entry.getKey();
                    String function = (String)entry.getValue();
                    if (first) {
                        builder.append("AGGREGATES:\n");
                        first = false;
                    }
                    builder.append("- ");
                    builder.append(function);
                    builder.append("(");
                    if (this.isColumn(exp, null)) {
                        builder.append("\"");
                        builder.append(exp);
                        builder.append("\"");
                    } else {
                        builder.append(exp);
                    }
                    builder.append(")\n");
                }
            }
            catch (Exception ex) {
                builder.append("ERROR: ");
                builder.append(ex.getMessage());
                builder.append("\n");
            }
            try {
                if (this.query.getExpressionFilter() != null) {
                    builder.append("WHERE:\n  ");
                    builder.append(this.query.getExpressionFilter().getPhrase().replace("\n", " "));
                    builder.append("\n");
                }
            }
            catch (Exception ex) {
                builder.append("ERROR: ");
                builder.append(ex.getMessage());
                builder.append("\n");
            }
            try {
                first = true;
                for (String string : this.query.getGroupByColumns()) {
                    if (first) {
                        builder.append("GROUP BY:\n");
                        first = false;
                    } else {
                        builder.append(", ");
                    }
                    if (this.isColumn(string, null)) {
                        builder.append("\"");
                        builder.append(string);
                        builder.append("\"");
                        continue;
                    }
                    builder.append(string);
                }
                if (!first) {
                    builder.append("\n");
                }
            }
            catch (Exception ex) {
                builder.append("ERROR: ");
                builder.append(ex.getMessage());
                builder.append("\n");
            }
            try {
                first = true;
                for (FeatureQueryOrder.FeatureQueryOrderMember featureQueryOrderMember : this.query.getOrder().members()) {
                    if (first) {
                        builder.append("ORDER BY: ");
                        first = false;
                    } else {
                        builder.append(", ");
                    }
                    builder.append("\"");
                    builder.append(featureQueryOrderMember.getAttributeName());
                    builder.append("\"");
                    if (featureQueryOrderMember.getAscending()) {
                        builder.append(" ASC");
                        continue;
                    }
                    builder.append(" DESC");
                }
                if (!first) {
                    builder.append("\n");
                }
            }
            catch (Exception ex) {
                builder.append("ERROR: ");
                builder.append(ex.getMessage());
                builder.append("\n");
            }
            try {
                first = true;
                for (EditableFeatureAttributeDescriptor editableFeatureAttributeDescriptor : this.query.getExtraColumn().getColumns()) {
                    if (first) {
                        builder.append("USER COLUMNS:\n");
                        first = false;
                    }
                    builder.append("- \"");
                    builder.append(editableFeatureAttributeDescriptor.getName());
                    builder.append("\" ");
                    builder.append(editableFeatureAttributeDescriptor.getDataTypeName());
                    if (editableFeatureAttributeDescriptor.getFeatureAttributeEmulator() instanceof FeatureAttributeEmulatorExpression && (exp = ((FeatureAttributeEmulatorExpression)editableFeatureAttributeDescriptor.getFeatureAttributeEmulator()).getExpression()) != null) {
                        builder.append(" AS ");
                        builder.append(exp.getPhrase().replace("\n", " "));
                    }
                    builder.append("\n");
                }
            }
            catch (Exception ex) {
                builder.append("ERROR: ");
                builder.append(ex.getMessage());
                builder.append("\n");
            }
        }
        try {
            first = true;
            for (Map.Entry<String, JsonObject> entry : this.getValues().entrySet()) {
                String key = entry.getKey();
                JsonObject data = entry.getValue();
                if (first) {
                    builder.append("VALUES:\n");
                    first = false;
                }
                builder.append("- ");
                builder.append(key);
                if (data != null) {
                    builder.append(", ");
                    builder.append(data.toString().replace("\n", " "));
                }
                builder.append("\n");
            }
        }
        catch (Exception ex) {
            builder.append("ERROR: ");
            builder.append(ex.getMessage());
            builder.append("\n");
        }
        return builder.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultSearchParameters clone = (DefaultSearchParameters)super.clone();
        clone.query = this.query.getCopy();
        clone.resultColumnNames = new ArrayList<String>(this.resultColumnNames);
        HashMap<String, JsonObject> cloneValues = new HashMap<String, JsonObject>(this.values);
        clone.values = cloneValues;
        return clone;
    }

    public DefaultSearchParameters getCopy() {
        try {
            return (DefaultSearchParameters)this.clone();
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    public void copyFrom(SearchParameters params) {
        this.resultColumnNames = params.getResultColumnNames();
        this.query = params.getQuery().getCopy();
        this.name = params.getName();
        this.values = params.getValues();
        this.searchMode = params.getSearchMode();
        this.ignoreAggregateFunctions = params.getIgnoreAggregateFunctions();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FeatureType getFeatureType(FeatureStore store) {
        FeatureType featureType;
        FeatureSet fset = null;
        try {
            FeatureType ft;
            fset = store.getFeatureSet(this.query);
            featureType = ft = fset.getDefaultFeatureType();
        }
        catch (DataException ex) {
            FeatureType featureType2;
            try {
                featureType2 = store.getDefaultFeatureTypeQuietly();
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(fset);
                throw throwable;
            }
            DisposeUtils.disposeQuietly((Disposable)fset);
            return featureType2;
        }
        DisposeUtils.disposeQuietly((Disposable)fset);
        return featureType;
    }

    public int getSearchMode() {
        return this.searchMode;
    }

    public void setSearchMode(int searchMode) {
        this.searchMode = searchMode;
    }

    void fix(FeatureType featureType) {
        this.fix(featureType, false);
    }

    void fix(FeatureType featureType, boolean onlyEssentials) {
        if (!onlyEssentials) {
            ArrayList<String> toRemoveAggregateColumns = new ArrayList<String>();
            Map aggregateFunctions = this.query.getAggregateFunctions();
            for (Map.Entry aggregate : aggregateFunctions.entrySet()) {
                String colname = (String)aggregate.getKey();
                String funcname = (String)aggregate.getValue();
                if (this.query.getExtraColumn().get(colname) != null || featureType.get(colname) != null) continue;
                toRemoveAggregateColumns.add(colname);
            }
            for (String toRemoveAggregateColumn : toRemoveAggregateColumns) {
                this.query.removeAggregateFunction(toRemoveAggregateColumn);
            }
            ArrayList<String> fixedAttributeNames = new ArrayList<String>();
            for (String attributeName : this.query.getAttributeNames()) {
                if (featureType.get(attributeName) == null) continue;
                fixedAttributeNames.add(attributeName);
            }
            this.query.setAttributeNames(fixedAttributeNames.toArray(new String[fixedAttributeNames.size()]));
        }
        if (this.query.getLimit() == 0L) {
            this.query.clearLimit();
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean isValid(FeatureType type, StringBuilder errMessage) {
        StringBuilder message = errMessage == null ? new StringBuilder() : errMessage;
        for (String string : this.getResultColumnNames()) {
            if (this.isColumn(string, type)) continue;
            message.append("Column \"");
            message.append(string);
            message.append("\" not defined.\n");
        }
        if (this.query != null) {
            Code code;
            block29: {
                try {
                    for (Map.Entry entry : this.getAggregateFunctions().entrySet()) {
                        String exp3 = (String)entry.getKey();
                        String string = (String)entry.getValue();
                        FeatureAttributeDescriptor attr = this.getColumn(exp3, type);
                        if (attr != null) {
                            if (!StringUtils.equalsIgnoreCase((CharSequence)string, (CharSequence)"SUM") || attr.getDataType().isNumeric()) continue;
                            message.append("Can't SUM not numeric column ");
                            message.append(string);
                            message.append("(");
                            message.append(exp3);
                            message.append(")\n");
                            continue;
                        }
                        Code code2 = null;
                        try {
                            code2 = ExpressionUtils.compile((String)exp3);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (code2 != null) continue;
                        message.append("Invalid expression in aggregate function ");
                        message.append(string);
                        message.append("(");
                        message.append(exp3);
                        message.append(")\n");
                    }
                }
                catch (Exception ex) {
                    message.append("ERROR: ");
                    message.append(ex.getMessage());
                    message.append("\n");
                }
                try {
                    void var5_15;
                    Expression exp2 = this.query.getExpressionFilter();
                    if (exp2 == null) break block29;
                    Object var5_13 = null;
                    try {
                        Code code2 = exp2.getCode();
                        code2.accept(obj -> {
                            String name1 = ((Code.Identifier)obj).name();
                            if (!this.isColumn(name1, type)) {
                                message.append("Column \"");
                                message.append(name1);
                                message.append("\" not defined in filter.\n");
                            }
                        }, t -> t instanceof Code.Identifier);
                    }
                    catch (Throwable exp3) {
                        // empty catch block
                    }
                    if (var5_15 == null) {
                        message.append("Incorrect filter ");
                        message.append(exp2.getPhrase());
                        message.append("\n");
                    }
                }
                catch (Exception ex) {
                    message.append("ERROR: ");
                    message.append(ex.getMessage());
                    message.append("\n");
                }
            }
            try {
                for (String string : this.query.getGroupByColumns()) {
                    if (this.isColumn(string, type)) continue;
                    code = null;
                    try {
                        code = ExpressionUtils.compile((String)string);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (code != null) continue;
                    message.append("Group expression ");
                    message.append(string);
                    message.append(" not valid \n");
                }
            }
            catch (Exception ex) {
                message.append("ERROR: ");
                message.append(ex.getMessage());
                message.append("\n");
            }
            try {
                for (FeatureQueryOrder.FeatureQueryOrderMember featureQueryOrderMember : this.query.getOrder().members()) {
                    if (this.isColumn(featureQueryOrderMember.getAttributeName(), type)) continue;
                    code = null;
                    try {
                        code = ExpressionUtils.compile((String)featureQueryOrderMember.getAttributeName());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (code != null) continue;
                    message.append("Order expression ");
                    message.append(featureQueryOrderMember.getAttributeName());
                    message.append(" not valid \n");
                }
            }
            catch (Exception ex) {
                message.append("ERROR: ");
                message.append(ex.getMessage());
                message.append("\n");
            }
            try {
                for (EditableFeatureAttributeDescriptor editableFeatureAttributeDescriptor : this.query.getExtraColumn().getColumns()) {
                    void var7_35;
                    Expression exp;
                    if (!(editableFeatureAttributeDescriptor.getFeatureAttributeEmulator() instanceof FeatureAttributeEmulatorExpression) || (exp = ((FeatureAttributeEmulatorExpression)editableFeatureAttributeDescriptor.getFeatureAttributeEmulator()).getExpression()) == null) continue;
                    Object var7_33 = null;
                    try {
                        Code code3 = exp.getCode();
                        code3.accept(obj -> {
                            String name1 = ((Code.Identifier)obj).name();
                            if (!this.isColumn(name1, type)) {
                                message.append("\"");
                                message.append(col.getName());
                                message.append("\" refers to the nonexistent column \"");
                                message.append(name1);
                                message.append("\"");
                            }
                        }, t -> t instanceof Code.Identifier);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (var7_35 != null) continue;
                    message.append("Incorrect calculate column \"");
                    message.append(editableFeatureAttributeDescriptor.getName());
                    message.append("\"\n");
                }
            }
            catch (Exception ex) {
                message.append("ERROR: ");
                message.append(ex.getMessage());
                message.append("\n");
            }
            for (Iterator<Object> iterator : this.query.getAttributeNames()) {
                if (type.get(iterator) != null) continue;
                message.append("Incorrect column \"");
                message.append((String)((Object)iterator));
                message.append("\"\n");
            }
        }
        return !StringUtils.isNotBlank((CharSequence)message);
    }

    public void setIgnoreAggregateFunctions(boolean ignore) {
        this.ignoreAggregateFunctions = ignore;
    }

    public boolean getIgnoreAggregateFunctions() {
        return this.ignoreAggregateFunctions;
    }

    public void clear() {
        this.resultColumnNames = new ArrayList<String>();
        if (this.query != null) {
            this.query.clearAttributeNames();
            this.query.clearConstantsAttributeNames();
            this.query.clearFilter();
            this.query.clearLimit();
        }
        this.values = new HashMap<String, JsonObject>();
        this.searchMode = 0;
    }
}

