/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.searchpanel;

import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.fmap.dal.swing.DataSwingManager;
import org.gvsig.fmap.dal.swing.ProjectionPickerController;
import org.gvsig.fmap.dal.swing.impl.searchpanel.SelectGeometryPanelView;
import org.gvsig.fmap.dal.swing.storesrepository.StoresRepositoryController;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.tools.swing.api.Component;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;

public class SelectGeometryPanel
extends SelectGeometryPanelView
implements Component {
    private ProjectionPickerController pickerProjection;
    private StoresRepositoryController storesRepositoryController;

    public SelectGeometryPanel() {
        this.createComponents();
    }

    private void createComponents() {
        this.initComponents();
    }

    private void initComponents() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        this.translate();
        DataSwingManager dataSwingMamager = DALSwingLocator.getDataSwingManager();
        this.pickerProjection = dataSwingMamager.createProjectionPickerController(this.txtProjection, this.btnProjection);
        this.storesRepositoryController = dataSwingMamager.createStoresRepositoryController(this.treeStores);
        this.rdbConstantGeometry.addChangeListener(e -> this.doUpdateEnableComponents());
        this.rdbUseGeomsFromClipbard.addChangeListener(e -> this.doUpdateEnableComponents());
        this.rdbUseGeomsFromLayerSelection.addChangeListener(e -> this.doUpdateEnableComponents());
        this.rdbUseCurrentBoundingBox.addChangeListener(e -> this.doUpdateEnableComponents());
        this.rdbUseGeomsFromClipbard.setSelected(true);
        toolsSwingManager.setDefaultPopupMenu((JTextComponent)this.txtGeometry);
        toolsSwingManager.addClearButton((JTextComponent)this.txtGeometry);
        this.doUpdateEnableComponents();
        ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)24, (int)80, (int)50, (int)100);
    }

    private void translate() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        toolsSwingManager.translate((AbstractButton)this.rdbConstantGeometry);
        toolsSwingManager.translate((AbstractButton)this.rdbUseGeomsFromClipbard);
        toolsSwingManager.translate((AbstractButton)this.rdbUseGeomsFromLayerSelection);
        toolsSwingManager.translate((AbstractButton)this.rdbUseCurrentBoundingBox);
        toolsSwingManager.translate(this.lblProjection);
        toolsSwingManager.translate((AbstractButton)this.chkUseTheGeometryBoundingBox);
    }

    public JComponent asJComponent() {
        return this;
    }

    public int getMode() {
        if (this.rdbUseGeomsFromClipbard.isSelected()) {
            return 1;
        }
        if (this.rdbUseGeomsFromLayerSelection.isSelected()) {
            return 2;
        }
        if (this.rdbUseCurrentBoundingBox.isSelected()) {
            return 4;
        }
        if (this.rdbConstantGeometry.isSelected()) {
            return 3;
        }
        return 1;
    }

    public boolean useBox2dInGeometryOperand() {
        return this.chkUseTheGeometryBoundingBox.isSelected();
    }

    public Geometry getGeometry() {
        String s = this.txtGeometry.getText();
        if (StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        return GeometryUtils.createFrom((String)s, (IProjection)this.getProjection());
    }

    public IProjection getProjection() {
        return (IProjection)this.pickerProjection.get();
    }

    public String getStoreId() {
        String storeId = this.storesRepositoryController.getSelectedStoreId();
        return storeId;
    }

    private void doUpdateEnableComponents() {
        if (this.rdbUseGeomsFromClipbard.isSelected()) {
            this.treeStores.setEnabled(false);
            this.pickerProjection.setEnabled(false);
            this.txtGeometry.setEnabled(false);
            this.chkUseTheGeometryBoundingBox.setEnabled(false);
        } else if (this.rdbUseGeomsFromLayerSelection.isSelected()) {
            this.treeStores.setEnabled(true);
            this.pickerProjection.setEnabled(false);
            this.txtGeometry.setEnabled(false);
            this.chkUseTheGeometryBoundingBox.setEnabled(true);
        } else if (this.rdbUseCurrentBoundingBox.isSelected()) {
            this.treeStores.setEnabled(false);
            this.pickerProjection.setEnabled(false);
            this.txtGeometry.setEnabled(false);
            this.chkUseTheGeometryBoundingBox.setEnabled(false);
        } else if (this.rdbConstantGeometry.isSelected()) {
            this.treeStores.setEnabled(false);
            this.pickerProjection.setEnabled(true);
            this.txtGeometry.setEnabled(true);
            this.chkUseTheGeometryBoundingBox.setEnabled(false);
        }
    }

    void setMode(int mode) {
        switch (mode) {
            case 2: {
                this.rdbUseCurrentBoundingBox.setSelected(false);
                this.rdbUseGeomsFromClipbard.setSelected(false);
                this.rdbUseGeomsFromLayerSelection.setSelected(true);
                this.rdbConstantGeometry.setSelected(false);
                break;
            }
            case 3: {
                this.rdbUseCurrentBoundingBox.setSelected(false);
                this.rdbUseGeomsFromClipbard.setSelected(false);
                this.rdbUseGeomsFromLayerSelection.setSelected(false);
                this.rdbConstantGeometry.setSelected(true);
                break;
            }
            case 4: {
                this.rdbUseCurrentBoundingBox.setSelected(true);
                this.rdbUseGeomsFromClipbard.setSelected(false);
                this.rdbUseGeomsFromLayerSelection.setSelected(false);
                this.rdbConstantGeometry.setSelected(false);
                break;
            }
            default: {
                this.rdbUseCurrentBoundingBox.setSelected(false);
                this.rdbUseGeomsFromClipbard.setSelected(true);
                this.rdbUseGeomsFromLayerSelection.setSelected(false);
                this.rdbConstantGeometry.setSelected(false);
            }
        }
        this.doUpdateEnableComponents();
    }

    void setGeometry(Geometry geometry) {
        if (geometry == null) {
            this.txtGeometry.setText("");
        } else {
            this.txtGeometry.setText(geometry.convertToWKTQuietly());
        }
        this.doUpdateEnableComponents();
    }

    void setStoreId(String storeId) {
        this.storesRepositoryController.setSelectedStore(storeId);
        this.doUpdateEnableComponents();
    }

    void setUseBox2dInGeometryOperand(boolean useBox2d) {
        this.chkUseTheGeometryBoundingBox.setSelected(useBox2d);
        this.doUpdateEnableComponents();
    }
}

