/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.swing.impl.storesrepository;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.StoresRepository;
import org.gvsig.fmap.dal.swing.storesrepository.StoresRepositoryTreeModel;
import org.gvsig.tools.util.LabeledValue;

public class StoresRepositoryTreeModelImpl
implements StoresRepositoryTreeModel {
    private final LabeledValue<StoresRepository> repository;

    public StoresRepositoryTreeModelImpl(StoresRepository repository) {
        this.repository = new StoresRepositoryElementImpl(repository.getLabel(), repository);
    }

    public Object getRoot() {
        return this.repository;
    }

    private List<StoresRepositoryTreeModel.StoresRepositoryElement> getChilds(Object parent0) {
        if (parent0 == null) {
            return null;
        }
        StoresRepositoryElementImpl parent = (StoresRepositoryElementImpl)parent0;
        if (!parent.isRepository()) {
            return null;
        }
        StoresRepository repo = parent.getRepository();
        Set storeNames = repo.keySetShallow();
        ArrayList<StoresRepositoryTreeModel.StoresRepositoryElement> childs = new ArrayList<StoresRepositoryTreeModel.StoresRepositoryElement>();
        for (String storeName : storeNames) {
            StoresRepository subrepo = repo.getSubrepository(storeName);
            if (subrepo != null) {
                childs.add(new StoresRepositoryElementImpl(subrepo.getLabel(), subrepo));
                continue;
            }
            DataStoreParameters storeParams = (DataStoreParameters)repo.get((Object)storeName);
            if (storeParams == null) continue;
            childs.add(new StoresRepositoryElementImpl(repo.getLabelOrName(storeName), storeName, storeParams));
        }
        childs.sort((o1, o2) -> StringUtils.compareIgnoreCase((String)o1.getLabel(), (String)o2.getLabel()));
        return childs;
    }

    public Object getChild(Object parent0, int i) {
        List<StoresRepositoryTreeModel.StoresRepositoryElement> childs = this.getChilds(parent0);
        if (childs == null) {
            return null;
        }
        int index = 0;
        for (StoresRepositoryTreeModel.StoresRepositoryElement child : childs) {
            if (index++ != i) continue;
            return child;
        }
        return null;
    }

    public int getChildCount(Object parent0) {
        if (parent0 == null) {
            return 0;
        }
        StoresRepositoryElementImpl parent = (StoresRepositoryElementImpl)parent0;
        if (!parent.isRepository()) {
            return 0;
        }
        StoresRepository repo = parent.getRepository();
        Set keys = repo.keySetShallow();
        return keys.size();
    }

    public boolean isLeaf(Object o) {
        return ((StoresRepositoryElementImpl)o).isStore();
    }

    public int getIndexOfChild(Object parent0, Object child0) {
        if (child0 == null) {
            return -1;
        }
        StoresRepositoryElementImpl child = (StoresRepositoryElementImpl)child0;
        if (!child.isStore()) {
            return -1;
        }
        List<StoresRepositoryTreeModel.StoresRepositoryElement> childs = this.getChilds(parent0);
        if (childs == null) {
            return -1;
        }
        int index = 0;
        for (StoresRepositoryTreeModel.StoresRepositoryElement currentChild : childs) {
            if (currentChild == child) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public void valueForPathChanged(TreePath tp, Object o) {
    }

    public void addTreeModelListener(TreeModelListener tl) {
    }

    public void removeTreeModelListener(TreeModelListener tl) {
    }

    public static class StoresRepositoryElementImpl
    implements StoresRepositoryTreeModel.StoresRepositoryElement {
        private final StoresRepository repository;
        private final DataStoreParameters params;
        private final String label;
        private final String storeName;

        public StoresRepositoryElementImpl(String label, StoresRepository repository) {
            this.label = label;
            this.repository = repository;
            this.storeName = null;
            this.params = null;
        }

        public StoresRepositoryElementImpl(String label, String storeName, DataStoreParameters params) {
            this.label = label;
            this.storeName = storeName;
            this.params = params;
            this.repository = null;
        }

        public boolean isRepository() {
            return this.repository != null;
        }

        public boolean isStore() {
            return this.storeName != null;
        }

        public String getLabel() {
            return this.label;
        }

        public Object getValue() {
            if (this.repository != null) {
                return this.repository;
            }
            return this.params;
        }

        public DataStoreParameters getStoreParameters() {
            return this.params;
        }

        public String getStoreName() {
            return this.storeName;
        }

        public StoresRepository getRepository() {
            return this.repository;
        }

        public String toString() {
            return this.getLabel();
        }
    }
}

