/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.shp;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataParameters;
import org.gvsig.fmap.dal.DataStoreProvider;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.spi.AbstractFeatureStoreProviderFactory;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.fmap.dal.store.shp.SHPStoreParameters;
import org.gvsig.fmap.dal.store.shp.SHPStoreProvider;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.DataType;
import org.gvsig.tools.dataTypes.DataTypesManager;
import org.gvsig.tools.dynobject.DynObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SHPStoreProviderFactory
extends AbstractFeatureStoreProviderFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SHPStoreProviderFactory.class);
    public static final String DEFAULT_GEOMETRY_FIELD_NAME = "GEOMETRY";
    public static final int DEFAULT_GEOMETRY_TYPE = 22;
    public static final int DEFAULT_GEOMETRY_SUBTYPE = 0;

    protected SHPStoreProviderFactory(String name, String description) {
        super(name, description);
    }

    public DataStoreProvider createProvider(DataParameters parameters, DataStoreProviderServices providerServices) throws InitializeException {
        return new SHPStoreProvider((SHPStoreParameters)parameters, providerServices);
    }

    public DynObject createParameters() {
        return new SHPStoreParameters();
    }

    public int allowCreate() {
        return 1;
    }

    public int allowWrite() {
        return 1;
    }

    public int allowRead() {
        return 1;
    }

    public int hasRasterSupport() {
        return 2;
    }

    public int hasTabularSupport() {
        return 1;
    }

    public int hasVectorialSupport() {
        return 1;
    }

    public int allowMultipleGeometryTypes() {
        return 2;
    }

    public int allowEditableFeatureType() {
        return 1;
    }

    public int useLocalIndexesCanImprovePerformance() {
        return 1;
    }

    public int isOptimalRecoverFeaturesByReference() {
        return 1;
    }

    public List getSupportedDataTypes() {
        DataTypesManager manager = ToolsLocator.getDataTypesManager();
        ArrayList<DataType> resp = new ArrayList<DataType>();
        resp.add(manager.get(8));
        resp.add(manager.get(4));
        resp.add(manager.get(6));
        resp.add(manager.get(9));
        resp.add(manager.get(66));
        return resp;
    }

    public List getSupportedGeometryTypesSubtypes() {
        ArrayList<int[]> supported = new ArrayList<int[]>();
        supported.add(new int[]{1, 0});
        supported.add(new int[]{18, 0});
        supported.add(new int[]{19, 0});
        supported.add(new int[]{1, 2});
        supported.add(new int[]{18, 2});
        supported.add(new int[]{19, 2});
        supported.add(new int[]{1, 3});
        supported.add(new int[]{18, 3});
        supported.add(new int[]{19, 3});
        supported.add(new int[]{7, 0});
        supported.add(new int[]{21, 0});
        supported.add(new int[]{22, 0});
        supported.add(new int[]{7, 2});
        supported.add(new int[]{21, 2});
        supported.add(new int[]{22, 2});
        supported.add(new int[]{7, 3});
        supported.add(new int[]{21, 3});
        supported.add(new int[]{22, 3});
        return supported;
    }

    public boolean allowsMandatoryAttributes() {
        return false;
    }

    public boolean allowsPrimaryKeyAttributes() {
        return false;
    }

    public FeatureType createDefaultFeatureType() {
        DataManager dm = DALLocator.getDataManager();
        EditableFeatureType eft = dm.createFeatureType();
        EditableFeatureAttributeDescriptor efatd = eft.add(DEFAULT_GEOMETRY_FIELD_NAME, 66);
        GeometryType gt = null;
        try {
            gt = GeometryLocator.getGeometryManager().getGeometryType(22, 0);
            efatd.setGeometryType(gt);
        }
        catch (Exception ex) {
            LOGGER.info("Error while setting geom type: " + ex.getMessage());
            LOGGER.info("Trying deprecated way...");
            efatd.setGeometryType(22, 0);
        }
        eft.setDefaultGeometryAttributeName(DEFAULT_GEOMETRY_FIELD_NAME);
        return eft.getNotEditableCopy();
    }

    public int getMaxAttributeNameSize() {
        return 10;
    }

    public boolean supportNumericOID() {
        return true;
    }
}

