/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.shp.utils;

import java.awt.geom.PathIterator;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import org.gvsig.fmap.dal.store.shp.utils.SHPShape;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SHPPoint
implements SHPShape {
    private static final GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private static final Logger logger = LoggerFactory.getLogger(SHPPoint.class);
    private int m_type;
    private Point point;
    private double z;

    public SHPPoint(int type) {
        if (type == 1 || type == 21 || type != 11) {
            // empty if block
        }
        this.m_type = type;
    }

    public SHPPoint() {
        this.m_type = 1;
    }

    @Override
    public int getShapeType() {
        return this.m_type;
    }

    @Override
    public Geometry read(MappedByteBuffer buffer, int type) {
        double x = buffer.getDouble();
        double y = buffer.getDouble();
        double z = Double.NaN;
        if (this.m_type == 21) {
            buffer.getDouble();
        }
        if (this.m_type == 11) {
            z = buffer.getDouble();
            try {
                Point point = geomManager.createPoint(x, y, 1);
                point.setCoordinateAt(2, z);
                return point;
            }
            catch (CreateGeometryException e) {
                logger.error("Error creating a point", (Throwable)e);
            }
        }
        try {
            return geomManager.createPoint(x, y, 0);
        }
        catch (CreateGeometryException e) {
            logger.error("Error creating a point", (Throwable)e);
            return null;
        }
    }

    @Override
    public void write(ByteBuffer buffer, Geometry geometry) {
        buffer.putDouble(this.point.getX());
        buffer.putDouble(this.point.getY());
        if (this.m_type == 11 || this.m_type == 21) {
            if (Double.isNaN(this.z)) {
                buffer.putDouble(0.0);
            } else {
                buffer.putDouble(this.z);
            }
        }
    }

    @Override
    public int getLength(Geometry fgeometry) {
        int length;
        if (this.m_type == 1) {
            length = 20;
        } else if (this.m_type == 21 || this.m_type == 11) {
            length = 28;
        } else {
            throw new IllegalStateException("Expected ShapeType of Point, got" + this.m_type);
        }
        return length;
    }

    @Override
    public void obtainsPoints(Geometry g) {
        if (this.m_type == 21 || this.m_type == 11) {
            this.z = ((Point)g).getCoordinateAt(2);
        }
        PathIterator theIterator = g.getPathIterator(null);
        double[] theData = new double[6];
        while (!theIterator.isDone()) {
            theIterator.currentSegment(theData);
            try {
                this.point = geomManager.createPoint(theData[0], theData[1], 0);
            }
            catch (CreateGeometryException e) {
                logger.error("Error creating a point", (Throwable)e);
            }
            theIterator.next();
        }
    }
}

