/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.principalcomponents.algorithm;

import Jama.Matrix;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.datastruct.NoData;
import org.gvsig.fmap.dal.coverage.exception.CloneException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.ROIException;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.algorithm.process.DataProcess;
import org.gvsig.raster.algorithm.process.ProcessException;
import org.gvsig.raster.principalcomponents.algorithm.PCStatsDataStructure;
import org.gvsig.raster.principalcomponents.algorithm.PrincipalComponentsException;
import org.gvsig.raster.roi.ROI;

public class PrincipalComponentsProcess
extends DataProcess {
    public static String RASTER_STORE = "RASTER_STORE";
    public static String PATH = "PATH";
    public static String FILENAME = "FILENAME";
    public static final String BUFFERS = "BUFFERS";
    public static final String SELECTEDPCS = "SELECTEDPCS";
    public static final String PCSTATISTICS = "PCSTATISTICS";
    public static final String GRAPHIC_DATA = "GRAPHIC_DATA";
    public static final String BANDS = "BANDS";
    private RasterDataStore store = null;
    private String filename = null;
    private PCStatsDataStructure pcStatistics = null;
    private List<ROI> rois = null;
    private Extent extentResult = null;
    private boolean[] selectedPCs = null;
    private boolean[] bands = null;
    private int[] selectedBands = null;
    private NoData nodata = null;

    public static void registerParameters() {
        PrincipalComponentsProcess.registerInputParameter((String)RASTER_STORE, RasterDataStore.class, (String)"PrincipalComponentsProcess");
        PrincipalComponentsProcess.registerInputParameter((String)PCSTATISTICS, PCStatsDataStructure.class, (String)"PrincipalComponentsProcess");
        PrincipalComponentsProcess.registerInputParameter((String)PATH, String.class, (String)"PrincipalComponentsProcess");
        PrincipalComponentsProcess.registerInputParameter((String)SELECTEDPCS, Boolean[].class, (String)"PrincipalComponentsProcess");
        PrincipalComponentsProcess.registerInputParameter((String)BANDS, Boolean[].class, (String)"PrincipalComponentsProcess");
        PrincipalComponentsProcess.registerOutputParameter((String)FILENAME, String.class, (String)"PrincipalComponentsProcess");
        PrincipalComponentsProcess.registerOutputParameter((String)GRAPHIC_DATA, Double[].class, (String)"PrincipalComponentsProcess");
    }

    public void init() {
        this.store = this.getParam(RASTER_STORE) != null ? (RasterDataStore)this.getParam(RASTER_STORE) : null;
        this.filename = this.getStringParam(PATH);
        this.selectedPCs = (boolean[])this.getParam(SELECTEDPCS);
        this.bands = (boolean[])this.getParam(BANDS);
        this.pcStatistics = (PCStatsDataStructure)this.getParam(PCSTATISTICS);
    }

    public void process() throws ProcessInterruptedException, ProcessException {
        this.insertLineLog(Messages.getText((String)"processing_pc"));
        try {
            if (this.store == null) {
                throw new PrincipalComponentsException(Messages.getText((String)"need_a_input"));
            }
            if (this.getROIEPSG() != null) {
                try {
                    this.rois = this.store.getRois(this.getROIEPSG());
                }
                catch (ROIException e2) {
                    this.logger.error(Messages.getText((String)"error_getting_rois"), (Throwable)e2);
                }
            }
            try {
                this.store = this.store.cloneDataStore();
            }
            catch (CloneException e) {
                new PrincipalComponentsException("Error cloning the input DataStore", e);
            }
            this.extentResult = this.getExtentResult(this.getOutputWindow(), this.rois, this.store);
            Rectangle2D sourcePxBBox = this.getSourcePxBox(this.extentResult, this.store);
            double cellSize = this.store.getCellSize();
            this.nodata = RasterLocator.getManager().getDataStructFactory().createDefaultNoData(1, 5);
            double nodataValue = this.nodata.getValue().doubleValue();
            int numberOfOutputBands = this.getNumberOfOutputBands(this.selectedPCs);
            Buffer outputBuffer = this.createOutputBuffer((int)sourcePxBBox.getWidth(), (int)sourcePxBBox.getHeight(), numberOfOutputBands);
            Buffer sourceBuffer = this.createSourceBuffer(this.store, sourcePxBBox, this.bands);
            Matrix autovect = this.changeColumns(this.pcStatistics.getAutoVectorsMatrix().transpose());
            this.insertLineLog(Messages.getText((String)"writting_in_buffer"));
            for (int i = 0; i < sourceBuffer.getHeight(); ++i) {
                for (int j = 0; j < sourceBuffer.getWidth(); ++j) {
                    if (this.isInsideOfROI(j, i, this.rois, this.extentResult)) {
                        for (int iComponent = 0; iComponent < sourceBuffer.getBandCount(); ++iComponent) {
                            if (!this.selectedPCs[iComponent]) continue;
                            double valor = 0.0;
                            for (int iBand = 0; iBand < sourceBuffer.getBandCount(); ++iBand) {
                                valor += this.getData(sourceBuffer, i, j, iBand) * autovect.get(iBand, iComponent);
                            }
                            int indexBandResult = this.indexBandResult(this.selectedPCs, iComponent);
                            outputBuffer.setElem(i, j, indexBandResult, valor);
                        }
                        continue;
                    }
                    for (int iBand = 0; iBand < outputBuffer.getBandCount(); ++iBand) {
                        outputBuffer.setElem(i, j, iBand, nodataValue);
                    }
                }
                this.updatePercent((int)((double)(i * 100) / sourcePxBBox.getHeight()), 100);
            }
            super.exportRaster(this.filename, outputBuffer, cellSize, this.extentResult.getULX(), this.extentResult.getULY(), this.nodata, this.store.getProjection());
            this.addOutputValue(FILENAME, this.filename);
            this.addOutputValue(GRAPHIC_DATA, this.filename);
        }
        catch (PrincipalComponentsException e) {
            if (this.incrementableTask != null) {
                this.incrementableTask.processFinalize();
            }
            this.messageBoxError("principal_components", null, (Exception)((Object)e));
        }
    }

    private int getNumberOfOutputBands(boolean[] b) {
        int bandCount = 0;
        for (int i = 0; i < b.length; ++i) {
            if (!b[i]) continue;
            ++bandCount;
        }
        return bandCount;
    }

    private int indexBandResult(boolean[] bandsPCs, int indexIn) {
        if (this.selectedBands == null) {
            this.selectedBands = new int[bandsPCs.length];
            int indexOut = 0;
            for (int i = 0; i < bandsPCs.length; ++i) {
                this.selectedBands[i] = bandsPCs[i] ? indexOut++ : -1;
            }
        }
        return this.selectedBands[indexIn];
    }

    public double getScaleFactor(Buffer buffer, int sizePreview) {
        double x = 0.0;
        double y = 0.0;
        x = 200.0 / (double)buffer.getWidth();
        if (x > (y = 200.0 / (double)buffer.getHeight())) {
            return y;
        }
        return x;
    }

    private Matrix changeColumns(Matrix m) {
        Matrix result = new Matrix(m.getRowDimension(), m.getColumnDimension());
        int k = m.getColumnDimension() - 1;
        for (int i = 0; i < m.getRowDimension(); ++i) {
            for (int j = 0; j < m.getColumnDimension(); ++j) {
                result.set(i, j, m.get(k - i, j));
            }
        }
        return result;
    }

    public String getTitle() {
        return Messages.getText((String)"...");
    }
}

