/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.metal.MetalButtonUI;
import org.jvnet.substance.PulseTracker;
import org.jvnet.substance.RolloverButtonListener;
import org.jvnet.substance.SubstanceBackgroundDelegate;
import org.jvnet.substance.Utilities;

public class SubstanceButtonUI
extends MetalButtonUI {
    public static final int DEFAULT_WIDTH = 70;
    public static final int DEFAULT_HEIGHT = 20;
    private static final SubstanceButtonUI INSTANCE = new SubstanceButtonUI();
    private SubstanceBackgroundDelegate delegate = new SubstanceBackgroundDelegate();

    public static ComponentUI createUI(JComponent b) {
        return INSTANCE;
    }

    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setBorder(new Border(){

            public Insets getBorderInsets(Component c) {
                if (c instanceof AbstractButton && Utilities.hasText((AbstractButton)c)) {
                    return new Insets(0, 10, 0, 10);
                }
                return new Insets(0, 0, 0, 0);
            }

            public boolean isBorderOpaque() {
                return false;
            }

            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            }
        });
    }

    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new RolloverButtonListener(b);
    }

    public void update(Graphics g, JComponent c) {
        AbstractButton button = (AbstractButton)c;
        long cycle = 0L;
        if (button instanceof JButton) {
            JButton jb = (JButton)button;
            if (jb.isDefaultButton()) {
                PulseTracker.update(jb);
            }
            cycle = PulseTracker.getCycles(jb);
        }
        this.delegate.updateBackground(g, button, cycle);
        this.paint(g, c);
    }

    public Dimension getPreferredSize(JComponent c) {
        Dimension baseDimension;
        boolean toTweakWidth = false;
        boolean toTweakHeight = false;
        AbstractButton button = (AbstractButton)c;
        Icon icon = button.getIcon();
        boolean hasIcon = Utilities.hasIcon(button);
        boolean hasText = Utilities.hasText(button);
        Dimension result = baseDimension = super.getPreferredSize(c);
        if (hasText) {
            int baseWidth = baseDimension.width;
            if (baseWidth < 70) {
                baseWidth = 70;
            }
            result = new Dimension(baseWidth, baseDimension.height);
            int baseHeight = result.height;
            if (baseHeight < 20) {
                baseHeight = 20;
            }
            result = new Dimension(result.width, baseHeight);
        }
        if (hasIcon) {
            int iconWidth;
            int iconHeight = icon.getIconHeight();
            if ((double)iconHeight > result.getHeight() - 6.0) {
                result = new Dimension(result.width, iconHeight);
                toTweakHeight = true;
            }
            if ((double)(iconWidth = icon.getIconWidth()) > result.getWidth() - 6.0) {
                result = new Dimension(iconWidth, result.height);
                toTweakWidth = true;
            }
        }
        if (Utilities.isScrollBarButton(button)) {
            toTweakWidth = false;
            toTweakHeight = false;
        }
        if (toTweakWidth) {
            result = new Dimension(result.width + 6, result.height);
        }
        if (toTweakHeight) {
            result = new Dimension(result.width, result.height + 6);
        }
        return result;
    }

    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
    }

    protected void paintButtonPressed(Graphics g, AbstractButton b) {
    }
}

