/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JSlider;
import javax.swing.plaf.UIResource;
import org.jvnet.substance.ComponentState;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceSliderUI;

public class SubstanceIconFactory {
    private static Icon checkBoxMenuItemIcon;
    private static Icon radioButtonMenuItemIcon;
    private static Icon sliderHorizontalIcon;
    private static Icon sliderVerticalIcon;
    private static final int MENU_CHECK_DIMENSION = 10;
    private static final int SLIDER_WIDTH = 15;
    private static final int SLIDER_HEIGHT = 16;

    static void reset() {
        checkBoxMenuItemIcon = null;
        radioButtonMenuItemIcon = null;
        sliderHorizontalIcon = null;
        sliderVerticalIcon = null;
    }

    public static Icon getCheckBoxMenuItemIcon() {
        if (checkBoxMenuItemIcon == null) {
            checkBoxMenuItemIcon = new CheckBoxMenuItemIcon();
        }
        return checkBoxMenuItemIcon;
    }

    public static Icon getRadioButtonMenuItemIcon() {
        if (radioButtonMenuItemIcon == null) {
            radioButtonMenuItemIcon = new RadioButtonMenuItemIcon();
        }
        return radioButtonMenuItemIcon;
    }

    public static Icon getSliderHorizontalIcon() {
        if (sliderHorizontalIcon == null) {
            sliderHorizontalIcon = new SliderHorizontalIcon();
        }
        return sliderHorizontalIcon;
    }

    public static Icon getSliderVerticalIcon() {
        if (sliderVerticalIcon == null) {
            sliderVerticalIcon = new SliderVerticalIcon();
        }
        return sliderVerticalIcon;
    }

    private static class SliderVerticalIcon
    implements Icon,
    UIResource {
        private Map<ComponentState, Icon> icons = new HashMap<ComponentState, Icon>();

        public SliderVerticalIcon() {
            for (ComponentState state : ComponentState.values()) {
                this.icons.put(state, new ImageIcon(SubstanceImageCreator.getRotated(SubstanceImageCreator.getRoundedTriangleBackground(15, 16, 2, state), 3)));
            }
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (!(g instanceof Graphics2D)) {
                return;
            }
            JSlider slider = (JSlider)c;
            SubstanceSliderUI ui = (SubstanceSliderUI)slider.getUI();
            Icon iconToDraw = this.icons.get((Object)ComponentState.getState(ui.getButtonModel(), null));
            iconToDraw.paintIcon(c, g, x, y);
        }

        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 15;
        }
    }

    private static class SliderHorizontalIcon
    implements Icon,
    UIResource {
        private Map<ComponentState, Icon> icons = new HashMap<ComponentState, Icon>();

        public SliderHorizontalIcon() {
            for (ComponentState state : ComponentState.values()) {
                this.icons.put(state, new ImageIcon(SubstanceImageCreator.getRoundedTriangleBackground(15, 16, 2, state)));
            }
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (!(g instanceof Graphics2D)) {
                return;
            }
            JSlider slider = (JSlider)c;
            SubstanceSliderUI ui = (SubstanceSliderUI)slider.getUI();
            Icon iconToDraw = this.icons.get((Object)ComponentState.getState(ui.getButtonModel(), null));
            iconToDraw.paintIcon(c, g, x, y);
        }

        public int getIconWidth() {
            return 15;
        }

        public int getIconHeight() {
            return 16;
        }
    }

    private static class RadioButtonMenuItemIcon
    implements Icon,
    UIResource {
        private Map<ComponentState, Icon> icons = new HashMap<ComponentState, Icon>();

        public RadioButtonMenuItemIcon() {
            for (ComponentState state : ComponentState.values()) {
                this.icons.put(state, new ImageIcon(SubstanceImageCreator.getRadioButton(10, state, 2)));
            }
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            JMenuItem b = (JMenuItem)c;
            Icon iconToDraw = this.icons.get((Object)ComponentState.getState(b.getModel(), b));
            g.translate(x, y);
            iconToDraw.paintIcon(c, g, 0, 0);
            g.translate(-x, -y);
        }

        public int getIconWidth() {
            return 12;
        }

        public int getIconHeight() {
            return 10;
        }
    }

    private static class CheckBoxMenuItemIcon
    implements Icon,
    UIResource {
        private Map<ComponentState, Icon> icons = new HashMap<ComponentState, Icon>();

        public CheckBoxMenuItemIcon() {
            for (ComponentState state : ComponentState.values()) {
                this.icons.put(state, new ImageIcon(SubstanceImageCreator.getCheckBox(12, state)));
            }
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            JMenuItem b = (JMenuItem)c;
            Icon iconToDraw = this.icons.get((Object)ComponentState.getState(b.getModel(), b));
            g.translate(x, y);
            iconToDraw.paintIcon(c, g, 0, 0);
            g.translate(-x, -y);
        }

        public int getIconWidth() {
            return 12;
        }

        public int getIconHeight() {
            return 12;
        }
    }
}

