/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.plaf.metal.MetalInternalFrameTitlePane;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.Utilities;
import org.jvnet.substance.color.ColorSchemeEnum;

public class SubstanceInternalFrameTitlePane
extends MetalInternalFrameTitlePane {
    private static Icon closeIcon = SubstanceImageCreator.getCloseIcon(ColorSchemeEnum.METALLIC);
    private static Icon minIcon = SubstanceImageCreator.getRestoreIcon(ColorSchemeEnum.METALLIC);
    private static Icon maxIcon = SubstanceImageCreator.getMaximizeIcon(ColorSchemeEnum.METALLIC);
    private static Icon iconIcon = SubstanceImageCreator.getMinimizeIcon(ColorSchemeEnum.METALLIC);

    public SubstanceInternalFrameTitlePane(JInternalFrame f) {
        super(f);
    }

    public void paintComponent(Graphics g) {
        if (this.isPalette) {
            this.paintPalette(g);
            return;
        }
        boolean isSelected = this.frame.isSelected();
        int width = this.getWidth();
        int height = this.getHeight();
        ColorSchemeEnum colorSchemeEnum = isSelected ? SubstanceLookAndFeel.getColorScheme() : ColorSchemeEnum.METALLIC;
        int xOffset = 5;
        Icon icon = this.frame.getFrameIcon();
        if (icon != null) {
            int iconY = height / 2 - icon.getIconHeight() / 2;
            icon.paintIcon(this.frame, g, xOffset, iconY);
            xOffset += icon.getIconWidth() + 5;
        }
        String theTitle = this.frame.getTitle();
        int leftTransitionStart = this.menuBar == null ? 0 : this.menuBar.getWidth() + 10;
        int leftTransitionEnd = this.menuBar == null ? 0 : leftTransitionStart + 20;
        xOffset += leftTransitionEnd;
        int rightTransitionStart = (int)(0.7 * (double)width);
        int rightTransitionEnd = Math.min(rightTransitionStart + 20, (int)(0.8 * (double)width));
        JButton leftmostButton = null;
        if (this.frame.isIconifiable()) {
            leftmostButton = this.iconButton;
        } else if (this.frame.isMaximizable()) {
            leftmostButton = this.maxButton;
        } else if (this.frame.isClosable()) {
            leftmostButton = this.closeButton;
        }
        if (leftmostButton != null) {
            Rectangle rect = leftmostButton.getBounds();
            rightTransitionEnd = rect.getBounds().x - 5;
            rightTransitionStart = Math.max(0 * width, rightTransitionEnd - 20);
        }
        if (theTitle != null) {
            FontMetrics fm = this.frame.getFontMetrics(g.getFont());
            int titleWidth = rightTransitionStart - leftTransitionEnd - 30;
            theTitle = Utilities.clipString(fm, titleWidth, theTitle);
        }
        g.drawImage(SubstanceImageCreator.getGradientCubesImage(this.frame, width, height, colorSchemeEnum, leftTransitionStart, leftTransitionEnd, rightTransitionStart, rightTransitionEnd), 0, 0, null);
        if (theTitle != null) {
            Graphics2D graphics = (Graphics2D)g;
            FontMetrics fm = this.frame.getFontMetrics(g.getFont());
            int yOffset = (height - fm.getHeight()) / 2 + fm.getAscent();
            Object oldAAValue = graphics.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics.setColor(colorSchemeEnum.getColorScheme().getUltraDarkColor());
            graphics.drawString(theTitle, xOffset + 1, yOffset + 1);
            graphics.setColor(colorSchemeEnum.getColorScheme().getUltraLightColor());
            graphics.drawString(theTitle, xOffset, yOffset);
            graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oldAAValue);
        }
    }

    protected void setButtonIcons() {
        super.setButtonIcons();
        if (this.frame.isIcon()) {
            if (minIcon != null) {
                this.iconButton.setIcon(minIcon);
            }
            if (maxIcon != null) {
                this.maxButton.setIcon(maxIcon);
            }
        } else if (this.frame.isMaximum()) {
            if (iconIcon != null) {
                this.iconButton.setIcon(iconIcon);
            }
            if (minIcon != null) {
                this.maxButton.setIcon(minIcon);
            }
        } else {
            if (iconIcon != null) {
                this.iconButton.setIcon(iconIcon);
            }
            if (maxIcon != null) {
                this.maxButton.setIcon(maxIcon);
            }
        }
        if (closeIcon != null) {
            this.closeButton.setIcon(closeIcon);
        }
    }
}

