/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.BasicStroke;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalSliderUI;
import org.jvnet.substance.RolloverControlListener;
import org.jvnet.substance.SubstanceFillBackgroundDelegate;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.Trackable;
import org.jvnet.substance.color.ColorSchemeEnum;

public class SubstanceSliderUI
extends MetalSliderUI
implements Trackable {
    private SubstanceFillBackgroundDelegate bgDelegate = new SubstanceFillBackgroundDelegate();
    private ButtonModel thumbModel = new DefaultButtonModel();

    public static ComponentUI createUI(JComponent c) {
        return new SubstanceSliderUI();
    }

    public SubstanceSliderUI() {
        this.thumbModel.setArmed(false);
        this.thumbModel.setSelected(false);
        this.thumbModel.setPressed(false);
        this.thumbModel.setRollover(false);
    }

    private Rectangle getPaintTrackRect() {
        int trackLeft = 0;
        int trackRight = 0;
        int trackTop = 0;
        int trackBottom = 0;
        if (this.slider.getOrientation() == 0) {
            trackBottom = this.trackRect.height - 1 - this.getThumbOverhang();
            trackTop = trackBottom - (this.getTrackWidth() - 1);
            trackRight = this.trackRect.width - 1;
        } else {
            if (this.slider.getComponentOrientation().isLeftToRight()) {
                trackLeft = this.trackRect.width - this.getThumbOverhang() - this.getTrackWidth();
                trackRight = this.trackRect.width - this.getThumbOverhang() - 1;
            } else {
                trackLeft = this.getThumbOverhang();
                trackRight = this.getThumbOverhang() + this.getTrackWidth() - 1;
            }
            trackBottom = this.trackRect.height - 1;
        }
        return new Rectangle(this.trackRect.x + trackLeft, this.trackRect.y + trackTop, trackRight - trackLeft, trackBottom - trackTop);
    }

    public void paintTrack(Graphics g) {
        Graphics2D graphics = (Graphics2D)g;
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        boolean drawInverted = this.drawInverted();
        Rectangle paintRect = this.getPaintTrackRect();
        graphics.translate(paintRect.x, paintRect.y);
        int width = paintRect.width;
        int height = paintRect.height;
        ColorSchemeEnum borderColorSchemeEnum = this.slider.isEnabled() ? SubstanceLookAndFeel.getColorScheme() : ColorSchemeEnum.METALLIC;
        graphics.setStroke(new BasicStroke(1.1f, 1, 1));
        if (this.slider.getOrientation() == 0) {
            graphics.setPaint(new GradientPaint(0.0f, 0.0f, borderColorSchemeEnum.getColorScheme().getDarkColor(), 0.0f, height - 1, borderColorSchemeEnum.getColorScheme().getUltraDarkColor()));
            graphics.drawRoundRect(0, 0, width, height, height, height);
        } else {
            graphics.setPaint(new GradientPaint(0.0f, 0.0f, borderColorSchemeEnum.getColorScheme().getDarkColor(), width - 1, 0.0f, borderColorSchemeEnum.getColorScheme().getUltraDarkColor()));
            graphics.drawRoundRect(0, 0, width, height, width, width);
        }
        if (this.slider.isEnabled()) {
            if (this.slider.getOrientation() == 0) {
                int fillMaxX;
                int fillMinX;
                int middleOfThumb = this.thumbRect.x + this.thumbRect.width / 2 - paintRect.x;
                graphics.setPaint(new GradientPaint(0.0f, 1.0f, SubstanceLookAndFeel.getColorScheme().getColorScheme().getUltraLightColor(), 0.0f, height - 1, SubstanceLookAndFeel.getColorScheme().getColorScheme().getLightColor()));
                if (drawInverted) {
                    fillMinX = middleOfThumb;
                    fillMaxX = width - 2;
                } else {
                    fillMinX = 1;
                    fillMaxX = middleOfThumb;
                }
                graphics.fillRoundRect(fillMinX, 1, fillMaxX - fillMinX + 2, height - 1, height - 2, height - 2);
            } else {
                int fillMaxY;
                int fillMinY;
                int middleOfThumb = this.thumbRect.y + this.thumbRect.height / 2 - paintRect.y;
                graphics.setPaint(new GradientPaint(1.0f, 0.0f, SubstanceLookAndFeel.getColorScheme().getColorScheme().getUltraLightColor(), width - 1, 0.0f, SubstanceLookAndFeel.getColorScheme().getColorScheme().getLightColor()));
                if (this.drawInverted()) {
                    fillMinY = 1;
                    fillMaxY = middleOfThumb;
                } else {
                    fillMinY = middleOfThumb;
                    fillMaxY = height - 2;
                }
                graphics.fillRoundRect(1, fillMinY, width - 1, fillMaxY - fillMinY + 2, width - 2, width - 2);
            }
        }
        g.translate(-paintRect.x, -paintRect.y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void paint(Graphics g, JComponent c) {
        JComponent jComponent = c;
        synchronized (jComponent) {
            this.bgDelegate.update(g, c);
            boolean isOpaque = c.isOpaque();
            c.setOpaque(false);
            super.paint(g, c);
            c.setOpaque(isOpaque);
        }
    }

    public ButtonModel getButtonModel() {
        return this.thumbModel;
    }

    public boolean isInside(MouseEvent me) {
        Rectangle thumbB = this.thumbRect;
        if (thumbB == null) {
            return false;
        }
        return thumbB.contains(me.getX(), me.getY());
    }

    protected void installListeners(JSlider slider) {
        super.installListeners(slider);
        RolloverControlListener listener = new RolloverControlListener(this, this.thumbModel);
        slider.addMouseListener(listener);
        slider.addMouseMotionListener(listener);
    }
}

