/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import org.jvnet.substance.SubstanceComboBoxUI;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.SubstanceRootPaneUI;
import org.jvnet.substance.Utilities;
import org.jvnet.substance.color.ColorSchemeEnum;

public class SubstanceTitlePane
extends JComponent {
    private PropertyChangeListener propertyChangeListener;
    private JMenuBar menuBar;
    private Action closeAction;
    private Action iconifyAction;
    private Action restoreAction;
    private Action maximizeAction;
    private JButton toggleButton;
    private JButton minimizeButton;
    private JButton closeButton;
    private Icon maximizeIcon;
    private Icon restoreSizeIcon;
    private WindowListener windowListener;
    private Window window;
    private JRootPane rootPane;
    private int state;
    private SubstanceRootPaneUI rootPaneUI;

    public SubstanceTitlePane(JRootPane root, SubstanceRootPaneUI ui) {
        this.rootPane = root;
        this.rootPaneUI = ui;
        this.state = -1;
        this.installSubcomponents();
        this.setLayout(this.createLayout());
    }

    private void uninstall() {
        this.uninstallListeners();
        this.window = null;
        this.removeAll();
    }

    private void installListeners() {
        if (this.window != null) {
            this.windowListener = new WindowHandler();
            this.window.addWindowListener(this.windowListener);
            this.propertyChangeListener = new PropertyChangeHandler();
            this.window.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    private void uninstallListeners() {
        if (this.window != null) {
            this.window.removeWindowListener(this.windowListener);
            this.window.removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    public JRootPane getRootPane() {
        return this.rootPane;
    }

    private int getWindowDecorationStyle() {
        return this.getRootPane().getWindowDecorationStyle();
    }

    public void addNotify() {
        super.addNotify();
        this.uninstallListeners();
        this.window = SwingUtilities.getWindowAncestor(this);
        if (this.window != null) {
            if (this.window instanceof Frame) {
                this.setState(((Frame)this.window).getExtendedState());
            } else {
                this.setState(0);
            }
            this.setActive(this.window.isActive());
            this.installListeners();
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this.uninstallListeners();
        this.window = null;
    }

    private void installSubcomponents() {
        int decorationStyle = this.getWindowDecorationStyle();
        if (decorationStyle == 1) {
            this.createActions();
            this.menuBar = this.createMenuBar();
            this.add(this.menuBar);
            this.createButtons();
            this.add(this.minimizeButton);
            this.add(this.toggleButton);
            this.add(this.closeButton);
        } else if (decorationStyle == 2 || decorationStyle == 3 || decorationStyle == 4 || decorationStyle == 5 || decorationStyle == 6 || decorationStyle == 7 || decorationStyle == 8) {
            this.createActions();
            this.createButtons();
            this.add(this.closeButton);
        }
    }

    protected JMenuBar createMenuBar() {
        this.menuBar = new SubstanceMenuBar();
        this.menuBar.setFocusable(false);
        this.menuBar.setBorderPainted(true);
        this.menuBar.add(this.createMenu());
        return this.menuBar;
    }

    private void createActions() {
        this.closeAction = new CloseAction();
        if (this.getWindowDecorationStyle() == 1) {
            this.iconifyAction = new IconifyAction();
            this.restoreAction = new RestoreAction();
            this.maximizeAction = new MaximizeAction();
        }
    }

    private JMenu createMenu() {
        JMenu menu = new JMenu("");
        if (this.getWindowDecorationStyle() == 1) {
            this.addMenuItems(menu);
        }
        return menu;
    }

    private void addMenuItems(JMenu menu) {
        Locale locale = this.getRootPane().getLocale();
        JMenuItem mi = menu.add(this.restoreAction);
        mi = menu.add(this.iconifyAction);
        if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
            mi = menu.add(this.maximizeAction);
        }
        menu.add(new JSeparator());
        mi = menu.add(this.closeAction);
    }

    private JButton createTitleButton() {
        JButton button = new JButton();
        button.setFocusPainted(false);
        button.setFocusable(false);
        button.setOpaque(true);
        return button;
    }

    private void createButtons() {
        this.closeButton = this.createTitleButton();
        this.closeButton.setAction(this.closeAction);
        this.closeButton.setText(null);
        this.closeButton.putClientProperty("paintActive", Boolean.TRUE);
        this.closeButton.setBorder(null);
        this.closeButton.setToolTipText("Close");
        this.closeButton.setIcon(SubstanceImageCreator.getCloseIcon(ColorSchemeEnum.METALLIC));
        if (this.getWindowDecorationStyle() == 1) {
            this.maximizeIcon = SubstanceImageCreator.getMaximizeIcon(ColorSchemeEnum.METALLIC);
            this.restoreSizeIcon = SubstanceImageCreator.getRestoreIcon(ColorSchemeEnum.METALLIC);
            this.minimizeButton = this.createTitleButton();
            this.minimizeButton.setAction(this.iconifyAction);
            this.minimizeButton.setText(null);
            this.minimizeButton.putClientProperty("paintActive", Boolean.TRUE);
            this.minimizeButton.setBorder(null);
            this.minimizeButton.setToolTipText("Minimize");
            this.minimizeButton.setIcon(SubstanceImageCreator.getMinimizeIcon(ColorSchemeEnum.METALLIC));
            this.toggleButton = this.createTitleButton();
            this.toggleButton.setAction(this.restoreAction);
            this.toggleButton.putClientProperty("paintActive", Boolean.TRUE);
            this.toggleButton.setBorder(null);
            this.toggleButton.setToolTipText("Maximize");
            this.toggleButton.setIcon(this.maximizeIcon);
        }
    }

    private LayoutManager createLayout() {
        return new TitlePaneLayout();
    }

    private void setActive(boolean isActive) {
        Boolean activeB;
        Boolean bl = activeB = isActive ? Boolean.TRUE : Boolean.FALSE;
        if (this.getWindowDecorationStyle() == 1) {
            this.closeButton.putClientProperty("paintActive", activeB);
            this.minimizeButton.putClientProperty("paintActive", activeB);
            this.toggleButton.putClientProperty("paintActive", activeB);
        }
        this.getRootPane().repaint();
    }

    private void setState(int state) {
        this.setState(state, false);
    }

    private void setState(int state, boolean updateRegardless) {
        Window w = this.getWindow();
        if (w != null && this.getWindowDecorationStyle() == 1) {
            if (this.state == state && !updateRegardless) {
                return;
            }
            Frame frame = this.getFrame();
            if (frame != null) {
                JRootPane rootPane = this.getRootPane();
                if ((state & 6) != 0 && (rootPane.getBorder() == null || rootPane.getBorder() instanceof UIResource) && frame.isShowing()) {
                    rootPane.setBorder(null);
                } else if ((state & 6) == 0) {
                    this.rootPaneUI.installBorder(rootPane);
                }
                if (frame.isResizable()) {
                    if ((state & 6) != 0) {
                        this.updateToggleButton(this.restoreAction, this.restoreSizeIcon);
                        this.toggleButton.setToolTipText("Restore");
                        this.maximizeAction.setEnabled(false);
                        this.restoreAction.setEnabled(true);
                    } else {
                        this.updateToggleButton(this.maximizeAction, this.maximizeIcon);
                        this.toggleButton.setToolTipText("Maximize");
                        this.maximizeAction.setEnabled(true);
                        this.restoreAction.setEnabled(false);
                    }
                    if (this.toggleButton.getParent() == null || this.minimizeButton.getParent() == null) {
                        this.add(this.toggleButton);
                        this.add(this.minimizeButton);
                        this.revalidate();
                        this.repaint();
                    }
                    this.toggleButton.setText(null);
                } else {
                    this.maximizeAction.setEnabled(false);
                    this.restoreAction.setEnabled(false);
                    if (this.toggleButton.getParent() != null) {
                        this.remove(this.toggleButton);
                        this.revalidate();
                        this.repaint();
                    }
                }
            } else {
                this.maximizeAction.setEnabled(false);
                this.restoreAction.setEnabled(false);
                this.iconifyAction.setEnabled(false);
                this.remove(this.toggleButton);
                this.remove(this.minimizeButton);
                this.revalidate();
                this.repaint();
            }
            this.closeAction.setEnabled(true);
            this.state = state;
        }
    }

    private void updateToggleButton(Action action, Icon icon) {
        this.toggleButton.setAction(action);
        this.toggleButton.setIcon(icon);
        this.toggleButton.setText(null);
    }

    private Frame getFrame() {
        Window window = this.getWindow();
        if (window instanceof Frame) {
            return (Frame)window;
        }
        return null;
    }

    private Window getWindow() {
        return this.window;
    }

    private String getTitle() {
        Window w = this.getWindow();
        if (w instanceof Frame) {
            return ((Frame)w).getTitle();
        }
        if (w instanceof Dialog) {
            return ((Dialog)w).getTitle();
        }
        return null;
    }

    public void paintComponent(Graphics g) {
        if (this.getFrame() != null) {
            this.setState(this.getFrame().getExtendedState());
        }
        JRootPane rootPane = this.getRootPane();
        Window window = this.getWindow();
        boolean isSelected = window == null ? true : window.isActive();
        int width = this.getWidth();
        int height = this.getHeight();
        ColorSchemeEnum colorSchemeEnum = isSelected ? SubstanceLookAndFeel.getColorScheme() : ColorSchemeEnum.METALLIC;
        int xOffset = 5;
        String theTitle = this.getTitle();
        int leftTransitionStart = this.menuBar == null ? 0 : this.menuBar.getWidth() + 10;
        int leftTransitionEnd = this.menuBar == null ? 0 : leftTransitionStart + 20;
        xOffset += leftTransitionEnd;
        int rightTransitionStart = (int)(0.7 * (double)width);
        int rightTransitionEnd = Math.min(rightTransitionStart + 20, (int)(0.8 * (double)width));
        Component leftmostButton = null;
        Frame frame = this.getFrame();
        if (this.minimizeButton != null && this.minimizeButton.getParent() != null && this.minimizeButton.getBounds().width != 0) {
            leftmostButton = this.minimizeButton;
        } else if (this.toggleButton != null && this.toggleButton.getParent() != null && this.toggleButton.getBounds().width != 0) {
            leftmostButton = this.toggleButton;
        } else if (this.closeButton != null && this.closeButton.getParent() != null) {
            leftmostButton = this.closeButton;
        }
        if (leftmostButton != null) {
            Rectangle rect = leftmostButton.getBounds();
            rightTransitionEnd = rect.getBounds().x - 5;
            rightTransitionStart = Math.max(0 * width, rightTransitionEnd - 20);
        }
        if (theTitle != null) {
            FontMetrics fm = rootPane.getFontMetrics(g.getFont());
            int titleWidth = rightTransitionStart - leftTransitionEnd - 30;
            theTitle = Utilities.clipString(fm, titleWidth, theTitle);
        }
        g.drawImage(SubstanceImageCreator.getGradientCubesImage(rootPane, width, height, colorSchemeEnum, leftTransitionStart, leftTransitionEnd, rightTransitionStart, rightTransitionEnd), 0, 0, null);
        if (theTitle != null) {
            Graphics2D graphics = (Graphics2D)g;
            FontMetrics fm = rootPane.getFontMetrics(g.getFont());
            int yOffset = (height - fm.getHeight()) / 2 + fm.getAscent();
            Object oldAAValue = graphics.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics.setColor(colorSchemeEnum.getColorScheme().getUltraDarkColor());
            graphics.drawString(theTitle, xOffset + 1, yOffset + 1);
            graphics.setColor(colorSchemeEnum.getColorScheme().getUltraLightColor());
            graphics.drawString(theTitle, xOffset, yOffset);
            graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, oldAAValue);
        }
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        public void windowActivated(WindowEvent ev) {
            SubstanceTitlePane.this.setActive(true);
        }

        public void windowDeactivated(WindowEvent ev) {
            SubstanceTitlePane.this.setActive(false);
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent pce) {
            String name = pce.getPropertyName();
            if ("resizable".equals(name) || "state".equals(name)) {
                Frame frame = SubstanceTitlePane.this.getFrame();
                if (frame != null) {
                    SubstanceTitlePane.this.setState(frame.getExtendedState(), true);
                }
                if ("resizable".equals(name)) {
                    SubstanceTitlePane.this.getRootPane().repaint();
                }
            } else if ("title".equals(name)) {
                SubstanceTitlePane.this.repaint();
            } else if ("componentOrientation".equals(name) || "iconImage".equals(name)) {
                SubstanceTitlePane.this.revalidate();
                SubstanceTitlePane.this.repaint();
            }
        }
    }

    private class TitlePaneLayout
    implements LayoutManager {
        private TitlePaneLayout() {
        }

        public void addLayoutComponent(String name, Component c) {
        }

        public void removeLayoutComponent(Component c) {
        }

        public Dimension preferredLayoutSize(Container c) {
            int height = this.computeHeight();
            return new Dimension(height, height);
        }

        private int computeHeight() {
            FontMetrics fm = SubstanceTitlePane.this.rootPane.getFontMetrics(SubstanceTitlePane.this.getFont());
            int fontHeight = fm.getHeight();
            fontHeight += 7;
            int iconHeight = 0;
            if (SubstanceTitlePane.this.getWindowDecorationStyle() == 1) {
                iconHeight = 16;
            }
            int finalHeight = Math.max(fontHeight, iconHeight);
            return finalHeight;
        }

        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        public void layoutContainer(Container c) {
            int spacing;
            int buttonWidth;
            int buttonHeight;
            int w = SubstanceTitlePane.this.getWidth();
            int y = 3;
            if (SubstanceTitlePane.this.closeButton != null && SubstanceTitlePane.this.closeButton.getIcon() != null) {
                buttonHeight = SubstanceTitlePane.this.closeButton.getIcon().getIconHeight();
                buttonWidth = SubstanceTitlePane.this.closeButton.getIcon().getIconWidth();
            } else {
                buttonHeight = 16;
                buttonWidth = 16;
            }
            int x = spacing = 5;
            if (SubstanceTitlePane.this.menuBar != null) {
                SubstanceTitlePane.this.menuBar.setBounds(x, y, buttonWidth, buttonHeight);
            }
            x = w;
            spacing = 4;
            x -= spacing + buttonWidth;
            if (SubstanceTitlePane.this.closeButton != null) {
                SubstanceTitlePane.this.closeButton.setBounds(x, y, buttonWidth, buttonHeight);
            }
            if (SubstanceTitlePane.this.getWindowDecorationStyle() == 1) {
                if (Toolkit.getDefaultToolkit().isFrameStateSupported(6) && SubstanceTitlePane.this.toggleButton.getParent() != null) {
                    spacing = 10;
                    SubstanceTitlePane.this.toggleButton.setBounds(x -= spacing + buttonWidth, y, buttonWidth, buttonHeight);
                }
                if (SubstanceTitlePane.this.minimizeButton != null && SubstanceTitlePane.this.minimizeButton.getParent() != null) {
                    spacing = 2;
                    SubstanceTitlePane.this.minimizeButton.setBounds(x -= spacing + buttonWidth, y, buttonWidth, buttonHeight);
                }
            }
        }
    }

    private class SubstanceMenuBar
    extends JMenuBar {
        private JButton activatorButton = new JButton();
        private Rectangle activatorRectangle;

        public SubstanceMenuBar() {
            this.activatorButton.setFocusPainted(false);
            this.activatorButton.setFocusable(false);
            this.activatorButton.setOpaque(true);
            this.activatorButton.setIcon(SubstanceComboBoxUI.COMBO_ARROW);
            this.activatorButton.setPreferredSize(new Dimension(16, 16));
            this.activatorButton.setSize(this.activatorButton.getPreferredSize());
            this.activatorRectangle = new Rectangle(this.activatorButton.getSize());
        }

        public void paint(Graphics g) {
            this.activatorButton.getUI().update(g, this.activatorButton);
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            return new Dimension(Math.max(this.activatorButton.getWidth(), size.width), Math.max(size.height, this.activatorButton.getHeight()));
        }
    }

    private class MaximizeAction
    extends AbstractAction {
        public MaximizeAction() {
            super(UIManager.getString((Object)"MetalTitlePane.maximizeTitle", SubstanceTitlePane.this.getLocale()));
        }

        public void actionPerformed(ActionEvent e) {
            Frame frame = SubstanceTitlePane.this.getFrame();
            if (frame != null) {
                frame.setExtendedState(SubstanceTitlePane.this.state | 6);
            }
        }
    }

    private class RestoreAction
    extends AbstractAction {
        public RestoreAction() {
            super(UIManager.getString((Object)"MetalTitlePane.restoreTitle", SubstanceTitlePane.this.getLocale()));
        }

        public void actionPerformed(ActionEvent e) {
            Frame frame = SubstanceTitlePane.this.getFrame();
            if (frame == null) {
                return;
            }
            if ((SubstanceTitlePane.this.state & 1) != 0) {
                frame.setExtendedState(SubstanceTitlePane.this.state & 0xFFFFFFFE);
            } else {
                frame.setExtendedState(SubstanceTitlePane.this.state & 0xFFFFFFF9);
            }
        }
    }

    private class IconifyAction
    extends AbstractAction {
        public IconifyAction() {
            super(UIManager.getString((Object)"MetalTitlePane.iconifyTitle", SubstanceTitlePane.this.getLocale()));
        }

        public void actionPerformed(ActionEvent e) {
            Frame frame = SubstanceTitlePane.this.getFrame();
            if (frame != null) {
                frame.setExtendedState(SubstanceTitlePane.this.state | 1);
            }
        }
    }

    private class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(UIManager.getString((Object)"MetalTitlePane.closeTitle", SubstanceTitlePane.this.getLocale()));
        }

        public void actionPerformed(ActionEvent e) {
            Window window = SubstanceTitlePane.this.getWindow();
            if (window != null) {
                window.dispatchEvent(new WindowEvent(window, 201));
            }
        }
    }
}

