/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sldsupport.impl.sld.parsing;

import java.io.IOException;
import java.util.HashMap;
import org.gvsig.sldsupport.exception.InvalidSLDObjectException;
import org.gvsig.sldsupport.exception.SLDReadException;
import org.gvsig.sldsupport.exception.UnsupportedSLDObjectException;
import org.gvsig.sldsupport.impl.filter.DefaultSLDFilter;
import org.gvsig.sldsupport.impl.sld.parsing.filteroperator.FilterOperatorElement;
import org.gvsig.sldsupport.impl.util.SLDUtils;
import org.gvsig.sldsupport.impl.util.XmlBuilder;
import org.gvsig.sldsupport.sld.filter.SLDFilter;
import org.gvsig.sldsupport.sld.filter.SLDFilterOperator;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class FilterElement {
    public static void append(SLDFilter obj, XmlBuilder xb, String version) throws InvalidSLDObjectException, UnsupportedSLDObjectException {
        if (obj.isElse()) {
            xb.writeTag("ElseFilter", new HashMap());
            return;
        }
        xb.openTag("Filter");
        SLDFilterOperator op = obj.getFilterOperator();
        if (op == null) {
            throw new InvalidSLDObjectException("Filter", "No filter operator found.");
        }
        FilterOperatorElement.append(op, xb, version);
        xb.closeTag();
    }

    public static SLDFilter parse(XmlPullParser parser, String version) throws XmlPullParserException, IOException, SLDReadException {
        String name = parser.getName();
        int tag = 0;
        DefaultSLDFilter resp = null;
        if (SLDUtils.isStr(name, "ElseFilter")) {
            resp = new DefaultSLDFilter();
            resp.setIsElse(true);
            while (!SLDUtils.isStr(name, "ElseFilter") || tag != 3) {
                tag = parser.next();
                name = parser.getName();
            }
            parser.require(3, null, "ElseFilter");
            parser.nextTag();
            return resp;
        }
        parser.require(2, null, "Filter");
        resp = new DefaultSLDFilter();
        resp.setIsElse(false);
        parser.nextTag();
        SLDFilterOperator operator = FilterOperatorElement.parse(parser, version);
        resp.setFilterOperator(operator);
        parser.require(3, null, "Filter");
        parser.nextTag();
        return resp;
    }
}

