/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sldsupport.impl.sld.parsing;

import java.io.IOException;
import java.util.HashMap;
import org.gvsig.sldsupport.exception.InvalidSLDObjectException;
import org.gvsig.sldsupport.exception.SLDReadException;
import org.gvsig.sldsupport.exception.UnsupportedSLDObjectException;
import org.gvsig.sldsupport.impl.util.SLDUtils;
import org.gvsig.sldsupport.impl.util.XmlBuilder;
import org.gvsig.sldsupport.sld.ows.SLDRemoteOWS;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class RemoteOWSElement {
    public static void append(SLDRemoteOWS obj, XmlBuilder xb, String version) throws InvalidSLDObjectException, UnsupportedSLDObjectException {
        xb.openTag("RemoteOWS");
        if (obj.getService() == null) {
            throw new InvalidSLDObjectException("RemoteOWS", "No service (WFS/WCS) found");
        }
        xb.writeTag("Service", obj.getService());
        if (obj.getOnlineResource() == null) {
            throw new InvalidSLDObjectException("RemoteOWS", "No online resource URL found");
        }
        HashMap<String, String> atts = new HashMap<String, String>();
        atts.put("xlink:href", obj.getOnlineResource());
        xb.writeTag("OnlineResource", atts);
        xb.closeTag();
    }

    public static SLDRemoteOWS parse(XmlPullParser parser, String version) throws XmlPullParserException, IOException, SLDReadException {
        parser.require(2, null, "RemoteOWS");
        int tag = 0;
        SLDRemoteOWS resp = new SLDRemoteOWS();
        tag = parser.nextTag();
        String name = parser.getName();
        String txt = null;
        while (!SLDUtils.isStr(name, "RemoteOWS") || tag != 3) {
            switch (tag) {
                case 2: {
                    if (SLDUtils.isStr(name, "Service")) {
                        txt = parser.nextText();
                        resp.setService(txt);
                        parser.nextTag();
                        break;
                    }
                    if (SLDUtils.isStr(name, "OnlineResource")) {
                        txt = parser.getAttributeValue(null, "xlink:href");
                        if (txt == null) {
                            throw new SLDReadException("URL not found (xlink:href att is missing) in online resource entity");
                        }
                        resp.setOnlineResource(txt);
                        parser.nextTag();
                        parser.nextTag();
                        break;
                    }
                    throw new SLDReadException("Unexpected entity in Remote OWS element: " + name);
                }
                case 3: {
                    break;
                }
            }
            tag = parser.getEventType();
            name = parser.getName();
        }
        parser.nextTag();
        return resp;
    }
}

