/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sldsupport.impl.sld.parsing;

import java.io.IOException;
import java.util.List;
import org.gvsig.sldsupport.exception.InvalidSLDObjectException;
import org.gvsig.sldsupport.exception.SLDReadException;
import org.gvsig.sldsupport.exception.UnsupportedSLDObjectException;
import org.gvsig.sldsupport.impl.sld.parsing.FilterElement;
import org.gvsig.sldsupport.impl.sld.parsing.LegendGraphicElement;
import org.gvsig.sldsupport.impl.sld.parsing.symbol.SymbolElement;
import org.gvsig.sldsupport.impl.util.SLDUtils;
import org.gvsig.sldsupport.impl.util.XmlBuilder;
import org.gvsig.sldsupport.sld.filter.SLDFilter;
import org.gvsig.sldsupport.sld.graphic.SLDLegendGraphic;
import org.gvsig.sldsupport.sld.rule.SLDRule;
import org.gvsig.sldsupport.sld.symbol.SLDSymbol;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class RuleElement {
    public static void append(SLDRule obj, XmlBuilder xb, String version) throws InvalidSLDObjectException, UnsupportedSLDObjectException {
        List syms;
        xb.openTag("Rule");
        if (obj.getName() != null) {
            xb.writeTag("Name", obj.getName());
        }
        if (version != null && version.compareToIgnoreCase("1.1.0") == 0) {
            if (obj.getDescription() != null) {
                xb.writeTag("Description", obj.getDescription());
            }
        } else {
            if (obj.getTitle() != null) {
                xb.writeTag("Title", obj.getTitle());
            }
            if (obj.getDescription() != null) {
                xb.writeTag("Abstract", obj.getDescription());
            }
        }
        if (obj.getLegendGraphic() != null) {
            LegendGraphicElement.append(obj.getLegendGraphic(), xb, version);
        }
        if (obj.getFilter() != null) {
            FilterElement.append(obj.getFilter(), xb, version);
        }
        if (obj.getMinScaleDenominator() != -1.0) {
            xb.writeTag("MinScaleDenominator", SLDUtils.df.format(obj.getMinScaleDenominator()));
        }
        if (obj.getMaxScaleDenominator() != -1.0) {
            xb.writeTag("MaxScaleDenominator", SLDUtils.df.format(obj.getMaxScaleDenominator()));
        }
        if ((syms = obj.getSymbols()) == null || syms.size() == 0) {
            throw new InvalidSLDObjectException("Rule", "Symbol list is empty");
        }
        for (int i = 0; i < syms.size(); ++i) {
            SymbolElement.append((SLDSymbol)syms.get(i), xb, null);
        }
        xb.closeTag();
    }

    public static SLDRule parse(XmlPullParser parser, String version) throws XmlPullParserException, IOException, SLDReadException {
        parser.require(2, null, "Rule");
        int tag = 0;
        SLDRule resp = new SLDRule();
        tag = parser.nextTag();
        String name = parser.getName();
        String txt = null;
        while (!SLDUtils.isStr(name, "Rule") || tag != 3) {
            switch (tag) {
                case 2: {
                    if (SLDUtils.isStr(name, "Name")) {
                        txt = parser.nextText();
                        resp.setName(txt);
                        parser.nextTag();
                        break;
                    }
                    if (SLDUtils.isStr(name, "Title")) {
                        txt = parser.nextText();
                        resp.setTitle(txt);
                        parser.nextTag();
                        break;
                    }
                    if (SLDUtils.isStr(name, "Abstract") || SLDUtils.isStr(name, "Description")) {
                        txt = parser.nextText();
                        resp.setDescription(txt);
                        parser.nextTag();
                        break;
                    }
                    if (SLDUtils.isStr(name, "LegendGraphic")) {
                        SLDLegendGraphic legr = LegendGraphicElement.parse(parser, version);
                        resp.setLegendGraphic(legr);
                        break;
                    }
                    if (SLDUtils.isStr(name, "Filter") || SLDUtils.isStr(name, "ElseFilter")) {
                        SLDFilter filt = FilterElement.parse(parser, version);
                        resp.setFilter(filt);
                        break;
                    }
                    if (SLDUtils.isStr(name, "MinScaleDenominator")) {
                        txt = parser.nextText();
                        resp.setMinScaleDenominator(SLDUtils.parseDouble(txt));
                        parser.nextTag();
                        break;
                    }
                    if (SLDUtils.isStr(name, "MaxScaleDenominator")) {
                        txt = parser.nextText();
                        resp.setMaxScaleDenominator(SLDUtils.parseDouble(txt));
                        parser.nextTag();
                        break;
                    }
                    if (SLDUtils.isStr(name, "PointSymbol") || SLDUtils.isStr(name, "PointSymbolizer") || SLDUtils.isStr(name, "LineSymbol") || SLDUtils.isStr(name, "LineSymbolizer") || SLDUtils.isStr(name, "PolygonSymbol") || SLDUtils.isStr(name, "PolygonSymbolizer")) {
                        SLDSymbol sym = SymbolElement.parse(parser, version);
                        resp.getSymbols().add(sym);
                        break;
                    }
                    if (SLDUtils.isStr(name, "TextSymbol") || SLDUtils.isStr(name, "TextSymbolizer") || SLDUtils.isStr(name, "RasterSymbol") || SLDUtils.isStr(name, "RasterSymbolizer") || SLDUtils.isStr(name, "MappedColorSymbol")) {
                        throw new SLDReadException("Unsupported symbol: " + name);
                    }
                    throw new SLDReadException("Bad SLD file. Unexpected entity in Rule: " + name);
                }
                case 3: {
                    break;
                }
            }
            tag = parser.getEventType();
            name = parser.getName();
        }
        parser.nextTag();
        return resp;
    }
}

