/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sldsupport.impl.sld.parsing;

import java.io.IOException;
import java.util.List;
import org.gvsig.sldsupport.exception.InvalidSLDObjectException;
import org.gvsig.sldsupport.exception.SLDReadException;
import org.gvsig.sldsupport.exception.UnsupportedSLDObjectException;
import org.gvsig.sldsupport.impl.sld.parsing.GraphicFillElement;
import org.gvsig.sldsupport.impl.sld.parsing.GraphicStrokeElement;
import org.gvsig.sldsupport.impl.sld.parsing.SvgCssParameterElement;
import org.gvsig.sldsupport.impl.util.SLDUtils;
import org.gvsig.sldsupport.impl.util.XmlBuilder;
import org.gvsig.sldsupport.sld.filter.expression.SLDExpression;
import org.gvsig.sldsupport.sld.filter.expression.operator.SLDLiteral;
import org.gvsig.sldsupport.sld.graphic.SLDGraphicFill;
import org.gvsig.sldsupport.sld.graphic.SLDGraphicStroke;
import org.gvsig.sldsupport.sld.symbol.misc.SLDParameterValue;
import org.gvsig.sldsupport.sld.symbol.misc.SLDStroke;
import org.gvsig.sldsupport.sld.symbol.misc.SLDSvgCssParameter;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class StrokeElement {
    public static void append(SLDStroke obj, XmlBuilder xb, String version) throws InvalidSLDObjectException, UnsupportedSLDObjectException {
        List list;
        SLDSvgCssParameter p;
        SLDParameterValue pv = null;
        xb.openTag("Stroke");
        if (obj.getStrokeType() == 1) {
            if (obj.getGraphic() == null) {
                throw new InvalidSLDObjectException("Stroke", "No graphic found as graphic fill");
            }
            SLDGraphicFill gf = new SLDGraphicFill(obj.getGraphic());
            GraphicFillElement.append(gf, xb, version);
        } else if (obj.getStrokeType() == 2) {
            if (obj.getGraphic() == null) {
                throw new InvalidSLDObjectException("Stroke", "No graphic found as graphic stroke");
            }
            SLDGraphicStroke gs = new SLDGraphicStroke(obj.getGraphic());
            if (obj.getGraphicStrokeGap() != null) {
                pv = new SLDParameterValue();
                pv.getExpressionList().add(new SLDLiteral(SLDUtils.df.format(obj.getGraphicStrokeGap())));
                gs.setGap(pv);
            }
            if (obj.getGraphicStrokeInitialGap() != null) {
                pv = new SLDParameterValue();
                pv.getExpressionList().add(new SLDLiteral(SLDUtils.df.format(obj.getGraphicStrokeInitialGap())));
                gs.setInitialGap(pv);
            }
            GraphicStrokeElement.append(gs, xb, version);
        }
        if (obj.getColor() != null) {
            p = new SLDSvgCssParameter();
            p.setName("stroke");
            p.getExpressionList().add(obj.getColor());
            SvgCssParameterElement.append(p, xb, version);
        }
        if (obj.getWidth() != null) {
            p = new SLDSvgCssParameter();
            p.setName("stroke-width");
            p.getExpressionList().add(obj.getWidth());
            SvgCssParameterElement.append(p, xb, version);
        }
        if (obj.getOpacity() != null) {
            p = new SLDSvgCssParameter();
            p.setName("stroke-opacity");
            p.getExpressionList().add(obj.getOpacity());
            SvgCssParameterElement.append(p, xb, version);
        }
        if (obj.getLineCap() != null) {
            p = new SLDSvgCssParameter();
            p.setName("stroke-linecap");
            p.getExpressionList().add(obj.getLineCap());
            SvgCssParameterElement.append(p, xb, version);
        }
        if (obj.getLineJoin() != null) {
            p = new SLDSvgCssParameter();
            p.setName("stroke-linejoin");
            p.getExpressionList().add(obj.getLineJoin());
            SvgCssParameterElement.append(p, xb, version);
        }
        if (obj.getDashOffset() != null) {
            p = new SLDSvgCssParameter();
            p.setName("stroke-dashoffset");
            p.getExpressionList().add(obj.getDashOffset());
            SvgCssParameterElement.append(p, xb, version);
        }
        if ((list = obj.getDashArray()) != null && list.size() > 0) {
            String arr = SLDUtils.getAsString(list, " ");
            SLDSvgCssParameter p2 = new SLDSvgCssParameter();
            p2.setName("stroke-dasharray");
            p2.getExpressionList().add(new SLDLiteral(arr));
            SvgCssParameterElement.append(p2, xb, version);
        }
        xb.closeTag();
    }

    public static SLDStroke parse(XmlPullParser parser, String version) throws XmlPullParserException, IOException, SLDReadException {
        parser.require(2, null, "Stroke");
        int tag = 0;
        SLDStroke resp = new SLDStroke();
        tag = parser.nextTag();
        String name = parser.getName();
        Object txt = null;
        Object attName = null;
        while (!SLDUtils.isStr(name, "Stroke") || tag != 3) {
            switch (tag) {
                case 2: {
                    SLDGraphicFill gf;
                    if (SLDUtils.isStr(name, "GraphicFill")) {
                        gf = GraphicFillElement.parse(parser, version);
                        resp.setStrokeType(1);
                        resp.setGraphic(gf.getGraphic());
                        break;
                    }
                    if (SLDUtils.isStr(name, "GraphicStroke")) {
                        gf = GraphicStrokeElement.parse(parser, version);
                        resp.setStrokeType(2);
                        resp.setGraphic(gf.getGraphic());
                        break;
                    }
                    if (SLDUtils.isStr(name, "CssParameter") || SLDUtils.isStr(name, "SvgParameter")) {
                        SLDExpression expr;
                        SLDSvgCssParameter sp = SvgCssParameterElement.parse(parser, version);
                        if (SLDUtils.isStr(sp.getName(), "stroke")) {
                            if (sp.getExpressionList().size() <= 0) break;
                            resp.setColor((SLDExpression)sp.getExpressionList().get(0));
                            break;
                        }
                        if (SLDUtils.isStr(sp.getName(), "stroke-opacity")) {
                            if (sp.getExpressionList().size() <= 0) break;
                            resp.setOpacity((SLDExpression)sp.getExpressionList().get(0));
                            break;
                        }
                        if (SLDUtils.isStr(sp.getName(), "stroke-width")) {
                            if (sp.getExpressionList().size() <= 0) break;
                            resp.setWidth((SLDExpression)sp.getExpressionList().get(0));
                            break;
                        }
                        if (SLDUtils.isStr(sp.getName(), "stroke-linejoin")) {
                            if (sp.getExpressionList().size() <= 0) break;
                            resp.setLineJoin((SLDExpression)sp.getExpressionList().get(0));
                            break;
                        }
                        if (SLDUtils.isStr(sp.getName(), "stroke-linecap")) {
                            if (sp.getExpressionList().size() <= 0) break;
                            resp.setLineCap((SLDExpression)sp.getExpressionList().get(0));
                            break;
                        }
                        if (SLDUtils.isStr(sp.getName(), "stroke-dashoffset")) {
                            if (sp.getExpressionList().size() <= 0) break;
                            resp.setDashOffset((SLDExpression)sp.getExpressionList().get(0));
                            break;
                        }
                        if (!SLDUtils.isStr(sp.getName(), "stroke-dasharray") || sp.getExpressionList().size() <= 0 || !((expr = (SLDExpression)sp.getExpressionList().get(0)) instanceof SLDLiteral)) break;
                        SLDLiteral lite = (SLDLiteral)expr;
                        List<Float> floats = SLDUtils.getAsFloats(lite.getValue(), " ");
                        resp.getDashArray().addAll(floats);
                        break;
                    }
                    throw new SLDReadException("Bad SLD file. Unexpected entity in stroke: " + name);
                }
                case 3: {
                    break;
                }
            }
            tag = parser.getEventType();
            name = parser.getName();
        }
        parser.nextTag();
        return resp;
    }
}

