/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sldsupport.impl.sld.parsing.filteroperator.spatial;

import java.awt.geom.Point2D;
import java.io.IOException;
import org.gvsig.sldsupport.exception.InvalidSLDObjectException;
import org.gvsig.sldsupport.exception.SLDReadException;
import org.gvsig.sldsupport.exception.UnsupportedSLDObjectException;
import org.gvsig.sldsupport.impl.util.SLDUtils;
import org.gvsig.sldsupport.impl.util.XmlBuilder;
import org.gvsig.sldsupport.sld.filter.operator.spatial.GMLEnvelope;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class EnvelopeElement {
    public static void append(GMLEnvelope obj, XmlBuilder xb, String version) throws InvalidSLDObjectException, UnsupportedSLDObjectException {
        xb.openTag("Envelope");
        String pair = SLDUtils.df.format(obj.getLowerCorner().getX());
        pair = pair + " ";
        pair = pair + SLDUtils.df.format(obj.getLowerCorner().getY());
        xb.writeTag("lowerCorner", pair);
        pair = SLDUtils.df.format(obj.getUpperCorner().getX());
        pair = pair + " ";
        pair = pair + SLDUtils.df.format(obj.getUpperCorner().getY());
        xb.writeTag("upperCorner", pair);
        xb.closeTag();
    }

    public static GMLEnvelope parse(XmlPullParser parser, String version) throws XmlPullParserException, IOException, SLDReadException {
        parser.require(2, null, "Envelope");
        int tag = 0;
        GMLEnvelope resp = new GMLEnvelope();
        tag = parser.nextTag();
        String name = parser.getName();
        String txt = null;
        while (!SLDUtils.isStr(name, "Envelope") || tag != 3) {
            switch (tag) {
                case 2: {
                    Point2D po;
                    if (SLDUtils.isStr(name, "lowerCorner")) {
                        txt = parser.nextText();
                        po = SLDUtils.parsePair(txt);
                        resp.setLowerCorner(po);
                        parser.nextTag();
                        break;
                    }
                    if (SLDUtils.isStr(name, "upperCorner")) {
                        txt = parser.nextText();
                        po = SLDUtils.parsePair(txt);
                        resp.setUpperCorner(po);
                        parser.nextTag();
                        break;
                    }
                    throw new SLDReadException("Bad SLD file. Unexpected entity in envelope: " + name);
                }
                case 3: {
                    break;
                }
            }
            tag = parser.getEventType();
            name = parser.getName();
        }
        parser.nextTag();
        return resp;
    }
}

