/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sldsupport.impl.util;

import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.sldsupport.exception.SLDReadException;
import org.gvsig.sldsupport.impl.parser.ExtendedKXmlParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class SLDUtils {
    private static Logger logger = LoggerFactory.getLogger(SLDUtils.class);
    public static final String DEFAULT_ENCODING = "utf-8";
    public static final String VERSION_1_0_0 = "1.0.0";
    public static final String VERSION_1_1_0 = "1.1.0";
    public static final String DEFAULT_VERSION = "1.0.0";
    public static DecimalFormat df = null;

    public static String detectVersion(File infile) throws XmlPullParserException, IOException, SLDReadException {
        ExtendedKXmlParser parser = new ExtendedKXmlParser();
        FileInputStream fis = new FileInputStream(infile);
        parser.setInput(fis, DEFAULT_ENCODING);
        int tag = parser.getEventType();
        if (tag == 0) {
            parser.nextTag();
        } else if (tag != 2) {
            throw new IOException("Misplaced input stream (it's not before opening tag)");
        }
        String value = parser.getAttributeValue(null, "version");
        fis.close();
        if (value == null) {
            throw new SLDReadException("Version attribute not found");
        }
        return value;
    }

    public static String getTextUntilTag(XmlPullParser parser) throws XmlPullParserException, IOException {
        String resp = "";
        int t = 4;
        while (t != 2 && t != 3 && t != 1) {
            t = parser.getEventType();
            if (t == 4) {
                resp = resp + parser.getText();
            }
            t = parser.next();
        }
        return resp;
    }

    public static boolean isStr(String a, String b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.compareToIgnoreCase(b) == 0;
    }

    public static int parseInteger(String str) {
        int resp = -1;
        try {
            resp = Integer.parseInt(str);
        }
        catch (Exception ex) {
            logger.info("Unable to parse integer: " + str + ", returned -1");
        }
        return resp;
    }

    public static Point2D parsePair(String str) {
        Point2D.Double resp = null;
        try {
            String[] xy = str.split(" ");
            double x = Double.parseDouble(xy[0]);
            double y = Double.parseDouble(xy[1]);
            resp = new Point2D.Double(x, y);
        }
        catch (Exception ex) {
            logger.info("Unable to parse doubles: " + str + ", returned 0,0");
            resp = new Point2D.Double(0.0, 0.0);
        }
        return resp;
    }

    public static double parseDouble(String str) {
        double resp = -1.0;
        try {
            resp = Double.parseDouble(str);
        }
        catch (Exception ex) {
            logger.info("Unable to parse double: " + str + ", returned -1");
        }
        return resp;
    }

    public static String getAsString(List<Float> list, String sep) {
        if (list == null || list.size() == 0) {
            return "";
        }
        String resp = df.format(list.get(0).floatValue());
        for (int i = 1; i < list.size(); ++i) {
            resp = resp + sep + df.format(list.get(i).floatValue());
        }
        return resp;
    }

    public static List<Float> getAsFloats(String value, String sep) {
        ArrayList<Float> resp = new ArrayList<Float>();
        if (value != null) {
            String[] pp = value.split(sep);
            float fi = 0.0f;
            for (int i = 0; i < pp.length; ++i) {
                try {
                    fi = Float.parseFloat(pp[i]);
                    resp.add(new Float(fi));
                    continue;
                }
                catch (Exception ex) {
                    logger.info("Unable to parse float in flaot array: " + pp[i]);
                }
            }
        }
        return resp;
    }

    static {
        DecimalFormatSymbols dformater_rules = new DecimalFormatSymbols();
        dformater_rules.setDecimalSeparator('.');
        df = new DecimalFormat("##########.0##########", dformater_rules);
    }
}

