/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.roimask;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.ROIException;
import org.gvsig.geoprocess.lib.sextante.AbstractSextanteGeoProcess;
import org.gvsig.geoprocess.lib.sextante.dataObjects.FLyrRasterIRasterLayer;
import org.gvsig.raster.algorithm.RasterBaseAlgorithmLibrary;
import org.gvsig.raster.algorithm.process.DataProcess;
import org.gvsig.raster.algorithm.process.ProcessException;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.roi.ROI;
import org.gvsig.raster.roimask.algorithm.ROIMaskProcess;

public class ROIMaskSextanteAlgorithm
extends AbstractSextanteGeoProcess {
    public static final String RESULT = "RESULT";
    public static final String LAYER = ROIMaskProcess.RASTER_STORE1;
    public static final String ALPHA = ROIMaskProcess.ALPHA;
    public static final String INVERSE = ROIMaskProcess.INVERSE;
    public static final String NODATA = ROIMaskProcess.NODATA;

    public void defineCharacteristics() {
        this.setName(this.getTranslation("mask"));
        this.setGroup(this.getTranslation("basic_raster_algorithms"));
        try {
            this.m_Parameters.addInputRasterLayer(LAYER, this.getTranslation("Input_layer"), true);
            this.m_Parameters.addNumericalValue(ALPHA, this.getTranslation("alpha"), 0.0, 1);
            this.m_Parameters.addBoolean(INVERSE, this.getTranslation("Inverse"), false);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        this.addOutputRasterLayer(RESULT, this.getTranslation("mask"));
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        if (this.existsOutPutFile(RESULT, 0)) {
            throw new GeoAlgorithmExecutionException(this.getTranslation("file_exists"));
        }
        IRasterLayer input = this.m_Parameters.getParameterValueAsRasterLayer(LAYER);
        int alpha = this.m_Parameters.getParameterValueAsInt(ALPHA);
        boolean inverse = this.m_Parameters.getParameterValueAsBoolean(INVERSE);
        FLyrRaster lyrRaster = (FLyrRaster)input.getBaseDataObject();
        ROI[] rois = null;
        IRasterLayer output = null;
        DataProcess task = null;
        AnalysisExtent ext = this.getAnalysisExtent();
        Extent bbox = RasterLocator.getManager().getDataStructFactory().createExtent(ext.getXMin(), ext.getYMax(), ext.getXMax(), ext.getYMin());
        try {
            output = this.getNewRORasterLayer(RESULT, Sextante.getText((String)"Mask_image"), input.getDataType(), input.getBandsCount());
            rois = lyrRaster.getRois().toArray(new ROI[lyrRaster.getRois().size()]);
            task = RasterBaseAlgorithmLibrary.getManager().createRasterTask("ROIMaskProcess");
        }
        catch (ProcessException e1) {
            Sextante.addErrorToLog((Throwable)e1);
        }
        catch (ROIException e1) {
            Sextante.addErrorToLog((Throwable)e1);
        }
        String fileName = ((FLyrRasterIRasterLayer)output).getName();
        task.addParam(ROIMaskProcess.PATH, (Object)fileName);
        task.addParam(ROIMaskProcess.RASTER_STORE1, (Object)lyrRaster.getDataStore());
        task.addParam(ROIMaskProcess.ROIS, (Object)rois);
        task.addParam(ROIMaskProcess.ALPHA, (Object)alpha);
        task.addParam(ROIMaskProcess.INVERSE, (Object)inverse);
        task.addParam(ROIMaskProcess.NODATA, (Object)lyrRaster.getNoDataValue());
        task.addParam(ROIMaskProcess.WINDOW, (Object)bbox);
        task.addParam(ROIMaskProcess.OUTPUT_WIDTH, (Object)ext.getNX());
        task.addParam(ROIMaskProcess.OUTPUT_HEIGHT, (Object)ext.getNY());
        try {
            task.execute();
            ((FLyrRasterIRasterLayer)output).setBaseDataObject(fileName);
        }
        catch (ProcessInterruptedException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (ProcessException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        return !this.getTaskMonitor().isCanceled();
    }
}

