/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.ods.lib.impl;

import com.github.miachm.SODS.spreadsheet.Range;
import com.github.miachm.SODS.spreadsheet.Sheet;
import com.github.miachm.SODS.spreadsheet.SpreadSheet;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.ods.lib.api.ODSDocument;
import org.gvsig.ods.lib.impl.Spread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpreadSODS
implements Spread {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpreadSODS.class);
    private InputStream source;
    private Locale locale;

    @Override
    public File getFile() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void open(File source, Locale locale) {
        try {
            FileInputStream is = new FileInputStream(source);
            this.open(is, locale);
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException("Can' open ODS file '" + Objects.toString(source) + "'.", ex);
        }
    }

    public void open(InputStream source, Locale locale) {
        this.source = source;
        this.locale = locale;
        this.source.mark(Integer.MAX_VALUE);
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeQuietly((InputStream)this.source);
        this.source = null;
        this.locale = null;
    }

    @Override
    public ODSDocument.Sheet getSheet(int sheetIndex) {
        try {
            if (this.source == null || sheetIndex < 0) {
                return null;
            }
            return new SODSSheet(this.source, sheetIndex, this.locale);
        }
        catch (IOException ex) {
            return null;
        }
    }

    @Override
    public List<String> getSheetNames() {
        try {
            SpreadSheet spread = new SpreadSheet(this.source);
            ArrayList<String> r = new ArrayList<String>();
            for (int n = 0; n < spread.getNumSheets(); ++n) {
                r.add(spread.getSheet(n).getName());
            }
            return r;
        }
        catch (IOException ex) {
            return Collections.emptyList();
        }
    }

    private static class SODSSheet
    implements ODSDocument.Sheet {
        private int sheetIndex;
        private Sheet ODSSheet;
        private Range usedRange = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SODSSheet(InputStream odsis, int sheetIndex, Locale locale) throws IOException {
            try {
                SpreadSheet spread = new SpreadSheet(odsis, locale);
                this.ODSSheet = spread.getSheet(sheetIndex);
            }
            finally {
                odsis.reset();
            }
            this.sheetIndex = sheetIndex;
        }

        public int getColumnCount() {
            return this.getUsedData().getNumColumns();
        }

        public Rectangle getUsedRange() {
            Range x = this.getUsedData();
            return new Rectangle(x.getColumn(), x.getRow(), x.getNumColumns(), x.getNumRows());
        }

        public List<String> getColumnNames(boolean isFirstLineHedaer) {
            int i;
            int columns = this.getColumnCount();
            ArrayList<String> columnNames = new ArrayList<String>(columns);
            String abc = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
            if (columns > abc.length()) {
                for (i = 0; i < columns; ++i) {
                    columnNames.add("C" + i);
                }
            } else {
                for (i = 0; i < columns; ++i) {
                    columnNames.add(abc.substring(i, i + 1));
                }
            }
            if (isFirstLineHedaer) {
                for (int col = 0; col < columns; ++col) {
                    Object value = this.getValueAt(col, 0);
                    String s = Objects.toString(value);
                    if (StringUtils.isBlank((CharSequence)s)) continue;
                    columnNames.set(col, s);
                }
            }
            return columnNames;
        }

        private Range getUsedData() {
            if (this.usedRange == null) {
                Range data = this.ODSSheet.getDataRange();
                int minCol = -1;
                int minRow = -1;
                int maxCol = -1;
                int maxRow = -1;
                int colCount = data.getNumColumns();
                int rowCount = data.getNumRows();
                for (int row = 0; row < rowCount; ++row) {
                    for (int col = 0; col < colCount; ++col) {
                        Object value = data.getCell(row, col).getValue();
                        if (value == null) continue;
                        if (minCol < 0 || col < minCol) {
                            minCol = col;
                        }
                        if (minRow < 0 || row < minRow) {
                            minRow = row;
                        }
                        if (maxCol < 0 || col > maxCol) {
                            maxCol = col;
                        }
                        if (maxRow >= 0 && row <= maxRow) continue;
                        maxRow = row;
                    }
                }
                this.usedRange = this.ODSSheet.getRange(minRow, minCol, maxRow - minRow + 1, maxCol - minCol + 1);
            }
            return this.usedRange;
        }

        public String getName() {
            return this.ODSSheet.getName();
        }

        public int getRowCount() {
            return this.getUsedData().getNumRows();
        }

        public int getSheetIndex() {
            return this.sheetIndex;
        }

        public Object getValueAt(int col, int row) {
            Range data = this.getUsedData();
            Object value = data.getCell(row, col).getValue();
            if (row < 5 && col < 10) {
                LOGGER.info("getValueAt: row " + row + ", col " + col + ", value " + value);
            }
            return value;
        }

        public void close() {
            this.ODSSheet = null;
            this.sheetIndex = -1;
            this.usedRange = null;
        }
    }
}

