/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wmts.io.downloader;

import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URL;
import org.gvsig.compat.net.ICancellable;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.raster.cache.tile.Tile;
import org.gvsig.raster.cache.tile.exception.TileGettingException;
import org.gvsig.raster.impl.provider.tile.BaseTileDownloader;
import org.gvsig.raster.wmts.io.WMTSDataParameters;
import org.gvsig.raster.wmts.ogc.WMTSClient;
import org.gvsig.raster.wmts.ogc.WMTSOGCLocator;
import org.gvsig.raster.wmts.ogc.WMTSStatus;
import org.gvsig.raster.wmts.ogc.exception.ServerErrorException;
import org.gvsig.raster.wmts.ogc.exception.WMTSException;

public class TileDownloaderForWMTS
extends BaseTileDownloader {
    private WMTSClient ogcClient = null;

    public TileDownloaderForWMTS(RasterDataStore store, int tilePxWidth, int tilePxHeight) {
        super(store, tilePxWidth, tilePxHeight);
    }

    public WMTSClient getOGCClient() throws WMTSException {
        if (this.ogcClient == null) {
            WMTSDataParameters p = (WMTSDataParameters)this.store.getParameters();
            this.ogcClient = p.getOGCClient();
            if (this.ogcClient != null) {
                return this.ogcClient;
            }
            URL url = null;
            try {
                url = p.getURI().toURL();
            }
            catch (Exception e) {
                throw new WMTSException("Malformed URL", (Throwable)e);
            }
            try {
                this.ogcClient = WMTSOGCLocator.getManager().createWMTSClient(url.toString());
                this.ogcClient.connect(false, new ICancellable(){

                    public boolean isCanceled() {
                        return false;
                    }

                    public Object getID() {
                        return null;
                    }
                });
            }
            catch (ConnectException e) {
                throw new WMTSException("Connect exception", (Throwable)e);
            }
            catch (IOException e) {
                throw new WMTSException("Connect exception", (Throwable)e);
            }
        }
        return this.ogcClient;
    }

    public synchronized Tile downloadTile(Tile tile) throws TileGettingException {
        try {
            WMTSStatus status = (WMTSStatus)tile.getDownloaderParams("WMTSStatus");
            status.setTileRow(tile.getRow());
            status.setTileCol(tile.getCol());
            String urlFromTemplate = status.getResourceURL(tile.getRow() + "" + tile.getCol() + "");
            File f = null;
            f = urlFromTemplate != null ? this.getOGCClient().getTile(urlFromTemplate, tile.getCancelled(), tile.getFile()) : this.getOGCClient().getTile(status, tile.getCancelled(), tile.getFile());
            tile.setFile(f);
        }
        catch (WMTSException e) {
            throw new TileGettingException((Throwable)e);
        }
        catch (ServerErrorException e) {
            throw new TileGettingException((Throwable)e);
        }
        this.readTileFromDisk(tile);
        return tile;
    }
}

